/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.DefaultHandle;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class AbstractNode
extends Node {
    private static final String[] icons = new String[]{"", "32", "", "32", "Open", "Open32", "Open", "Open32"};
    private static final int ICON_BASE = -1;
    private static final int OPENED_ICON_BASE = 3;
    private static final PasteType[] NO_PASTE_TYPES = new PasteType[0];
    private static final NewType[] NO_NEW_TYPES = new NewType[0];
    private static final String DEFAULT_ICON_BASE = "org/openide/resources/defaultNode";
    private static final String DEFAULT_ICON_EXTENSION = ".gif";
    private static final String DEFAULT_ICON = "org/openide/resources/defaultNode.gif";
    private static final WeakHashMap overridesGetDefaultAction = new WeakHashMap(27);
    protected MessageFormat displayFormat;
    private Action preferredAction;
    private String iconBase = "org/openide/resources/defaultNode";
    private String iconExtension = ".gif";
    private Object lookup;
    private Sheet sheet;
    protected SystemAction[] systemActions;
    private SheetAndCookieListener sheetCookieL = null;

    public AbstractNode(Children children) {
        this(children, null);
    }

    public AbstractNode(Children children, Lookup lookup) {
        super(children, lookup);
        super.setName("");
    }

    public Node cloneNode() {
        try {
            if (this instanceof Cloneable) {
                return (Node)this.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return new FilterNode(this);
    }

    public void setName(String string) {
        super.setName(string);
        MessageFormat messageFormat = this.displayFormat;
        if (messageFormat != null) {
            this.setDisplayName(messageFormat.format(new Object[]{string}));
        } else {
            this.fireDisplayNameChange(null, null);
        }
    }

    public void setIconBase(String string) {
        this.setIconBaseWithExtension(string, DEFAULT_ICON_EXTENSION);
    }

    public final void setIconBaseWithExtension(String string) {
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        if (n2 > n || n == -1) {
            this.setIconBaseWithExtension(string, "");
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n);
            this.setIconBaseWithExtension(string2, string3);
        }
    }

    private final void setIconBaseWithExtension(String string, String string2) {
        if (string.equals(this.iconBase) && string2.equals(this.iconExtension)) {
            return;
        }
        this.iconBase = string;
        this.iconExtension = string2;
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Image getIcon(int n) {
        return this.findIcon(n, -1);
    }

    public Image getOpenedIcon(int n) {
        return this.findIcon(n, 3);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private Image findIcon(int n, int n2) {
        String string = this.iconBase + icons[n + n2] + this.iconExtension;
        Image image = Utilities.loadImage((String)string, (boolean)true);
        if (image != null) {
            return image;
        }
        string = this.iconBase + icons[1 + n2] + this.iconExtension;
        image = Utilities.loadImage((String)string, (boolean)true);
        if (image != null) {
            return image;
        }
        if (n2 == 3) {
            return this.findIcon(n, -1);
        }
        return this.getDefaultIcon();
    }

    Image getDefaultIcon() {
        Image image = Utilities.loadImage((String)DEFAULT_ICON, (boolean)true);
        if (image == null) {
            throw new MissingResourceException("No default icon", "", DEFAULT_ICON);
        }
        return image;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    protected final synchronized void setSheet(Sheet sheet) {
        this.setSheetImpl(sheet);
        this.firePropertySetsChange(null, null);
    }

    private synchronized void setSheetImpl(Sheet sheet) {
        if (this.sheetCookieL == null) {
            this.sheetCookieL = new SheetAndCookieListener();
        }
        if (this.sheet != null) {
            this.sheet.removePropertyChangeListener(this.sheetCookieL);
        }
        sheet.addPropertyChangeListener(this.sheetCookieL);
        this.sheet = sheet;
    }

    protected Sheet createSheet() {
        return new Sheet();
    }

    protected final synchronized Sheet getSheet() {
        if (this.sheet != null) {
            return this.sheet;
        }
        this.setSheetImpl(this.createSheet());
        return this.sheet;
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet sheet = this.getSheet();
        return sheet.toArray();
    }

    boolean propertySetsAreKnown() {
        return this.sheet != null;
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable(this, 1);
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable(this, 4);
    }

    public Transferable drag() throws IOException {
        return this.clipboardCopy();
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        NodeTransfer.Paste paste = NodeTransfer.findPaste(transferable);
        if (paste != null) {
            list.addAll(Arrays.asList(paste.types(this)));
        }
    }

    public final PasteType[] getPasteTypes(Transferable transferable) {
        LinkedList linkedList = new LinkedList();
        this.createPasteTypes(transferable, linkedList);
        return linkedList.toArray(NO_PASTE_TYPES);
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        LinkedList linkedList = new LinkedList();
        this.createPasteTypes(transferable, linkedList);
        return linkedList.isEmpty() ? null : (PasteType)linkedList.get(0);
    }

    public NewType[] getNewTypes() {
        return NO_NEW_TYPES;
    }

    private boolean overridesAMethod(String string, Class[] classArray) {
        try {
            Method method = this.getClass().getMethod(string, classArray);
            if (method.getDeclaringClass() != AbstractNode.class) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action getPreferredAction() {
        boolean bl = false;
        Class<?> clazz = this.getClass();
        if (clazz != AbstractNode.class) {
            WeakHashMap weakHashMap = overridesGetDefaultAction;
            synchronized (weakHashMap) {
                Boolean bl2;
                Object v = overridesGetDefaultAction.get(clazz);
                if (v == this) {
                    overridesGetDefaultAction.put(clazz, Boolean.FALSE);
                    return this.preferredAction;
                }
                if (v == null) {
                    Boolean bl3 = bl2 = this.overridesAMethod("getDefaultAction", new Class[0]) ? Boolean.TRUE : Boolean.FALSE;
                    if (bl2.booleanValue()) {
                        overridesGetDefaultAction.put(clazz, this);
                        this.getDefaultAction();
                        if (overridesGetDefaultAction.get(clazz) == this) {
                            overridesGetDefaultAction.put(clazz, bl2);
                        }
                    } else {
                        overridesGetDefaultAction.put(clazz, bl2);
                    }
                } else {
                    bl2 = (Boolean)v;
                }
                bl = bl2;
            }
        }
        return bl ? this.getDefaultAction() : this.preferredAction;
    }

    public SystemAction getDefaultAction() {
        Action action = this.getPreferredAction();
        if (action instanceof SystemAction) {
            return (SystemAction)action;
        }
        return null;
    }

    public void setDefaultAction(SystemAction systemAction) {
        this.preferredAction = systemAction;
    }

    public SystemAction[] getActions() {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
            if (this.systemActions == null) {
                this.systemActions = super.getActions();
            }
        }
        return this.systemActions;
    }

    protected SystemAction[] createActions() {
        return null;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public Component getCustomizer() {
        return null;
    }

    protected final synchronized void setCookieSet(CookieSet cookieSet) {
        CookieSet cookieSet2;
        if (this.internalLookup(false) != null) {
            throw new IllegalStateException("CookieSet cannot be used when lookup is associated with the node");
        }
        if (this.sheetCookieL == null) {
            this.sheetCookieL = new SheetAndCookieListener();
        }
        if ((cookieSet2 = (CookieSet)this.lookup) != null) {
            cookieSet2.removeChangeListener(this.sheetCookieL);
        }
        cookieSet.addChangeListener(this.sheetCookieL);
        this.lookup = cookieSet;
        this.fireCookieChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CookieSet getCookieSet() {
        if (this.internalLookup(false) != null) {
            throw new IllegalStateException("CookieSet cannot be used when lookup is associated with the node");
        }
        CookieSet cookieSet = (CookieSet)this.lookup;
        if (cookieSet != null) {
            return cookieSet;
        }
        AbstractNode abstractNode = this;
        synchronized (abstractNode) {
            if (this.lookup != null) {
                return (CookieSet)this.lookup;
            }
            this.setCookieSet(new CookieSet());
            return (CookieSet)this.lookup;
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        if (this.lookup instanceof CookieSet) {
            CookieSet cookieSet = (CookieSet)this.lookup;
            return cookieSet.getCookie(clazz);
        }
        return super.getCookie(clazz);
    }

    public Node.Handle getHandle() {
        return DefaultHandle.createHandle(this);
    }

    private final class SheetAndCookieListener
    implements PropertyChangeListener,
    ChangeListener {
        SheetAndCookieListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractNode.this.firePropertySetsChange(null, null);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractNode.this.fireCookieChange();
        }
    }
}

