/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;

final class MetaInfServicesLookup
extends AbstractLookup {
    private static final boolean DEBUG;
    private static final Map knownInstances;
    private final Set classes = new WeakSet();
    private final ClassLoader loader;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;

    public MetaInfServicesLookup() {
        this(MetaInfServicesLookup.class.getClassLoader());
    }

    public MetaInfServicesLookup(ClassLoader classLoader) {
        this.loader = classLoader;
        if (DEBUG) {
            System.err.println("Created: " + this);
        }
    }

    public String toString() {
        return "MetaInfServicesLookup[" + this.loader + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void beforeLookup(Lookup.Template template) {
        HashSet hashSet;
        Class clazz = template.getType();
        MetaInfServicesLookup metaInfServicesLookup = this;
        synchronized (metaInfServicesLookup) {
            if (!this.classes.add(clazz)) {
                return;
            }
            LinkedHashSet linkedHashSet = this.getPairsAsLHS();
            this.search(clazz, linkedHashSet);
            hashSet = this.setPairsAndCollectListeners(linkedHashSet);
        }
        this.notifyCollectedListeners(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(Class clazz, Collection collection) {
        Item item;
        Class<?> clazz2;
        Enumeration<URL> enumeration;
        if (DEBUG) {
            System.err.println("Searching for " + clazz.getName() + " in " + clazz.getClassLoader() + " from " + this);
        }
        String string = "META-INF/services/" + clazz.getName();
        try {
            enumeration = this.loader.getResources(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            if (!bl) {
                bl = true;
                clazz2 = null;
                try {
                    clazz2 = this.loader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz2 != clazz) {
                    if (DEBUG) {
                        if (clazz2 != null) {
                            System.err.println(clazz.getName() + " is not the real McCoy! Actually found it in " + clazz2.getClassLoader());
                        } else {
                            System.err.println(clazz.getName() + " could not be found in " + this.loader);
                        }
                    }
                    return;
                }
            }
            clazz2 = enumeration.nextElement();
            item = null;
            try {
                InputStream inputStream = ((URL)((Object)clazz2)).openStream();
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if ((string2 = string2.trim()).startsWith("#position=")) {
                            if (item == null && !$assertionsDisabled) {
                                throw new AssertionError((Object)("Found line '" + string2 + "' but there is no item to associate it with!"));
                            }
                            try {
                                item.position = Integer.parseInt(string2.substring(10));
                            }
                            catch (NumberFormatException numberFormatException) {
                                numberFormatException.printStackTrace();
                            }
                        }
                        if (item != null) {
                            this.insertItem(item, arrayList);
                            item = null;
                        }
                        if (string2.length() == 0) continue;
                        boolean bl2 = false;
                        if (string2.charAt(0) == '#') {
                            if (string2.length() == 1 || string2.charAt(1) != '-') continue;
                            bl2 = true;
                            string2 = string2.substring(2);
                        }
                        Class<?> clazz3 = null;
                        try {
                            clazz3 = Class.forName(string2, false, this.loader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (bl2) continue;
                            throw classNotFoundException;
                        }
                        if (!clazz.isAssignableFrom(clazz3)) {
                            if (DEBUG) {
                                System.err.println("Not a subclass");
                            }
                            throw new ClassNotFoundException(clazz3.getName() + " not a subclass of " + clazz.getName());
                        }
                        if (bl2) {
                            arrayList2.add(clazz3);
                            continue;
                        }
                        item = new Item();
                        item.clazz = clazz3;
                    }
                    if (item == null) continue;
                    this.insertItem(item, arrayList);
                    item = null;
                }
                finally {
                    inputStream.close();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (DEBUG) {
            System.err.println("Found impls of " + clazz.getName() + ": " + arrayList + " and removed: " + arrayList2 + " from: " + this);
        }
        arrayList.removeAll(arrayList2);
        clazz2 = arrayList.iterator();
        while (clazz2.hasNext()) {
            item = (Item)clazz2.next();
            if (arrayList2.contains(item.clazz)) continue;
            collection.add(new P(item.clazz));
        }
    }

    private void insertItem(Item item, List list) {
        if (item.position == -1) {
            list.add(item);
            return;
        }
        int n = -1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ++n;
            Item item2 = (Item)iterator.next();
            if (item2.position == -1) {
                list.add(n, item);
                return;
            }
            if (item2.position <= item.position) continue;
            list.add(n, item);
            return;
        }
        list.add(item);
    }

    static {
        $assertionsDisabled = !MetaInfServicesLookup.class.desiredAssertionStatus();
        DEBUG = Boolean.getBoolean("org.openide.util.lookup.MetaInfServicesLookup.DEBUG");
        knownInstances = new WeakHashMap();
    }

    private static class Item {
        private Class clazz;
        private int position = -1;

        private Item() {
        }
    }

    private static final class P
    extends AbstractLookup.Pair {
        private Object object;

        public P(Class clazz) {
            this.object = clazz;
        }

        private Class clazz() {
            Object object = this.object;
            if (object instanceof Class) {
                return (Class)object;
            }
            if (object != null) {
                return object.getClass();
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = MetaInfServicesLookup.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public boolean equals(Object object) {
            if (object instanceof P) {
                return ((P)object).clazz().equals(this.clazz());
            }
            return false;
        }

        public int hashCode() {
            return this.clazz().hashCode();
        }

        protected boolean instanceOf(Class clazz) {
            return clazz.isAssignableFrom(this.clazz());
        }

        public Class getType() {
            return this.clazz();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getInstance() {
            Object object = this.object;
            if (object instanceof Class) {
                Object object2 = object;
                synchronized (object2) {
                    try {
                        Class clazz = (Class)object;
                        Map map = knownInstances;
                        synchronized (map) {
                            object = knownInstances.get(clazz);
                        }
                        if (object == null) {
                            object = clazz.newInstance();
                            map = knownInstances;
                            synchronized (map) {
                                knownInstances.put(clazz, object);
                            }
                        }
                        this.object = object;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.object = null;
                    }
                }
            }
            return this.object;
        }

        public String getDisplayName() {
            return this.clazz().getName();
        }

        public String getId() {
            return this.clazz().getName();
        }

        protected boolean creatorOf(Object object) {
            return object == this.object;
        }
    }
}

