/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.openide.util.lookup.AbstractLookup;

public final class InstanceContent
extends AbstractLookup.Content {
    public final void add(Object object) {
        this.addPair(new SimpleItem(object));
    }

    public final void add(Object object, Convertor convertor) {
        this.addPair(new ConvertingItem(object, convertor));
    }

    public final void remove(Object object) {
        this.removePair(new SimpleItem(object));
    }

    public final void remove(Object object, Convertor convertor) {
        this.removePair(new ConvertingItem(object, convertor));
    }

    public final void set(Collection collection, Convertor convertor) {
        ArrayList<AbstractLookup.Pair> arrayList = new ArrayList<AbstractLookup.Pair>(collection.size());
        Iterator iterator = collection.iterator();
        if (convertor == null) {
            while (iterator.hasNext()) {
                arrayList.add(new SimpleItem(iterator.next()));
            }
        } else {
            while (iterator.hasNext()) {
                arrayList.add(new ConvertingItem(iterator.next(), convertor));
            }
        }
        this.setPairs(arrayList);
    }

    static final class ConvertingItem
    extends AbstractLookup.Pair {
        private Object obj;
        private WeakReference ref;
        private Convertor conv;

        public ConvertingItem(Object object, Convertor convertor) {
            this.obj = object;
            this.conv = convertor;
        }

        public boolean instanceOf(Class clazz) {
            return clazz.isAssignableFrom(this.getType());
        }

        private Object getConverted() {
            if (this.ref == null) {
                return null;
            }
            return this.ref.get();
        }

        public synchronized Object getInstance() {
            Object object = this.getConverted();
            if (object == null) {
                object = this.conv.convert(this.obj);
                this.ref = new WeakReference<Object>(object);
            }
            return object;
        }

        public boolean equals(Object object) {
            if (object instanceof ConvertingItem) {
                return this.obj.equals(((ConvertingItem)object).obj);
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public String getId() {
            return this.conv.id(this.obj);
        }

        public String getDisplayName() {
            return this.conv.displayName(this.obj);
        }

        protected boolean creatorOf(Object object) {
            if (this.conv == null) {
                return object == this.obj;
            }
            return object == this.getConverted();
        }

        public Class getType() {
            if (this.conv == null) {
                return this.obj.getClass();
            }
            Object object = this.getConverted();
            if (object == null) {
                return this.conv.type(this.obj);
            }
            return object.getClass();
        }
    }

    public static interface Convertor {
        public Object convert(Object var1);

        public Class type(Object var1);

        public String id(Object var1);

        public String displayName(Object var1);
    }

    static final class SimpleItem
    extends AbstractLookup.Pair {
        private Object obj;

        public SimpleItem(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.obj = object;
        }

        public boolean instanceOf(Class clazz) {
            return clazz.isInstance(this.obj);
        }

        public Object getInstance() {
            return this.obj;
        }

        public boolean equals(Object object) {
            if (object instanceof SimpleItem) {
                return this.obj.equals(((SimpleItem)object).obj);
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public String getId() {
            return "IL[" + this.obj.toString();
        }

        public String getDisplayName() {
            return this.obj.toString();
        }

        protected boolean creatorOf(Object object) {
            return object == this.obj;
        }

        public Class getType() {
            return this.obj.getClass();
        }
    }
}

