/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.util.MutexException;
import org.openide.util.Utilities;

public final class Mutex {
    public static final Mutex EVENT;
    static boolean beStrict;
    private static final int NONE = 0;
    private static final int CHAIN = 1;
    private static final int X = 2;
    private static final int S = 3;
    private static final int MODE_COUNT = 4;
    private static final boolean[][] cmatrix;
    private int grantedMode = 0;
    private Object LOCK;
    private Map registeredThreads;
    private int readersNo = 0;
    private List waiters;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Mutex(Object object) {
        this.init(object);
    }

    public Mutex() {
        this.init(new InternalLock());
    }

    public Mutex(Privileged privileged) {
        if (privileged == null) {
            throw new IllegalArgumentException("privileged == null");
        }
        this.init(new InternalLock());
        privileged.setParent(this);
    }

    private static boolean compatibleLocks(int n, int n2) {
        return cmatrix[n2][n];
    }

    private void init(Object object) {
        this.LOCK = object;
        this.registeredThreads = new HashMap(7);
        this.waiters = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readAccess(Action action) {
        if (this == EVENT) {
            try {
                return Mutex.doEventAccess(action);
            }
            catch (MutexException mutexException) {
                InternalError internalError = new InternalError("Exception from non-Exception Action");
                ErrorManager.getDefault().annotate((Throwable)internalError, mutexException.getException());
                throw internalError;
            }
        }
        Thread thread = Thread.currentThread();
        this.readEnter(thread);
        try {
            Object object = action.run();
            return object;
        }
        finally {
            this.leave(thread);
        }
    }

    public Object readAccess(ExceptionAction exceptionAction) throws MutexException {
        if (this == EVENT) {
            return Mutex.doEventAccess(exceptionAction);
        }
        Thread thread = Thread.currentThread();
        this.readEnter(thread);
        try {
            Object object = exceptionAction.run();
            return object;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new MutexException(exception);
        }
        finally {
            this.leave(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAccess(Runnable runnable) {
        if (this == EVENT) {
            Mutex.doEvent(runnable);
            return;
        }
        Thread thread = Thread.currentThread();
        this.readEnter(thread);
        try {
            runnable.run();
        }
        finally {
            this.leave(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object writeAccess(Action action) {
        if (this == EVENT) {
            try {
                return Mutex.doEventAccess(action);
            }
            catch (MutexException mutexException) {
                InternalError internalError = new InternalError("Exception from non-Exception Action");
                ErrorManager.getDefault().annotate((Throwable)internalError, mutexException.getException());
                throw internalError;
            }
        }
        Thread thread = Thread.currentThread();
        this.writeEnter(thread);
        try {
            Object object = action.run();
            return object;
        }
        finally {
            this.leave(thread);
        }
    }

    public Object writeAccess(ExceptionAction exceptionAction) throws MutexException {
        if (this == EVENT) {
            return Mutex.doEventAccess(exceptionAction);
        }
        Thread thread = Thread.currentThread();
        this.writeEnter(thread);
        try {
            Object object = exceptionAction.run();
            return object;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new MutexException(exception);
        }
        finally {
            this.leave(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAccess(Runnable runnable) {
        if (this == EVENT) {
            Mutex.doEvent(runnable);
            return;
        }
        Thread thread = Thread.currentThread();
        this.writeEnter(thread);
        try {
            runnable.run();
        }
        finally {
            this.leave(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadAccess() {
        if (this == EVENT) {
            return SwingUtilities.isEventDispatchThread();
        }
        Thread thread = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo threadInfo = this.getThreadInfo(thread);
            if (threadInfo != null && threadInfo.counts[3] > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteAccess() {
        if (this == EVENT) {
            return SwingUtilities.isEventDispatchThread();
        }
        Thread thread = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo threadInfo = this.getThreadInfo(thread);
            if (threadInfo != null && threadInfo.counts[2] > 0) {
                return true;
            }
        }
        return false;
    }

    public void postReadRequest(Runnable runnable) {
        this.postRequest(3, runnable);
    }

    public void postWriteRequest(Runnable runnable) {
        this.postRequest(2, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this == EVENT) {
            return "Mutex.EVENT";
        }
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(512);
        Object object = this.LOCK;
        synchronized (object) {
            stringBuffer.append("threads: ").append(this.registeredThreads).append(string);
            stringBuffer.append("readersNo: ").append(this.readersNo).append(string);
            stringBuffer.append("waiters: ").append(this.waiters).append(string);
            stringBuffer.append("grantedMode: ").append(this.grantedMode).append(string);
        }
        return stringBuffer.toString();
    }

    private void writeEnter(Thread thread) {
        this.enter(2, thread, true);
    }

    private void readEnter(Thread thread) {
        this.enter(3, thread, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enter(int n, Thread thread, boolean bl) {
        QueueCell queueCell = null;
        int n2 = 0;
        while (true) {
            ++n2;
            Object object = this.LOCK;
            synchronized (object) {
                ThreadInfo threadInfo = this.getThreadInfo(thread);
                if (threadInfo != null) {
                    IllegalStateException illegalStateException;
                    if (this.grantedMode == 0) {
                        throw new IllegalStateException();
                    }
                    if (threadInfo.mode == 3 && this.grantedMode == 2 || threadInfo.mode == 2 && this.grantedMode == 3) {
                        throw new IllegalStateException();
                    }
                    if (threadInfo.mode == 2 || threadInfo.mode == n) {
                        if (threadInfo.forced) {
                            threadInfo.forced = false;
                        } else {
                            if (n == 2 && threadInfo.counts[3] > 0) {
                                illegalStateException = new IllegalStateException("WARNING: Going from readAccess to writeAccess, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                                if (beStrict) {
                                    throw illegalStateException;
                                }
                                ErrorManager.getDefault().notify(illegalStateException);
                            }
                            int n3 = n;
                            threadInfo.counts[n3] = threadInfo.counts[n3] + 1;
                            if (n == 3 && threadInfo.counts[n] == 1) {
                                ++this.readersNo;
                            }
                        }
                        return true;
                    }
                    if (this.canUpgrade(threadInfo.mode, n)) {
                        illegalStateException = new IllegalStateException("WARNING: Going from readAccess to writeAccess, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                        if (beStrict) {
                            throw illegalStateException;
                        }
                        ErrorManager.getDefault().notify(illegalStateException);
                        threadInfo.mode = 2;
                        int n4 = n;
                        threadInfo.counts[n4] = threadInfo.counts[n4] + 1;
                        threadInfo.rsnapshot = threadInfo.counts[3];
                        if (this.grantedMode == 3) {
                            this.grantedMode = 2;
                        } else if (this.grantedMode == 2) {
                            throw new IllegalStateException();
                        }
                        return true;
                    }
                    illegalStateException = new IllegalStateException("WARNING: Going from readAccess to writeAccess through queue, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                    if (beStrict) {
                        throw illegalStateException;
                    }
                    ErrorManager.getDefault().notify(illegalStateException);
                } else if (this.isCompatible(n)) {
                    this.grantedMode = n;
                    threadInfo = new ThreadInfo(thread, n);
                    this.registeredThreads.put(thread, threadInfo);
                    if (n == 3) {
                        ++this.readersNo;
                    }
                    return true;
                }
                if (!bl) {
                    return false;
                }
                this.grantedMode = 1;
                queueCell = this.chain(n, thread, 0);
            }
            queueCell.sleep();
        }
    }

    private boolean reenter(Thread thread, int n) {
        boolean bl;
        if (n == 3) {
            if (this.grantedMode != 0 && this.grantedMode != 3) {
                throw new IllegalStateException(this.toString());
            }
            this.enter(n, thread, true);
            return false;
        }
        ThreadInfo threadInfo = this.getThreadInfo(thread);
        boolean bl2 = bl = this.grantedMode == 1 && threadInfo != null && threadInfo.counts[2] > 0;
        if (this.grantedMode == 2 || this.grantedMode == 0 || bl) {
            this.enter(n, thread, true);
            return false;
        }
        if (this.readersNo == 0) {
            throw new IllegalStateException(this.toString());
        }
        ThreadInfo threadInfo2 = new ThreadInfo(thread, n);
        this.registeredThreads.put(thread, threadInfo2);
        this.readersNo += 2;
        this.grantedMode = 1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privilegedEnter(Thread thread, int n) {
        boolean bl = true;
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo threadInfo = this.getThreadInfo(thread);
        }
        while (true) {
            Object object2 = this.LOCK;
            synchronized (object2) {
                if (bl) {
                    bl = false;
                    this.readersNo -= 2;
                }
                this.grantedMode = 1;
                object = this.chain(n, thread, Integer.MAX_VALUE);
                if (this.readersNo == 0) {
                    if (this.waiters.get(0) == object) {
                        this.waiters.remove(0);
                        return;
                    }
                    this.grantedMode = 0;
                    this.wakeUpOthers();
                }
            }
            ((QueueCell)object).sleep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leave(Thread thread) {
        int n;
        ThreadInfo threadInfo;
        int n2 = 0;
        boolean bl = false;
        Object object = this.LOCK;
        synchronized (object) {
            threadInfo = this.getThreadInfo(thread);
            switch (this.grantedMode) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    if (threadInfo.counts[2] > 0) {
                        n2 = this.leaveX(threadInfo);
                        break;
                    }
                    if (threadInfo.counts[3] > 0) {
                        n2 = this.leaveS(threadInfo);
                        break;
                    }
                    throw new IllegalStateException();
                }
                case 2: {
                    n2 = this.leaveX(threadInfo);
                    break;
                }
                case 3: {
                    n2 = this.leaveS(threadInfo);
                }
            }
            if (n2 != 0 && (n = threadInfo.getRunnableCount(n2)) != 0) {
                bl = this.reenter(thread, n2);
            }
        }
        if (n2 != 0 && threadInfo.getRunnableCount(n2) > 0) {
            try {
                if (bl) {
                    this.privilegedEnter(thread, n2);
                }
                object = threadInfo.dequeue(n2);
                n = object.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        Runnable runnable = (Runnable)object.get(i);
                        runnable.run();
                        continue;
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(exception);
                        continue;
                    }
                    catch (StackOverflowError stackOverflowError) {
                        stackOverflowError.printStackTrace();
                        ErrorManager.getDefault().notify(stackOverflowError);
                        continue;
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Error error) {
                        ErrorManager.getDefault().notify(error);
                    }
                }
                object = null;
            }
            finally {
                this.leave(thread);
            }
        }
    }

    private int leaveX(ThreadInfo threadInfo) {
        if (threadInfo.counts[2] <= 0 || threadInfo.rsnapshot > threadInfo.counts[3]) {
            throw new IllegalStateException();
        }
        if (threadInfo.rsnapshot == threadInfo.counts[3]) {
            threadInfo.counts[2] = threadInfo.counts[2] - 1;
            if (threadInfo.counts[2] == 0) {
                threadInfo.rsnapshot = 0;
                if (threadInfo.counts[3] > 0) {
                    this.grantedMode = 3;
                    threadInfo.mode = 3;
                } else {
                    this.grantedMode = 0;
                    threadInfo.mode = 0;
                    this.registeredThreads.remove(threadInfo.t);
                }
                if (threadInfo.getRunnableCount(3) > 0) {
                    this.wakeUpReaders();
                    return 3;
                }
                this.wakeUpOthers();
            }
        } else {
            if (threadInfo.counts[3] <= 0) {
                throw new IllegalStateException();
            }
            threadInfo.counts[3] = threadInfo.counts[3] - 1;
            if (threadInfo.counts[3] == 0) {
                if (this.readersNo <= 0) {
                    throw new IllegalStateException();
                }
                --this.readersNo;
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int leaveS(ThreadInfo threadInfo) {
        if (threadInfo.counts[3] <= 0 || threadInfo.counts[2] > 0) {
            throw new IllegalStateException();
        }
        threadInfo.counts[3] = threadInfo.counts[3] - 1;
        if (threadInfo.counts[3] == 0) {
            threadInfo.mode = 0;
            this.registeredThreads.remove(threadInfo.t);
            if (this.readersNo <= 0) {
                throw new IllegalStateException();
            }
            --this.readersNo;
            if (this.readersNo == 0) {
                this.grantedMode = 0;
                if (threadInfo.getRunnableCount(2) > 0) {
                    return 2;
                }
                this.wakeUpOthers();
            } else {
                if (threadInfo.getRunnableCount(2) > 0) {
                    return 2;
                }
                if (this.grantedMode == 1 && this.readersNo == 1) {
                    for (int i = 0; i < this.waiters.size(); ++i) {
                        QueueCell queueCell;
                        QueueCell queueCell2 = queueCell = (QueueCell)this.waiters.get(i);
                        synchronized (queueCell2) {
                            if (queueCell.isGotOut()) {
                                this.waiters.remove(i--);
                                continue;
                            }
                            ThreadInfo threadInfo2 = this.getThreadInfo(queueCell.t);
                            if (threadInfo2 != null && threadInfo2.mode == 3) {
                                if (queueCell.mode != 2) {
                                    throw new IllegalStateException();
                                }
                                if (this.waiters.size() == 1) {
                                    this.grantedMode = 2;
                                }
                                threadInfo2.mode = 2;
                                this.waiters.remove(i);
                                queueCell.wakeMeUp();
                            }
                            break;
                        }
                    }
                }
            }
        }
        return 0;
    }

    private QueueCell chain(int n, Thread thread, int n2) {
        QueueCell queueCell = new QueueCell(n, thread);
        queueCell.priority2 = n2;
        int n3 = this.waiters.size();
        if (n3 == 0) {
            this.waiters.add(queueCell);
        } else if (queueCell.getPriority() == Integer.MAX_VALUE) {
            this.waiters.add(0, queueCell);
        } else {
            int n4 = 0;
            do {
                QueueCell queueCell2;
                if ((queueCell2 = (QueueCell)this.waiters.get(n4)).getPriority() >= queueCell.getPriority()) continue;
                this.waiters.add(n4, queueCell);
                break;
            } while (++n4 < n3);
            if (n4 == n3) {
                this.waiters.add(queueCell);
            }
        }
        return queueCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpOthers() {
        if (this.grantedMode == 2 || this.grantedMode == 1) {
            throw new IllegalStateException();
        }
        if (this.waiters.size() == 0) {
            return;
        }
        for (int i = 0; i < this.waiters.size(); ++i) {
            QueueCell queueCell;
            QueueCell queueCell2 = queueCell = (QueueCell)this.waiters.get(i);
            synchronized (queueCell2) {
                if (queueCell.isGotOut()) {
                    this.waiters.remove(i--);
                    continue;
                }
                if (Mutex.compatibleLocks(this.grantedMode, queueCell.mode)) {
                    this.waiters.remove(i--);
                    queueCell.wakeMeUp();
                    this.grantedMode = queueCell.mode;
                    if (this.getThreadInfo(queueCell.t) == null) {
                        ThreadInfo threadInfo = new ThreadInfo(queueCell.t, queueCell.mode);
                        threadInfo.forced = true;
                        if (queueCell.mode == 3) {
                            ++this.readersNo;
                        }
                        this.registeredThreads.put(queueCell.t, threadInfo);
                    }
                } else {
                    this.grantedMode = 1;
                    break;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpReaders() {
        if (!$assertionsDisabled && this.grantedMode != 0 && this.grantedMode != 3) {
            throw new AssertionError();
        }
        if (this.waiters.size() == 0) {
            return;
        }
        for (int i = 0; i < this.waiters.size(); ++i) {
            QueueCell queueCell;
            QueueCell queueCell2 = queueCell = (QueueCell)this.waiters.get(i);
            synchronized (queueCell2) {
                if (queueCell.isGotOut()) {
                    this.waiters.remove(i--);
                    continue;
                }
                if (queueCell.mode == 3) {
                    this.waiters.remove(i--);
                    queueCell.wakeMeUp();
                    this.grantedMode = 3;
                    if (this.getThreadInfo(queueCell.t) == null) {
                        ThreadInfo threadInfo = new ThreadInfo(queueCell.t, queueCell.mode);
                        threadInfo.forced = true;
                        ++this.readersNo;
                        this.registeredThreads.put(queueCell.t, threadInfo);
                    }
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRequest(int n, Runnable runnable) {
        ThreadInfo threadInfo;
        if (this == EVENT) {
            Mutex.doEventRequest(runnable);
            return;
        }
        Thread thread = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            threadInfo = this.getThreadInfo(thread);
            if (threadInfo != null) {
                if (n == threadInfo.mode && threadInfo.counts[5 - n] == 0) {
                    this.enter(n, thread, true);
                } else {
                    threadInfo.enqueue(n, runnable);
                    return;
                }
            }
        }
        if (threadInfo == null) {
            this.enter(n, thread, true);
            try {
                runnable.run();
            }
            finally {
                this.leave(thread);
            }
            return;
        }
        try {
            runnable.run();
        }
        finally {
            this.leave(thread);
        }
    }

    private boolean isCompatible(int n) {
        return Mutex.compatibleLocks(this.grantedMode, n);
    }

    private ThreadInfo getThreadInfo(Thread thread) {
        return (ThreadInfo)this.registeredThreads.get(thread);
    }

    private boolean canUpgrade(int n, int n2) {
        return n == 3 && n2 == 2 && this.readersNo == 1;
    }

    private static void doEvent(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private static void doEventRequest(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    private static Object doEventAccess(final ExceptionAction exceptionAction) throws MutexException {
        if (Mutex.isDispatchThread()) {
            try {
                return exceptionAction.run();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new MutexException(exception);
            }
        }
        final Throwable[] throwableArray = new Throwable[1];
        try {
            final Object[] objectArray = new Object[1];
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        objectArray[0] = exceptionAction.run();
                    }
                    catch (Exception exception) {
                        throwableArray[0] = exception;
                    }
                    catch (LinkageError linkageError) {
                        throwableArray[0] = linkageError;
                    }
                    catch (StackOverflowError stackOverflowError) {
                        throwableArray[0] = stackOverflowError;
                    }
                }
            });
            if (throwableArray[0] == null) {
                return objectArray[0];
            }
        }
        catch (InterruptedException interruptedException) {
            throwableArray[0] = interruptedException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwableArray[0] = invocationTargetException;
        }
        if (throwableArray[0] instanceof RuntimeException) {
            throw (RuntimeException)throwableArray[0];
        }
        throw Mutex.notifyException(4096, throwableArray[0]);
    }

    static boolean isDispatchThread() {
        boolean bl = EventQueue.isDispatchThread();
        if (!bl && Utilities.getOperatingSystem() == 8) {
            bl = Thread.currentThread().getClass().getName().indexOf("EventDispatchThread") >= 0;
        }
        return bl;
    }

    private static final MutexException notifyException(int n, Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = Mutex.unfoldInvocationTargetException((InvocationTargetException)throwable);
        }
        if (throwable instanceof Error) {
            Mutex.annotateEventStack(throwable);
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            Mutex.annotateEventStack(throwable);
            throw (RuntimeException)throwable;
        }
        MutexException mutexException = new MutexException((Exception)throwable);
        ErrorManager.getDefault().annotate((Throwable)mutexException, throwable);
        return mutexException;
    }

    private static final void annotateEventStack(Throwable throwable) {
        ErrorManager.getDefault().annotate(throwable, new Exception("Caught here in mutex"));
    }

    private static final Throwable unfoldInvocationTargetException(InvocationTargetException invocationTargetException) {
        Throwable throwable;
        while ((invocationTargetException = (throwable = invocationTargetException.getTargetException()) instanceof InvocationTargetException ? (InvocationTargetException)throwable : null) != null) {
        }
        return throwable;
    }

    static {
        $assertionsDisabled = !Mutex.class.desiredAssertionStatus();
        EVENT = new Mutex();
        cmatrix = new boolean[][]{null, null, {true, false, false, false}, {true, false, false, true}};
    }

    public static interface Action
    extends ExceptionAction {
        public Object run();
    }

    public static interface ExceptionAction {
        public Object run() throws Exception;
    }

    private static final class InternalLock {
        InternalLock() {
        }
    }

    public static final class Privileged {
        private Mutex parent;

        final void setParent(Mutex mutex) {
            this.parent = mutex;
        }

        public void enterReadAccess() {
            this.parent.readEnter(Thread.currentThread());
        }

        public void enterWriteAccess() {
            this.parent.writeEnter(Thread.currentThread());
        }

        public void exitReadAccess() {
            this.parent.leave(Thread.currentThread());
        }

        public void exitWriteAccess() {
            this.parent.leave(Thread.currentThread());
        }
    }

    private static final class QueueCell {
        int mode;
        Thread t;
        boolean signal;
        boolean left;
        int priority2;

        public QueueCell(int n, Thread thread) {
            this.mode = n;
            this.t = thread;
            this.left = false;
            this.priority2 = 0;
        }

        public String toString() {
            return super.toString() + " mode: " + this.mode + " thread: " + this.t;
        }

        public long getPriority() {
            return this.priority2 == 0 ? this.t.getPriority() : this.priority2;
        }

        public boolean isGotOut() {
            return this.left;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void sleep() {
            block7: {
                while (true) {
                    if (this.signal) break block7;
                    try {
                        this.wait();
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        ErrorManager.getDefault().notify(1, interruptedException);
                    }
                }
                finally {
                    this.left = true;
                }
            }
        }

        public void wakeMeUp() {
            this.signal = true;
            this.notifyAll();
        }
    }

    private static final class ThreadInfo {
        boolean forced;
        final Thread t;
        int mode;
        int[] counts;
        List[] queues;
        int rsnapshot;

        public ThreadInfo(Thread thread, int n) {
            this.t = thread;
            this.mode = n;
            this.counts = new int[4];
            this.queues = new List[4];
            this.counts[n] = 1;
        }

        public String toString() {
            return super.toString() + " thread: " + this.t + " mode: " + this.mode + " X: " + this.counts[2] + " S: " + this.counts[3];
        }

        public void enqueue(int n, Runnable runnable) {
            if (this.queues[n] == null) {
                this.queues[n] = new ArrayList(13);
            }
            this.queues[n].add(runnable);
        }

        public List dequeue(int n) {
            List list = this.queues[n];
            this.queues[n] = null;
            return list;
        }

        public int getRunnableCount(int n) {
            return this.queues[n] == null ? 0 : this.queues[n].size();
        }
    }
}

