/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.calendar;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class CalendarPrefs {
    private static final Logger LOG = Logger.getLogger("tr.prefs.calendar");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/calendar");
    private static final String KEY_REQUIRED = "icalendar.required";
    private static final boolean DEF_REQUIRED = false;
    private static final String KEY_PATH = "icalendar.path";
    private static final String DEF_PATH = System.getProperty("user.home");

    public static final boolean isICalendarRequired() {
        return prefs.getBoolean(KEY_REQUIRED, false);
    }

    public static final void setICalendarRequired(boolean value) {
        prefs.putBoolean(KEY_REQUIRED, value);
        CalendarPrefs.flush();
    }

    public static final String getICalendarPath() {
        return prefs.get(KEY_PATH, DEF_PATH);
    }

    public static final void setICalendarPath(String value) {
        prefs.put(KEY_PATH, value);
        CalendarPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Calendar preferences error. " + ex.getMessage());
        }
    }
}

