/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.prefs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.extract.prefs.ExtractOptionsPanelController;
import tr.extract.prefs.ExtractPrefs;

final class ExtractPanel
extends JPanel {
    private final ExtractOptionsPanelController controller;
    private JButton folderButton;
    private JLabel folderLabel;
    private JTextField folderTextField;

    ExtractPanel(ExtractOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.folderTextField.getDocument().addDocumentListener(new FolderDocumentListener());
        this.folderButton = new JButton();
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)this.getOutputText());
        this.folderButton.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((AbstractButton)this.folderButton, (String)this.getBrowseText());
        this.folderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractPanel.this.browse(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.folderLabel, -2, 116, -2).addPreferredGap(0).add((Component)this.folderTextField, -1, 169, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.folderButton)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.folderButton).add((Component)this.folderTextField, -2, -1, -2).add((Component)this.folderLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browse(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.folderTextField.getText()));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            try {
                this.folderTextField.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.folderTextField.setText("");
            }
        }
    }

    private String getOutputText() {
        return NbBundle.getMessage(this.getClass(), (String)"Output");
    }

    private String getBrowseText() {
        return NbBundle.getMessage(this.getClass(), (String)"Browse");
    }

    void load() {
        this.folderTextField.setText(ExtractPrefs.getPath());
    }

    void store() {
        if (this.valid()) {
            String path = this.tidyPath(this.folderTextField.getText());
            ExtractPrefs.setPath(path);
        }
    }

    boolean valid() {
        String path = this.tidyPath(this.folderTextField.getText());
        return path.length() == 0 || new File(path).isDirectory();
    }

    private String tidyPath(String path) {
        path = path.trim();
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1).trim();
        }
        return path;
    }

    private class FolderDocumentListener
    implements DocumentListener {
        private FolderDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            ExtractPanel.this.controller.changed();
        }

        public void removeUpdate(DocumentEvent e) {
            ExtractPanel.this.controller.changed();
        }

        public void changedUpdate(DocumentEvent e) {
            ExtractPanel.this.controller.changed();
        }
    }
}

