/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.io.File;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import org.openide.util.NbBundle;
import tr.extract.ExtractData;
import tr.extract.Param;
import tr.extract.XSL;
import tr.extract.XSLFO;
import tr.extract.prefs.ExtractPrefs;
import tr.global.Constants;
import tr.model.Data;
import tr.runtime.Open;
import tr.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Extract {
    public abstract String getID();

    public abstract String getName();

    public abstract List<Param> getParams();

    public abstract void process(Data var1) throws Exception;

    public String getDialogTitleReport(String reportName) {
        return NbBundle.getMessage(Extract.class, (String)"param-dialog-title-report", (Object)reportName);
    }

    public String getDialogTitleExport(String exportName) {
        return NbBundle.getMessage(Extract.class, (String)"param-dialog-title-export", (Object)exportName);
    }

    public final String getString(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public final String getTimeStamp() {
        return Constants.DF_TIMESTAMP.format(Calendar.getInstance().getTime());
    }

    public final File getTmpFile(String filename) throws Exception {
        return new File(Utils.getTempDir(), filename);
    }

    public final File getOutFile(String filename) {
        return new File(ExtractPrefs.getPath(), filename);
    }

    public final void extractData(Data data, File extractFile) {
        ExtractData.process(data, extractFile);
    }

    public final void openFile(File file) {
        Open.openFile((File)file);
    }

    public final void openTextFile(File file) {
        Open.openTextFile((File)file);
    }

    public final void transformXSLFO(File xml, URL xslfo, List<Param> params, File out) throws Exception {
        XSLFO.transform(xml, xslfo.openStream(), params, out);
    }

    public final void transformXSL(File xml, URL xsl, List<Param> params, File out) throws Exception {
        XSL.transform(xml, xsl.openStream(), params, out);
    }
}

