/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.WinClassicEditorTabCellRenderer;

public final class WinClassicEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final int[] xpoints = new int[20];
    private static final int[] ypoints = new int[20];
    private static final Rectangle scratch5 = new Rectangle();
    private static boolean isGenericUI = !"Windows".equals(UIManager.getLookAndFeel().getID());
    private static final int ICON_WIDTH = 17;
    private static final int ICON_HEIGHT = 14;

    public WinClassicEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinClassicEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    public Rectangle getTabRect(int n, Rectangle rectangle) {
        Rectangle rectangle2 = super.getTabRect(n, rectangle);
        rectangle2.y = 0;
        rectangle2.height = this.displayer.getHeight();
        return rectangle2;
    }

    public void install() {
        super.install();
        if (!isGenericUI) {
            this.displayer.setBackground(UIManager.getColor("tab_unsel_fill"));
            this.displayer.setOpaque(true);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 28;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + (isGenericUI ? 5 : 6);
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] abstractButtonArray = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction()), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction()), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        WinClassicEditorTabDisplayerUI.configureButton(abstractButtonArray[0], new LeftIcon());
        WinClassicEditorTabDisplayerUI.configureButton(abstractButtonArray[2], new DownIcon());
        WinClassicEditorTabDisplayerUI.configureButton(abstractButtonArray[1], new RightIcon());
        abstractButtonArray[0].setPreferredSize(new Dimension(15, 14));
        abstractButtonArray[2].setPreferredSize(new Dimension(16, 14));
        abstractButtonArray[1].setPreferredSize(new Dimension(15, 14));
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return abstractButtonArray;
    }

    private static void configureButton(JButton jButton, Icon icon) {
        jButton.setIcon(icon);
        jButton.setMargin(null);
        jButton.setText(null);
        jButton.putClientProperty("hideActionText", Boolean.TRUE);
        jButton.setFocusable(false);
        if (isGenericUI) {
            jButton.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void genericPaintAfterTabs(Graphics graphics) {
        graphics.setColor(UIManager.getColor("controlShadow"));
        Insets insets = this.displayer.getInsets();
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        boolean bl = false;
        int n = this.getLastVisibleTab();
        if (n > -1) {
            this.getTabRect(n, scratch5);
            graphics.drawLine(WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight() - 1, this.displayer.getWidth() - (insets.left + insets.right) - 4, this.displayer.getHeight() - 1);
            graphics.drawLine(0, this.displayer.getHeight() - 2, 2, this.displayer.getHeight() - 2);
            if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
                boolean bl2 = n == this.displayer.getSelectionModel().getSelectedIndex();
                int n2 = WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width;
                graphics.setColor(bl2 ? UIManager.getColor("controlShadow") : ColorUtil.adjustTowards(graphics.getColor(), 20, UIManager.getColor("control")));
                graphics.drawLine(n2, WinClassicEditorTabDisplayerUI.scratch5.y + 5, n2, WinClassicEditorTabDisplayerUI.scratch5.y + WinClassicEditorTabDisplayerUI.scratch5.height - 2);
                graphics.setColor(ColorUtil.adjustTowards(graphics.getColor(), 20, UIManager.getColor("control")));
                graphics.drawLine(n2 + 1, WinClassicEditorTabDisplayerUI.scratch5.y + 6, n2 + 1, WinClassicEditorTabDisplayerUI.scratch5.y + WinClassicEditorTabDisplayerUI.scratch5.height - 2);
            }
            if ((this.tabState.getState(this.getFirstVisibleTab()) & 2) != 0 && this.getFirstVisibleTab() != this.displayer.getSelectionModel().getSelectedIndex()) {
                GradientPaint gradientPaint = ColorUtil.getGradientPaint(0.0f, this.displayer.getHeight() / 2, UIManager.getColor("control"), 0.0f, this.displayer.getHeight(), UIManager.getColor("controlShadow"));
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.drawLine(0, this.displayer.getHeight() / 2, 0, this.displayer.getHeight());
            } else {
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(0, this.displayer.getHeight(), 0, this.displayer.getHeight() - 2);
            }
            if ((this.tabState.getState(this.getLastVisibleTab()) & 1) != 0 && this.getLastVisibleTab() != this.displayer.getSelectionModel().getSelectedIndex()) {
                GradientPaint gradientPaint = ColorUtil.getGradientPaint(0.0f, this.displayer.getHeight() / 2, UIManager.getColor("control"), 0.0f, this.displayer.getHeight(), UIManager.getColor("controlShadow"));
                ((Graphics2D)graphics).setPaint(gradientPaint);
                this.getTabRect(this.getLastVisibleTab(), scratch5);
                graphics.drawLine(WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight() / 2, WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight());
            }
        } else {
            graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width - 4, this.displayer.getHeight() - insets.bottom);
        }
    }

    protected void paintAfterTabs(Graphics graphics) {
        if (isGenericUI) {
            this.genericPaintAfterTabs(graphics);
            return;
        }
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        graphics.setColor(this.displayer.isActive() ? this.defaultRenderer.getSelectedActivatedBackground() : this.defaultRenderer.getSelectedBackground());
        Insets insets = this.getTabAreaInsets();
        ++insets.bottom;
        graphics.fillRect(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, this.displayer.getHeight() - (rectangle.y + rectangle.height));
        graphics.setColor(UIManager.getColor("controlLtHighlight"));
        int n = 0;
        int n2 = this.selectionModel.getSelectedIndex();
        if (n2 != -1) {
            this.getTabRect(n2, scratch5);
            if (WinClassicEditorTabDisplayerUI.scratch5.width != 0) {
                if (rectangle.x < WinClassicEditorTabDisplayerUI.scratch5.x) {
                    graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, WinClassicEditorTabDisplayerUI.scratch5.x - 1, this.displayer.getHeight() - insets.bottom);
                }
                if (WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width < rectangle.x + rectangle.width) {
                    n = WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width;
                    if (!this.scroll().isLastTabClipped()) {
                        --n;
                    }
                    graphics.drawLine(n, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width, this.displayer.getHeight() - insets.bottom);
                }
            }
            return;
        }
        graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width, this.displayer.getHeight() - insets.bottom);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new WinClassicEditorTabCellRenderer();
    }

    protected LayoutManager createLayout() {
        return new WCLayout();
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, 55);
    }

    private static class DownIcon
    extends LeftIcon {
        private DownIcon() {
        }

        public int getIconHeight() {
            return 14;
        }

        public int getIconWidth() {
            return 17;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            xpoints[0] = n + 4;
            ypoints[0] = ++n2 + 5;
            xpoints[1] = n + 11;
            ypoints[1] = n2 + 5;
            xpoints[2] = n + 7;
            ypoints[2] = n2 + 9;
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class LeftIcon
    implements Icon {
        protected boolean enabled = false;

        private LeftIcon() {
        }

        public int getIconHeight() {
            return 14;
        }

        public int getIconWidth() {
            return 17;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            xpoints[0] = --n + 5;
            ypoints[0] = ++n2 + 6;
            xpoints[1] = n + 9;
            ypoints[1] = n2 + 2;
            xpoints[2] = n + 9;
            ypoints[2] = n2 + 10;
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class RightIcon
    extends LeftIcon {
        private RightIcon() {
        }

        public int getIconHeight() {
            return 14;
        }

        public int getIconWidth() {
            return 17;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            xpoints[0] = n + 5;
            ypoints[0] = ++n2 + 2;
            xpoints[1] = n + 5;
            ypoints[1] = n2 + 10;
            xpoints[2] = n + 9;
            ypoints[2] = n2 + 6;
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private class WCLayout
    implements LayoutManager {
        private WCLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Insets insets = WinClassicEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] componentArray = container.getComponents();
            int n = container.getWidth() - insets.right + 4;
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension = componentArray[i].getPreferredSize();
                n2 = insets.top + 4;
                int n3 = Math.min(dimension.width, container.getWidth() - n);
                if (i == 2) {
                    n += 2;
                }
                componentArray[i].setBounds(n, n2, n3, Math.min(dimension.height, container.getHeight()));
                n += dimension.width;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return WinClassicEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return WinClassicEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

