/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.event.ArrayDiff;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.VeryComplexListDataEvent;
import org.openide.util.Utilities;

public abstract class TabState {
    public static final int CLIP_RIGHT = 1;
    public static final int CLIP_LEFT = 2;
    public static final int ARMED = 4;
    public static final int PRESSED = 8;
    public static final int SELECTED = 16;
    public static final int ACTIVE = 32;
    public static final int NOT_ONSCREEN = 64;
    public static final int LEFTMOST = 128;
    public static final int RIGHTMOST = 256;
    public static final int CLOSE_BUTTON_ARMED = 512;
    public static final int BEFORE_SELECTED = 1024;
    public static final int AFTER_SELECTED = 2048;
    public static final int MOUSE_IN_TABS_AREA = 4096;
    public static final int MOUSE_PRESSED_IN_CLOSE_BUTTON = 8192;
    public static final int ATTENTION = 16384;
    public static final int BEFORE_ARMED = 32768;
    public static int STATE_LAST = 8192;
    private int pressedIndex = -1;
    private int containsMouseIndex = -1;
    private int closeButtonContainsMouseIndex = -1;
    private int mousePressedInCloseButtonIndex = -1;
    private boolean mouseInTabsArea = false;
    private boolean active = false;
    private int selectedIndex = -1;
    private int prev = -1;
    private int curr = -1;
    private int lastChangeType = 0;
    private int lastAffected = 0;
    private int lastChange = 0;
    public static final int REPAINT_ON_MOUSE_ENTER_TAB = 1;
    public static final int REPAINT_ALL_ON_MOUSE_ENTER_TABS_AREA = 3;
    public static final int REPAINT_ON_MOUSE_ENTER_CLOSE_BUTTON = 4;
    public static final int REPAINT_ON_MOUSE_PRESSED = 8;
    public static final int REPAINT_SELECTION_ON_ACTIVATION_CHANGE = 16;
    public static final int REPAINT_ALL_TABS_ON_ACTIVATION_CHANGE = 32;
    public static final int REPAINT_ON_SELECTION_CHANGE = 64;
    public static final int REPAINT_ALL_TABS_ON_SELECTION_CHANGE = 128;
    public static final int REPAINT_ON_CLOSE_BUTTON_PRESSED = 256;
    private final HashSet alarmTabs = new HashSet(6);
    private Timer alarmTimer = null;
    private boolean attentionToggle = false;
    public static final int NO_CHANGE = 0;
    public static final int CHANGE_TAB_TO_TAB = 1;
    public static final int CHANGE_TAB_TO_NONE = 2;
    public static final int CHANGE_NONE_TO_TAB = 3;
    public static final int CHANGE_TAB_TO_SELF = 4;
    public static final int ALL_TABS = Integer.MAX_VALUE;

    public int getState(int n) {
        int n2 = 0;
        if (n == this.pressedIndex) {
            n2 |= 8;
        }
        if (n == this.containsMouseIndex) {
            n2 |= 4;
        }
        if (n == this.closeButtonContainsMouseIndex) {
            n2 |= 0x200;
        }
        if (n == this.mousePressedInCloseButtonIndex) {
            n2 |= 0x2000;
        }
        if (this.mouseInTabsArea) {
            n2 |= 0x1000;
        }
        if (this.active) {
            n2 |= 0x20;
        }
        if (n == this.selectedIndex) {
            n2 |= 0x10;
        }
        if (n != 0 && n == this.selectedIndex + 1) {
            n2 |= 0x800;
        }
        if (n == this.selectedIndex - 1) {
            n2 |= 0x400;
        }
        if (n == this.containsMouseIndex - 1) {
            n2 |= 0x8000;
        }
        if (this.isAlarmTab(n)) {
            n2 |= 0x4000;
        }
        return n2;
    }

    String getStateString(int n) {
        return TabState.stateToString(this.getState(n));
    }

    public void clearTransientStates() {
        this.pressedIndex = -1;
        this.containsMouseIndex = -1;
        this.closeButtonContainsMouseIndex = -1;
        this.mousePressedInCloseButtonIndex = -1;
        this.mouseInTabsArea = false;
        this.lastChangeType = 0;
        this.lastChange = 0;
        this.prev = -1;
        this.curr = -1;
    }

    public final int setPressed(int n) {
        this.prev = this.pressedIndex;
        this.pressedIndex = n;
        this.curr = n;
        this.possibleChange(this.prev, this.curr, 8);
        return this.prev;
    }

    public final int setContainsMouse(int n) {
        this.prev = this.containsMouseIndex;
        this.containsMouseIndex = n;
        this.curr = n;
        this.possibleChange(this.prev, this.curr, 4);
        return this.prev;
    }

    public final int setCloseButtonContainsMouse(int n) {
        this.prev = this.closeButtonContainsMouseIndex;
        this.closeButtonContainsMouseIndex = n;
        this.curr = n;
        this.possibleChange(this.prev, this.curr, 512);
        return this.prev;
    }

    public final int setMousePressedInCloseButton(int n) {
        this.prev = this.mousePressedInCloseButtonIndex;
        this.mousePressedInCloseButtonIndex = n;
        this.curr = n;
        this.possibleChange(this.prev, this.curr, 8192);
        return this.prev;
    }

    public final int setSelected(int n) {
        this.prev = this.selectedIndex;
        this.selectedIndex = n;
        this.curr = n;
        this.removeAlarmTab(n);
        this.possibleChange(this.prev, this.curr, 16);
        return this.prev;
    }

    public final boolean setMouseInTabsArea(boolean bl) {
        boolean bl2 = this.mouseInTabsArea;
        this.mouseInTabsArea = bl;
        this.possibleChange(bl2, bl, 4096);
        return bl2;
    }

    public final boolean setActive(boolean bl) {
        boolean bl2 = this.active;
        this.active = bl;
        this.possibleChange(bl2, bl, 32);
        this.removeAlarmTab(this.selectedIndex);
        return bl2;
    }

    private boolean isAlarmTab(int n) {
        return this.attentionToggle && this.alarmTabs.contains(new Integer(n));
    }

    public final void addAlarmTab(int n) {
        Integer n2 = new Integer(n);
        boolean bl = this.alarmTabs.contains(n2);
        boolean bl2 = this.alarmTabs.isEmpty();
        if (!bl) {
            this.alarmTabs.add(new Integer(n));
            this.repaintTab(n);
        }
        if (bl2) {
            this.startAlarmTimer();
            this.attentionToggle = true;
            this.repaintTab(n);
        }
    }

    public final void removeAlarmTab(int n) {
        Integer n2 = new Integer(n);
        boolean bl = this.alarmTabs.contains(n2);
        if (bl) {
            this.alarmTabs.remove(n2);
            boolean bl2 = this.alarmTabs.isEmpty();
            boolean bl3 = this.attentionToggle;
            if (this.alarmTabs.isEmpty()) {
                this.stopAlarmTimer();
            }
            if (bl3) {
                this.repaintTab(n);
            }
        }
    }

    private final void startAlarmTimer() {
        if (this.alarmTimer == null) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TabState.this.attentionToggle = !TabState.this.attentionToggle;
                    Timer timer = (Timer)actionEvent.getSource();
                    Iterator iterator = TabState.this.alarmTabs.iterator();
                    while (iterator.hasNext()) {
                        TabState.this.repaintTab((Integer)iterator.next());
                    }
                }
            };
            this.alarmTimer = new Timer(700, actionListener);
            this.alarmTimer.setRepeats(true);
        }
        this.alarmTimer.start();
    }

    private final void stopAlarmTimer() {
        if (this.alarmTimer != null && this.alarmTimer.isRunning()) {
            this.alarmTimer.stop();
            this.attentionToggle = false;
            this.repaintAllTabs();
        }
    }

    boolean hasAlarmTabs() {
        return this.alarmTabs != null && !this.alarmTabs.isEmpty();
    }

    void pruneAlarmTabs(int n) {
        if (!this.hasAlarmTabs()) {
            return;
        }
        Iterator iterator = this.alarmTabs.iterator();
        while (iterator.hasNext()) {
            if ((Integer)iterator.next() < n) continue;
            iterator.remove();
        }
        if (this.alarmTabs.isEmpty()) {
            this.stopAlarmTimer();
        }
    }

    int[] getAlarmTabs() {
        int[] nArray = (int[])Utilities.toPrimitiveArray((Object[])this.alarmTabs.toArray(new Integer[0]));
        Arrays.sort(nArray);
        return nArray;
    }

    void intervalAdded(ListDataEvent listDataEvent) {
        int n;
        if (!this.hasAlarmTabs()) {
            return;
        }
        int n2 = listDataEvent.getIndex0();
        int n3 = listDataEvent.getIndex1();
        int[] nArray = (int[])Utilities.toPrimitiveArray((Object[])this.alarmTabs.toArray(new Integer[0]));
        boolean bl = false;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < n2) continue;
            int n4 = n;
            nArray[n4] = nArray[n4] + (n3 - n2 + 1);
            bl = true;
        }
        if (bl) {
            this.alarmTabs.clear();
            for (n = 0; n < nArray.length; ++n) {
                this.addAlarmTab(nArray[n]);
            }
        }
    }

    void intervalRemoved(ListDataEvent listDataEvent) {
        int n;
        if (!this.hasAlarmTabs()) {
            return;
        }
        int n2 = listDataEvent.getIndex0();
        int n3 = listDataEvent.getIndex1();
        int[] nArray = (int[])Utilities.toPrimitiveArray((Object[])this.alarmTabs.toArray(new Integer[0]));
        Arrays.sort(nArray);
        if (n3 == n2) {
            int n4;
            boolean bl = true;
            for (n4 = 0; n4 < nArray.length; ++n4) {
                if (nArray[n4] > n3) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] - 1;
                    continue;
                }
                if (nArray[n4] != n3) continue;
                nArray[n4] = -1;
            }
            if (bl) {
                this.alarmTabs.clear();
                n4 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == -1) continue;
                    this.addAlarmTab(nArray[i]);
                    n4 = 1;
                }
                if (n4 == 0) {
                    this.stopAlarmTimer();
                }
            }
            return;
        }
        boolean bl = false;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < n2 || nArray[n] > n3) continue;
            nArray[n] = -1;
            bl = true;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] <= n3) continue;
            int n6 = n;
            nArray[n6] = nArray[n6] - (n3 - n2 + 1);
            bl = true;
        }
        if (bl) {
            this.alarmTabs.clear();
            n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) continue;
                this.addAlarmTab(nArray[i]);
                n = 1;
            }
            if (n == 0) {
                this.stopAlarmTimer();
            }
        }
    }

    void indicesAdded(ComplexListDataEvent complexListDataEvent) {
        int n;
        if (!this.hasAlarmTabs()) {
            return;
        }
        int[] nArray = (int[])Utilities.toPrimitiveArray((Object[])this.alarmTabs.toArray(new Integer[0]));
        Arrays.sort(nArray);
        int[] nArray2 = complexListDataEvent.getIndices();
        Arrays.sort(nArray2);
        boolean bl = false;
        for (n = 0; n < nArray2.length; ++n) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < nArray2[n]) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 1;
                bl = true;
            }
        }
        if (bl) {
            this.alarmTabs.clear();
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == -1) continue;
                this.addAlarmTab(nArray[n]);
            }
        }
    }

    void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
        int n;
        int n2;
        if (!this.hasAlarmTabs()) {
            return;
        }
        int[] nArray = complexListDataEvent.getIndices();
        Arrays.sort(nArray);
        int[] nArray2 = (int[])Utilities.toPrimitiveArray((Object[])this.alarmTabs.toArray(new Integer[0]));
        Arrays.sort(nArray2);
        if (nArray2[nArray2.length - 1] < nArray[0]) {
            return;
        }
        boolean bl = false;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            for (n = 0; n < nArray.length; ++n) {
                if (nArray2[n2] != nArray[n]) continue;
                nArray2[n2] = -1;
                bl = true;
            }
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            n = nArray2[n2];
            for (int i = 0; i < nArray.length; ++i) {
                if (n <= nArray[i]) continue;
                int n3 = n2;
                nArray2[n3] = nArray2[n3] - 1;
                bl = true;
            }
        }
        if (bl) {
            this.alarmTabs.clear();
            n2 = 0;
            for (n = 0; n < nArray2.length; ++n) {
                if (nArray2[n] < 0) continue;
                this.addAlarmTab(nArray2[n]);
                n2 = 1;
            }
            if (n2 == 0) {
                this.stopAlarmTimer();
            }
        }
        this.repaintAllTabs();
    }

    void indicesChanged(ComplexListDataEvent complexListDataEvent) {
        if (!this.hasAlarmTabs()) {
            return;
        }
        if (complexListDataEvent instanceof VeryComplexListDataEvent) {
            int n;
            VeryComplexListDataEvent veryComplexListDataEvent = (VeryComplexListDataEvent)complexListDataEvent;
            ArrayDiff arrayDiff = ((VeryComplexListDataEvent)complexListDataEvent).getDiff();
            List<TabData> list = Arrays.asList(arrayDiff.getOldData());
            List<TabData> list2 = Arrays.asList(arrayDiff.getNewData());
            int[] nArray = (int[])Utilities.toPrimitiveArray((Object[])this.alarmTabs.toArray(new Integer[0]));
            boolean bl = false;
            for (n = 0; n < nArray.length; ++n) {
                TabData tabData = list.get(nArray[n]);
                int n2 = list2.indexOf(tabData);
                bl |= n2 != nArray[n];
                nArray[n] = list2.indexOf(tabData);
            }
            if (bl) {
                this.alarmTabs.clear();
                n = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] < 0) continue;
                    this.addAlarmTab(nArray[i]);
                    n = 1;
                }
                if (n == 0) {
                    this.stopAlarmTimer();
                }
            }
        }
    }

    void contentsChanged(ListDataEvent listDataEvent) {
        if (!this.hasAlarmTabs()) {
            return;
        }
    }

    protected void possibleChange(boolean bl, boolean bl2, int n) {
        this.lastChangeType = bl == bl2 ? 0 : Integer.MAX_VALUE;
        if (this.lastChangeType != 0) {
            this.lastAffected = Integer.MAX_VALUE;
            this.change(Integer.MAX_VALUE, Integer.MAX_VALUE, n, this.lastChangeType);
        }
    }

    protected void possibleChange(int n, int n2, int n3) {
        this.lastChangeType = n == n2 ? 0 : (n2 == -1 ? 2 : (n == -1 ? 3 : 1));
        if (this.lastChangeType != 0) {
            this.lastAffected = n2;
            this.change(n, n2, n3, this.lastChangeType);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("TabState [lastTab=");
        stringBuffer.append(TabState.tabToString(this.prev));
        stringBuffer.append(" currTab=");
        stringBuffer.append(TabState.tabToString(this.curr));
        stringBuffer.append(" lastAffected=");
        stringBuffer.append(TabState.tabToString(this.lastAffected));
        stringBuffer.append(" lastChangeType=");
        stringBuffer.append(TabState.changeToString(this.lastChangeType));
        stringBuffer.append(" lastChange=");
        stringBuffer.append(TabState.stateToString(this.lastChange));
        stringBuffer.append(" <active=");
        stringBuffer.append(this.active);
        stringBuffer.append(" sel=");
        stringBuffer.append(TabState.tabToString(this.selectedIndex));
        stringBuffer.append(" mouse=");
        stringBuffer.append(TabState.tabToString(this.containsMouseIndex));
        stringBuffer.append(" inTabs=");
        stringBuffer.append(this.mouseInTabsArea);
        stringBuffer.append(" pressed=");
        stringBuffer.append(TabState.tabToString(this.pressedIndex));
        stringBuffer.append(" inCloseButton=");
        stringBuffer.append(TabState.tabToString(this.closeButtonContainsMouseIndex));
        stringBuffer.append(" pressedCloseButton=");
        stringBuffer.append(TabState.tabToString(this.mousePressedInCloseButtonIndex));
        stringBuffer.append(">]");
        return stringBuffer.toString();
    }

    protected void change(int n, int n2, int n3, int n4) {
        this.lastChange = n3;
        if (n4 == 1) {
            this.maybeRepaint(n, n3);
        } else {
            if (n4 == 2) {
                this.maybeRepaint(n, n3);
                return;
            }
            if (n4 == Integer.MAX_VALUE && (this.getRepaintPolicy(n2) & 3) != 0) {
                this.repaintAllTabs();
                return;
            }
        }
        this.maybeRepaint(n2, n3);
    }

    protected void maybeRepaint(int n, int n2) {
        int n3 = this.getRepaintPolicy(n);
        boolean bl = false;
        switch (n2) {
            case 32: {
                boolean bl2 = bl = (n3 & 0x10) != 0;
                if ((n3 & 0x20) == 0) break;
                n2 = Integer.MAX_VALUE;
                bl = true;
                break;
            }
            case 4: {
                bl = (n3 & 1) != 0 || n == this.closeButtonContainsMouseIndex;
                this.closeButtonContainsMouseIndex = -1;
                break;
            }
            case 512: {
                bl = (n3 & 4) != 0;
                break;
            }
            case 4096: {
                bl = (n3 & 3) != 0;
                break;
            }
            case 8192: {
                bl = (n3 & 0x100) != 0;
                break;
            }
            case 8: {
                bl = (n3 & 8) != 0;
                break;
            }
            case 16: {
                boolean bl3 = bl = (n3 & 0x40) != 0;
                if ((n3 & 0x80) == 0) break;
                n2 = Integer.MAX_VALUE;
                bl = true;
                break;
            }
            case 16384: {
                bl = true;
            }
        }
        if (bl) {
            if (n2 == Integer.MAX_VALUE) {
                this.repaintAllTabs();
            } else {
                this.repaintTab(n);
            }
        }
    }

    protected abstract void repaintTab(int var1);

    protected abstract void repaintAllTabs();

    static final String changeToString(int n) {
        switch (n) {
            case 0: {
                return "no change";
            }
            case 1: {
                return "tab to tab";
            }
            case 2: {
                return "tab to none";
            }
            case 3: {
                return "none to tab";
            }
            case 4: {
                return "tab to self";
            }
            case 0x7FFFFFFF: {
                return "all tabs";
            }
        }
        return "??? " + n;
    }

    static final String tabToString(int n) {
        if (n == Integer.MAX_VALUE) {
            return "all tabs";
        }
        if (n == -1) {
            return "none";
        }
        return Integer.toString(n);
    }

    static final String stateToString(int n) {
        String[] stringArray = new String[]{"clip right", "clip left", "armed", "pressed", "selected", "active", "not onscreen", "leftmost", "rightmost", "in closebutton", "before selected", "after selected", "mouse in tabs area", "mouse pressed in close button"};
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if ((n & nArray[i]) == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("no flags set");
        }
        stringBuffer.append("=");
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    static String repaintPolicyToString(int n) {
        if (n == 0) {
            return "repaint nothing";
        }
        String[] stringArray = new String[]{"REPAINT_ON_MOUSE_ENTER_TAB", "REPAINT_ALL_ON_MOUSE_ENTER_TABS_AREA", "REPAINT_ON_MOUSE_ENTER_CLOSE_BUTTON", "REPAINT_ON_MOUSE_PRESSED", "REPAINT_SELECTION_ON_ACTIVATION_CHANGE", "REPAINT_ALL_TABS_ON_ACTIVATION_CHANGE", "REPAINT_ON_SELECTION_CHANGE", "REPAINT_ALL_TABS_ON_SELECTION_CHANGE", "REPAINT_ON_CLOSE_BUTTON_PRESSED"};
        int[] nArray = new int[]{1, 3, 4, 8, 16, 32, 64, 128, 256};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if ((n & nArray[i]) == 0) continue;
            stringBuffer.append(stringArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append('+');
        }
        return stringBuffer.toString();
    }

    public abstract int getRepaintPolicy(int var1);
}

