/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabState;

public abstract class BasicTabDisplayerUI
extends AbstractTabDisplayerUI {
    protected TabState tabState = null;
    private static final boolean swingpainting;
    protected TabCellRenderer defaultRenderer = null;
    protected int repaintPolicy = 0;
    private Rectangle scratch = new Rectangle();
    private Rectangle scratch2 = new Rectangle();
    private Rectangle scratch3 = new Rectangle();
    private Point lastKnownMouseLocation = new Point();
    int pixelsToAdd = 0;
    static final String UNHIDE_LEFT = "unhideMeLeft";
    static final String UNHIDE_RIGHT = "unhideMeRight";
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    protected void install() {
        super.install();
        this.tabState = this.createTabState();
        this.defaultRenderer = this.createDefaultRenderer();
        this.layoutModel.setPadding(this.defaultRenderer.getPadding());
        this.pixelsToAdd = this.defaultRenderer.getPixelsToAddToSelection();
        this.repaintPolicy = this.createRepaintPolicy();
        if (this.displayer.getSelectionModel().getSelectedIndex() != -1) {
            this.tabState.setSelected(this.displayer.getSelectionModel().getSelectedIndex());
            this.tabState.setActive(this.displayer.isActive());
        }
    }

    protected void uninstall() {
        this.tabState = null;
        this.defaultRenderer = null;
        super.uninstall();
    }

    TabState getTabState() {
        return this.tabState;
    }

    protected TabState createTabState() {
        return new BasicTabState();
    }

    protected abstract TabCellRenderer createDefaultRenderer();

    public abstract Insets getTabAreaInsets();

    protected TabCellRenderer getTabCellRenderer(int n) {
        return this.defaultRenderer;
    }

    protected final void getTabsVisibleArea(Rectangle rectangle) {
        Insets insets = this.getTabAreaInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = this.displayer.getWidth() - insets.right;
        rectangle.height = this.displayer.getHeight() - insets.bottom;
    }

    protected MouseListener createMouseListener() {
        return new BasicDisplayerMouseListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasicDisplayerPropertyChangeListener();
    }

    public Polygon getExactTabIndication(int n) {
        Rectangle rectangle = this.getTabRect(n, this.scratch);
        return this.getTabCellRenderer(n).getTabShape(this.tabState.getState(n), rectangle);
    }

    public Polygon getInsertTabIndication(int n) {
        Polygon polygon;
        if (n == this.getLastVisibleTab() + 1) {
            polygon = this.getExactTabIndication(n - 1);
            Rectangle rectangle = this.getTabRect(n - 1, this.scratch);
            polygon.translate(rectangle.width / 2, 0);
        } else {
            polygon = this.getExactTabIndication(n);
            Rectangle rectangle = this.getTabRect(n, this.scratch);
            polygon.translate(-(rectangle.width / 2), 0);
        }
        return polygon;
    }

    public int tabForCoordinate(Point point) {
        if (this.displayer.getModel().size() == 0) {
            return -1;
        }
        this.getTabsVisibleArea(this.scratch);
        if (!this.scratch.contains(point)) {
            return -1;
        }
        return this.layoutModel.indexOfPoint(point.x, point.y);
    }

    public Rectangle getTabRect(int n, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (n < 0 || n >= this.displayer.getModel().size()) {
            rectangle.height = 0;
            rectangle.width = 0;
            rectangle.y = 0;
            rectangle.x = 0;
            return rectangle;
        }
        rectangle.x = this.layoutModel.getX(n);
        rectangle.y = this.layoutModel.getY(n);
        rectangle.width = this.layoutModel.getW(n);
        this.getTabsVisibleArea(this.scratch3);
        int n2 = this.scratch.x + this.scratch3.width;
        if (rectangle.x > n2) {
            rectangle.width = 0;
        } else if (rectangle.x + rectangle.width > n2) {
            rectangle.width = n2 - rectangle.x;
        }
        rectangle.height = this.layoutModel.getH(n);
        this.getTabsVisibleArea(this.scratch2);
        if (rectangle.y + rectangle.height > this.scratch2.y + this.scratch2.height) {
            rectangle.height = this.scratch2.y + this.scratch2.height - rectangle.y;
        }
        if (rectangle.x + rectangle.width > this.scratch2.x + this.scratch2.width) {
            rectangle.width = this.scratch2.x + this.scratch2.width - rectangle.x;
        }
        return rectangle;
    }

    public Image createImageOfTab(int n) {
        TabData tabData = this.displayer.getModel().getTab(n);
        JLabel jLabel = new JLabel(tabData.getText());
        int n2 = jLabel.getFontMetrics(jLabel.getFont()).stringWidth(tabData.getText());
        int n3 = jLabel.getFontMetrics(jLabel.getFont()).getHeight();
        n2 = n2 + tabData.getIcon().getIconWidth() + 6;
        n3 = Math.max(n3, tabData.getIcon().getIconHeight()) + 5;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n2, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(jLabel.getForeground());
        graphics2D.setFont(jLabel.getFont());
        tabData.getIcon().paintIcon(jLabel, graphics2D, 0, 0);
        graphics2D.drawString(tabData.getText(), 18, n3 / 2);
        return bufferedImage;
    }

    public String getCommandAtPoint(Point point) {
        int n;
        this.getTabsVisibleArea(this.scratch);
        if (this.scratch.contains(point) && (n = this.tabForCoordinate(point)) != -1) {
            TabCellRenderer tabCellRenderer = this.getTabCellRenderer(n);
            this.getTabRect(n, this.scratch);
            String string = tabCellRenderer.getCommandAtPoint(point, this.tabState.getState(n), this.scratch);
            return string;
        }
        return super.getCommandAtPoint(point);
    }

    public int dropIndexOfPoint(Point point) {
        Point point2 = this.toDropPoint(point);
        int n = this.getFirstVisibleTab();
        int n2 = this.getLastVisibleTab();
        for (int i = n; i <= n2; ++i) {
            this.getTabRect(i, this.scratch);
            if (!this.scratch.contains(point2)) continue;
            if (i == n2) {
                boolean bl;
                Object object = this.displayer.getClientProperty("orientation");
                boolean bl2 = bl = this.displayer.getType() == 2 && (object == TabDisplayer.ORIENTATION_EAST || object == TabDisplayer.ORIENTATION_WEST);
                if (bl ? point2.y > this.scratch.y + this.scratch.height / 2 : point2.x > this.scratch.x + this.scratch.width / 2) {
                    return i + 1;
                }
            }
            return i;
        }
        return -1;
    }

    protected boolean isAntialiased() {
        return ColorUtil.shouldAntialias();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics graphics, JComponent jComponent) {
        if (!$assertionsDisabled && jComponent != this.displayer) {
            throw new AssertionError();
        }
        ColorUtil.setupAntialiasing(graphics);
        boolean bl = this.displayer.isShowCloseButton();
        this.paintBackground(graphics);
        int n = this.getFirstVisibleTab();
        if (n == -1 || !this.displayer.isShowing()) {
            return;
        }
        int n2 = Math.min(this.getLastVisibleTab(), this.displayer.getModel().size() - 1);
        this.getTabsVisibleArea(this.scratch);
        if (graphics.hitClip(this.scratch.x, this.scratch.y, this.scratch.width, this.scratch.height)) {
            Shape shape = graphics.getClip();
            try {
                if (shape != null) {
                    Area area = new Area(shape);
                    area.intersect(new Area(this.scratch.getBounds2D()));
                    graphics.setClip(area);
                } else {
                    graphics.setClip(this.scratch.x, this.scratch.y, this.scratch.width, this.scratch.height);
                }
                for (int i = n; i <= n2; ++i) {
                    int n3;
                    this.getTabRect(i, this.scratch);
                    if (!graphics.hitClip(this.scratch.x, this.scratch.y, this.scratch.width + 1, this.scratch.height + 1) || ((n3 = this.tabState.getState(i)) & 0x40) != 0) continue;
                    TabCellRenderer tabCellRenderer = this.getTabCellRenderer(i);
                    tabCellRenderer.setShowCloseButton(bl);
                    TabData tabData = this.displayer.getModel().getTab(i);
                    JComponent jComponent2 = tabCellRenderer.getRendererComponent(tabData, this.scratch, n3);
                    jComponent2.setFont(this.displayer.getFont());
                    if (swingpainting) {
                        SwingUtilities.paintComponent(graphics, jComponent2, this.displayer, this.scratch);
                        continue;
                    }
                    try {
                        graphics.translate(this.scratch.x, this.scratch.y);
                        jComponent2.setBounds(this.scratch);
                        jComponent2.paint(graphics);
                        continue;
                    }
                    finally {
                        graphics.translate(-this.scratch.x, -this.scratch.y);
                    }
                }
            }
            finally {
                graphics.setClip(shape);
            }
        }
        this.paintAfterTabs(graphics);
    }

    protected void paintBackground(Graphics graphics) {
    }

    protected void paintAfterTabs(Graphics graphics) {
    }

    protected int getFirstVisibleTab() {
        return this.displayer.getModel().size() > 0 ? 0 : -1;
    }

    protected int getLastVisibleTab() {
        return this.displayer.getModel().size() - 1;
    }

    protected ChangeListener createSelectionListener() {
        return new BasicSelectionListener();
    }

    protected final Point getLastKnownMouseLocation() {
        return this.lastKnownMouseLocation;
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
    }

    protected final void requestAttention(int n) {
        this.tabState.addAlarmTab(n);
    }

    protected final void cancelRequestAttention(int n) {
        this.tabState.removeAlarmTab(n);
    }

    protected void modelChanged() {
        this.tabState.clearTransientStates();
        int n = this.selectionModel.getSelectedIndex();
        this.tabState.setSelected(n);
        this.tabState.pruneAlarmTabs(this.displayer.getModel().size());
        super.modelChanged();
    }

    protected int createRepaintPolicy() {
        return 93;
    }

    protected Rectangle getTabRectForRepaint(int n, Rectangle rectangle) {
        return this.getTabRect(n, rectangle);
    }

    protected AbstractTabDisplayerUI.ModelListener createModelListener() {
        return new BasicModelListener();
    }

    static {
        $assertionsDisabled = !BasicTabDisplayerUI.class.desiredAssertionStatus();
        swingpainting = Boolean.getBoolean("nb.tabs.swingpainting");
    }

    protected class BasicDisplayerMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private int lastPressedTab = -1;
        private long pressTime = -1L;

        protected BasicDisplayerMouseListener() {
        }

        private int updateMouseLocation(MouseEvent mouseEvent) {
            ((BasicTabDisplayerUI)BasicTabDisplayerUI.this).lastKnownMouseLocation.x = mouseEvent.getX();
            ((BasicTabDisplayerUI)BasicTabDisplayerUI.this).lastKnownMouseLocation.y = mouseEvent.getY();
            return BasicTabDisplayerUI.this.tabForCoordinate(BasicTabDisplayerUI.this.lastKnownMouseLocation);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.updateMouseLocation(mouseEvent);
            if (n == -1) {
                return;
            }
            TabCellRenderer tabCellRenderer = BasicTabDisplayerUI.this.getTabCellRenderer(n);
            BasicTabDisplayerUI.this.getTabRect(n, BasicTabDisplayerUI.this.scratch);
            int n2 = BasicTabDisplayerUI.this.tabState.getState(n);
            this.potentialCommand(n, mouseEvent, n2, tabCellRenderer, BasicTabDisplayerUI.this.scratch);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            int n = this.updateMouseLocation(mouseEvent);
            BasicTabDisplayerUI.this.tabState.setMouseInTabsArea(true);
            BasicTabDisplayerUI.this.tabState.setContainsMouse(n);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.updateMouseLocation(mouseEvent);
            BasicTabDisplayerUI.this.tabState.setMouseInTabsArea(false);
            BasicTabDisplayerUI.this.tabState.setContainsMouse(-1);
            BasicTabDisplayerUI.this.tabState.setCloseButtonContainsMouse(-1);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.updateMouseLocation(mouseEvent);
            BasicTabDisplayerUI.this.tabState.setMouseInTabsArea(true);
            BasicTabDisplayerUI.this.tabState.setContainsMouse(n);
            if (n != -1) {
                TabCellRenderer tabCellRenderer = BasicTabDisplayerUI.this.getTabCellRenderer(n);
                BasicTabDisplayerUI.this.getTabRect(n, BasicTabDisplayerUI.this.scratch);
                int n2 = BasicTabDisplayerUI.this.tabState.getState(n);
                String string = tabCellRenderer.getCommandAtPoint(mouseEvent.getPoint(), n2, BasicTabDisplayerUI.this.scratch);
                if ("close" == string) {
                    BasicTabDisplayerUI.this.tabState.setCloseButtonContainsMouse(n);
                } else {
                    BasicTabDisplayerUI.this.tabState.setCloseButtonContainsMouse(-1);
                }
            } else {
                BasicTabDisplayerUI.this.tabState.setContainsMouse(-1);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.updateMouseLocation(mouseEvent);
            BasicTabDisplayerUI.this.tabState.setPressed(n);
            long l = mouseEvent.getWhen();
            if (l - this.pressTime > 200L) {
                this.lastPressedTab = n;
            }
            this.pressTime = l;
            this.lastPressedTab = n;
            if (n != -1) {
                TabCellRenderer tabCellRenderer = BasicTabDisplayerUI.this.getTabCellRenderer(n);
                BasicTabDisplayerUI.this.getTabRect(n, BasicTabDisplayerUI.this.scratch);
                int n2 = BasicTabDisplayerUI.this.tabState.getState(n);
                String string = tabCellRenderer.getCommandAtPoint(mouseEvent.getPoint(), n2, BasicTabDisplayerUI.this.scratch);
                if ("close" == string) {
                    BasicTabDisplayerUI.this.tabState.setCloseButtonContainsMouse(n);
                    BasicTabDisplayerUI.this.tabState.setMousePressedInCloseButton(n);
                    this.pressTime = -1L;
                    this.lastPressedTab = -1;
                }
                this.potentialCommand(n, mouseEvent, n2, tabCellRenderer, BasicTabDisplayerUI.this.scratch);
            } else {
                BasicTabDisplayerUI.this.tabState.setMousePressedInCloseButton(-1);
            }
        }

        private void potentialCommand(int n, MouseEvent mouseEvent, int n2, TabCellRenderer tabCellRenderer, Rectangle rectangle) {
            String string = tabCellRenderer.getCommandAtPoint(mouseEvent.getPoint(), n2, rectangle, mouseEvent.getButton(), mouseEvent.getID(), mouseEvent.getModifiersEx());
            if (string == null || "select" == string) {
                if (mouseEvent.isPopupTrigger()) {
                    BasicTabDisplayerUI.this.displayer.repaint();
                    this.performCommand("popup", n, mouseEvent);
                    return;
                }
                if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() >= 2) {
                    this.performCommand("maximize", n, mouseEvent);
                    return;
                }
            }
            if (string != null) {
                this.performCommand(string, this.lastPressedTab == -1 || this.lastPressedTab > BasicTabDisplayerUI.this.displayer.getModel().size() ? n : this.lastPressedTab, mouseEvent);
            }
        }

        private void performCommand(String string, int n, MouseEvent mouseEvent) {
            mouseEvent.consume();
            if ("select" == string) {
                boolean bl;
                if (n != BasicTabDisplayerUI.this.displayer.getSelectionModel().getSelectedIndex() && (bl = BasicTabDisplayerUI.this.shouldPerformAction(string, n, mouseEvent))) {
                    BasicTabDisplayerUI.this.selectionModel.setSelectedIndex(n);
                }
            } else {
                boolean bl;
                boolean bl2 = bl = BasicTabDisplayerUI.this.shouldPerformAction(string, n, mouseEvent) && BasicTabDisplayerUI.this.displayer.isShowCloseButton();
                if (bl) {
                    if ("close" == string) {
                        BasicTabDisplayerUI.this.displayer.getModel().removeTab(n);
                    } else if ("closeAll" == string) {
                        BasicTabDisplayerUI.this.displayer.getModel().removeTabs(0, BasicTabDisplayerUI.this.displayer.getModel().size());
                    } else if ("closeAllButThis" == string) {
                        int n2;
                        int n3;
                        if (n != BasicTabDisplayerUI.this.displayer.getModel().size() - 1) {
                            n3 = n + 1;
                            n2 = BasicTabDisplayerUI.this.displayer.getModel().size();
                            BasicTabDisplayerUI.this.displayer.getModel().removeTabs(n3, n2);
                        }
                        if (n != 0) {
                            n3 = 0;
                            n2 = n;
                            BasicTabDisplayerUI.this.displayer.getModel().removeTabs(n3, n2);
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = this.updateMouseLocation(mouseEvent);
            if (n != -1) {
                TabCellRenderer tabCellRenderer = BasicTabDisplayerUI.this.getTabCellRenderer(n);
                BasicTabDisplayerUI.this.getTabRect(n, BasicTabDisplayerUI.this.scratch);
                int n2 = BasicTabDisplayerUI.this.tabState.getState(n);
                if ((n2 & 8) != 0 && (n2 & 2) != 0 || (n2 & 1) != 0) {
                    BasicTabDisplayerUI.this.makeTabVisible(n);
                }
                this.potentialCommand(n, mouseEvent, n2, tabCellRenderer, BasicTabDisplayerUI.this.scratch);
            }
            BasicTabDisplayerUI.this.tabState.setMouseInTabsArea(n != -1);
            BasicTabDisplayerUI.this.tabState.setPressed(-1);
            BasicTabDisplayerUI.this.tabState.setMousePressedInCloseButton(-1);
        }

        public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.updateMouseLocation(mouseWheelEvent);
            BasicTabDisplayerUI.this.processMouseWheelEvent(mouseWheelEvent);
        }
    }

    private class BasicDisplayerPropertyChangeListener
    extends AbstractTabDisplayerUI.DisplayerPropertyChangeListener {
        private BasicDisplayerPropertyChangeListener() {
        }

        protected void activationChanged() {
            BasicTabDisplayerUI.this.tabState.setActive(BasicTabDisplayerUI.this.displayer.isActive());
        }
    }

    protected class BasicModelListener
    extends AbstractTabDisplayerUI.ModelListener {
        protected BasicModelListener() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            super.contentsChanged(listDataEvent);
            BasicTabDisplayerUI.this.tabState.contentsChanged(listDataEvent);
        }

        public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
            super.indicesAdded(complexListDataEvent);
            BasicTabDisplayerUI.this.tabState.indicesAdded(complexListDataEvent);
        }

        public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
            BasicTabDisplayerUI.this.tabState.indicesChanged(complexListDataEvent);
        }

        public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
            BasicTabDisplayerUI.this.tabState.indicesRemoved(complexListDataEvent);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicTabDisplayerUI.this.tabState.intervalAdded(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            BasicTabDisplayerUI.this.tabState.intervalRemoved(listDataEvent);
        }
    }

    protected class BasicSelectionListener
    implements ChangeListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        protected BasicSelectionListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!$assertionsDisabled && changeEvent.getSource() != BasicTabDisplayerUI.this.selectionModel) {
                throw new AssertionError((Object)("Unknown event source: " + changeEvent.getSource()));
            }
            int n = BasicTabDisplayerUI.this.selectionModel.getSelectedIndex();
            BasicTabDisplayerUI.this.tabState.setSelected(n >= 0 ? n : -1);
            if (n >= 0) {
                BasicTabDisplayerUI.this.makeTabVisible(BasicTabDisplayerUI.this.selectionModel.getSelectedIndex());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$swing$tabcontrol$plaf$BasicTabDisplayerUI == null ? (class$org$netbeans$swing$tabcontrol$plaf$BasicTabDisplayerUI = BasicTabDisplayerUI.class$("org.netbeans.swing.tabcontrol.plaf.BasicTabDisplayerUI")) : class$org$netbeans$swing$tabcontrol$plaf$BasicTabDisplayerUI).desiredAssertionStatus();
        }
    }

    protected class BasicTabState
    extends TabState {
        protected BasicTabState() {
        }

        public int getState(int n) {
            if (BasicTabDisplayerUI.this.displayer.getModel().size() == 0) {
                return 64;
            }
            int n2 = super.getState(n);
            if (n == 0) {
                n2 |= 0x80;
            }
            if (n == BasicTabDisplayerUI.this.displayer.getModel().size() - 1) {
                n2 |= 0x100;
            }
            return n2;
        }

        protected void repaintAllTabs() {
            BasicTabDisplayerUI.this.displayer.repaint();
        }

        public int getRepaintPolicy(int n) {
            return BasicTabDisplayerUI.this.repaintPolicy;
        }

        protected void repaintTab(int n) {
            if (n == -1 || n > BasicTabDisplayerUI.this.displayer.getModel().size()) {
                return;
            }
            BasicTabDisplayerUI.this.getTabRectForRepaint(n, BasicTabDisplayerUI.this.scratch);
            ((BasicTabDisplayerUI)BasicTabDisplayerUI.this).scratch.y = 0;
            ((BasicTabDisplayerUI)BasicTabDisplayerUI.this).scratch.height = BasicTabDisplayerUI.this.displayer.getHeight();
            BasicTabDisplayerUI.this.displayer.repaint(((BasicTabDisplayerUI)BasicTabDisplayerUI.this).scratch.x, ((BasicTabDisplayerUI)BasicTabDisplayerUI.this).scratch.y, ((BasicTabDisplayerUI)BasicTabDisplayerUI.this).scratch.width, ((BasicTabDisplayerUI)BasicTabDisplayerUI.this).scratch.height);
        }
    }
}

