/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.ChicletWrapper;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

final class AquaEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final AquaTabPainter AquaTabPainter = new AquaTabPainter();
    static final int TOP_INSET = 0;
    static final int LEFT_INSET = 3;
    static final int RIGHT_INSET = 6;
    static final int BOTTOM_INSET = 2;
    private static final ChicletWrapper chiclet = new ChicletWrapper();

    public AquaEditorTabCellRenderer() {
        super(AquaTabPainter, AquaTabPainter, AquaTabPainter, new Dimension(23, 8));
    }

    protected int getCaptionYAdjustment() {
        return 0;
    }

    protected int getIconYAdjustment() {
        return -1;
    }

    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        dimension.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 23 : 13;
        return dimension;
    }

    private static class AquaTabPainter
    implements TabPainter {
        private static Insets insets = new Insets(0, 3, 2, 6);

        public Insets getBorderInsets(Component component) {
            boolean bl = ((AquaEditorTabCellRenderer)component).isLeftmost();
            if (bl) {
                return new Insets(0, 7, 2, 6);
            }
            return insets;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            boolean bl;
            boolean bl2 = ((AquaEditorTabCellRenderer)jComponent).isClipRight();
            boolean bl3 = ((AquaEditorTabCellRenderer)jComponent).isClipLeft();
            boolean bl4 = bl = !((AbstractTabCellRenderer)jComponent).isShowCloseButton();
            if (bl3 || bl2 || bl) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
            } else {
                int n = (rectangle2.height - 2) / 2 + 0 - 1;
                rectangle.x = rectangle2.x + rectangle2.width - 9;
                rectangle.y = n - 2;
                rectangle.height = 10;
                rectangle.width = 10;
                if (((AquaEditorTabCellRenderer)jComponent).isRightmost()) {
                    rectangle.x -= 2;
                }
            }
        }

        private void paintCloseButton(Graphics graphics, JComponent jComponent) {
            if (((AbstractTabCellRenderer)jComponent).isShowCloseButton()) {
                Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
                Rectangle rectangle2 = new Rectangle();
                this.getCloseButtonRectangle(jComponent, rectangle2, rectangle);
                rectangle2.width -= 5;
                rectangle2.height -= 5;
                graphics.setColor(Color.darkGray);
                graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                graphics.drawLine(rectangle2.x, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y);
            }
        }

        public Polygon getInteriorPolygon(Component component) {
            return new Polygon(new int[]{0, component.getWidth(), component.getWidth(), 0}, new int[]{0, 0, component.getHeight(), component.getHeight()}, 4);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if ((((AquaEditorTabCellRenderer)component).getState() & 0x1000) != 0) {
                this.paintCloseButton(graphics, (JComponent)component);
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            float f;
            Rectangle rectangle = component.getBounds();
            boolean bl = ((AquaEditorTabCellRenderer)component).isRightmost();
            boolean bl2 = ((AquaEditorTabCellRenderer)component).isClipRight();
            boolean bl3 = ((AquaEditorTabCellRenderer)component).isSelected();
            boolean bl4 = ((AquaEditorTabCellRenderer)component).isActive();
            boolean bl5 = ((AquaEditorTabCellRenderer)component).isPressed();
            boolean bl6 = ((AquaEditorTabCellRenderer)component).isClipLeft();
            boolean bl7 = ((AquaEditorTabCellRenderer)component).isLeftmost();
            boolean bl8 = bl5 && ((AquaEditorTabCellRenderer)component).inCloseButton();
            boolean bl9 = !bl5 && !bl8 && ((AquaEditorTabCellRenderer)component).isAttention();
            chiclet.setBounds(0, 0, rectangle.width, rectangle.height);
            chiclet.setNotch(bl2, bl6);
            int n = 0;
            float f2 = bl7 && !bl6 ? 0.5f : 0.0f;
            float f3 = f = bl && !bl2 ? 0.5f : 0.0f;
            if (bl5 && (bl2 || bl6)) {
                n |= 1;
            }
            if (bl4) {
                n |= 4;
            }
            if (bl3) {
                n |= 2;
            }
            if (bl8) {
                n |= 8;
            }
            if (bl9) {
                n |= 0x10;
            }
            chiclet.setArcs(f2, f, f2, f);
            chiclet.setState(n);
            chiclet.draw((Graphics2D)graphics);
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            boolean bl = ((AquaEditorTabCellRenderer)jComponent).isClipLeft();
            boolean bl2 = ((AquaEditorTabCellRenderer)jComponent).isClipRight();
            boolean bl3 = ((AquaEditorTabCellRenderer)jComponent).isShowCloseButton();
            return !bl && !bl2 && bl3;
        }
    }
}

