/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.gui;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class GUIPrefs {
    private static final Logger LOG = Logger.getLogger("tr.prefs.gui");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/gui");
    public static final String INITIAL_ACTION_ID_NONE = "none";
    private static final String KEY_INITIAL_ACTION_ID = "initial.action.id";
    private static final String DEF_INITIAL_ACTION_ID = "overview";
    public static final String BUTTONS_POSITION_TOP = "top";
    public static final String BUTTONS_POSITION_BOTTOM = "bottom";
    private static final String KEY_BUTTONS_POSITION = "buttons.position";
    private static final String DEF_BUTTONS_POSITION = "top";

    public static final String getInitialActionID() {
        return prefs.get(KEY_INITIAL_ACTION_ID, DEF_INITIAL_ACTION_ID);
    }

    public static final void setInitialWindowID(String value) {
        prefs.put(KEY_INITIAL_ACTION_ID, value);
        GUIPrefs.flush();
    }

    public static final String getButtonsPosition() {
        return prefs.get(KEY_BUTTONS_POSITION, "top");
    }

    public static final void setButtonsPosition(String value) {
        prefs.put(KEY_BUTTONS_POSITION, value);
        GUIPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("GUI preferences error. " + ex.getMessage());
        }
    }
}

