/*
 * Decompiled with CFR 0.152.
 */
package tr.model.util;

import java.util.Vector;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;
import tr.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manager<T extends Observable>
extends ObservableImpl
implements Observer,
Observable {
    private final Vector<T> items = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean add(T item) {
        if (item == null) {
            return false;
        }
        Manager manager = this;
        synchronized (manager) {
            if (!this.items.add(item)) {
                return false;
            }
        }
        item.addObserver((Observer)this);
        this.notifyObservers(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void insert(T item, int pos) {
        if (item == null) {
            return;
        }
        Manager manager = this;
        synchronized (manager) {
            this.items.add(pos, item);
        }
        item.addObserver((Observer)this);
        this.notifyObservers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean remove(T item) {
        if (item == null) {
            return false;
        }
        Manager manager = this;
        synchronized (manager) {
            if (!this.items.contains(item)) {
                return false;
            }
            if (!this.items.remove(item)) {
                return false;
            }
        }
        item.removeObserver((Observer)this);
        this.notifyObservers(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAll() {
        Manager manager = this;
        synchronized (manager) {
            for (Observable item : this.items) {
                item.removeObserver((Observer)this);
            }
            this.items.removeAllElements();
        }
        this.notifyObservers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get(int index) throws IndexOutOfBoundsException {
        Manager manager = this;
        synchronized (manager) {
            return (T)((Observable)this.items.get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(int index, T item) throws IndexOutOfBoundsException {
        Manager manager = this;
        synchronized (manager) {
            Observable old = (Observable)this.items.set(index, item);
            if (Utils.equal(item, (Object)old)) {
                return;
            }
            old.removeObserver((Observer)this);
            item.addObserver((Observer)this);
        }
        this.notifyObservers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Vector<T> list() {
        Manager manager = this;
        synchronized (manager) {
            return new Vector<T>(this.items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int indexOf(T item) {
        Manager manager = this;
        synchronized (manager) {
            return this.items.indexOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        Manager manager = this;
        synchronized (manager) {
            return this.items.size();
        }
    }

    public final void update(Observable observable, Object arg) {
        this.notifyObservers(observable, arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetObservers() {
        Manager manager = this;
        synchronized (manager) {
            for (Observable item : this.items) {
                item.addObserver((Observer)this);
                item.resetObservers();
            }
        }
    }
}

