/*
 * Decompiled with CFR 0.152.
 */
package tr.model.topic;

import java.awt.Color;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topic
extends ObservableImpl
implements Comparable<Topic> {
    private static Topic def;
    private String name = "";
    private String description = "";
    private Color color = Color.black;
    private Color background = Color.white;
    public transient String key;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.equals(this.name)) {
            return;
        }
        this.name = name;
        this.notifyObservers((Observable)this);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null || description.equals(this.description)) {
            return;
        }
        this.description = description;
        this.notifyObservers((Observable)this);
    }

    public Color getForeground() {
        return this.color;
    }

    public void setForeground(Color color) {
        if (color == null || color.equals(this.color)) {
            return;
        }
        this.color = color;
        this.notifyObservers((Observable)this);
    }

    public Color getBackground() {
        return this.background == null ? Color.white : this.background;
    }

    public void setBackground(Color background) {
        if (background == null || background.equals(this.background)) {
            return;
        }
        this.background = background;
        this.notifyObservers((Observable)this);
    }

    public static Topic getDefault() {
        if (def == null) {
            def = new Topic();
            def.setName("None");
            def.setDescription("No topic.");
        }
        return def;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Topic)) {
            return false;
        }
        Topic c = (Topic)object;
        if (!Utils.equal((Object)this.name, (Object)c.name)) {
            return false;
        }
        if (!Utils.equal((Object)this.description, (Object)c.description)) {
            return false;
        }
        return Utils.equal((Object)this.color, (Object)c.color);
    }

    @Override
    public int compareTo(Topic topic) {
        if (this.toString().equals(Topic.getDefault().toString())) {
            return -1;
        }
        return this.toString().compareToIgnoreCase(topic.toString());
    }
}

