/*
 * Decompiled with CFR 0.152.
 */
package tr.model.information;

import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Information
extends ObservableImpl
implements TopicChangeCookie,
Comparable<Information> {
    private static final Logger LOG = Logger.getLogger("tr.model.information");
    private Date created = Calendar.getInstance().getTime();
    private String description;
    private Topic topic;
    private String location;
    private String notes;

    public Information() {
        this.setDescription("");
        this.setTopic(Topic.getDefault());
        this.setLocation("");
        this.setNotes("");
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (Utils.equal((Object)this.description, (Object)description)) {
            return;
        }
        this.description = description;
        this.notifyObservers((Observable)this);
        LOG.fine("Description changed.");
    }

    public Topic getTopic() {
        if (this.topic == null) {
            return Topic.getDefault();
        }
        if (this.topic.getName().equals(Topic.getDefault().getName())) {
            return Topic.getDefault();
        }
        return this.topic;
    }

    @Override
    public void setTopic(Topic topic) {
        if (Utils.equal((Object)this.topic, (Object)topic)) {
            return;
        }
        this.topic = topic;
        this.notifyObservers((Observable)this);
        LOG.fine("Topic changed.");
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        if (Utils.equal((Object)this.location, (Object)location)) {
            return;
        }
        this.location = location;
        this.notifyObservers((Observable)this);
        LOG.fine("Location changed.");
    }

    public String getNotes() {
        return this.notes == null ? "" : this.notes;
    }

    public void setNotes(String notes) {
        if (Utils.equal((Object)this.notes, (Object)notes)) {
            return;
        }
        this.notes = notes;
        this.notifyObservers((Observable)this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Information)) {
            return false;
        }
        Information information = (Information)object;
        if (!Utils.equal((Object)this.created, (Object)information.created)) {
            return false;
        }
        if (!Utils.equal((Object)this.description, (Object)information.description)) {
            return false;
        }
        if (!Utils.equal((Object)this.topic, (Object)information.topic)) {
            return false;
        }
        if (!Utils.equal((Object)this.location, (Object)information.location)) {
            return false;
        }
        return Utils.equal((Object)this.notes, (Object)information.notes);
    }

    public String toString() {
        return this.description;
    }

    @Override
    public int compareTo(Information other) {
        int rslt = this.topic.compareTo(other.topic);
        if (rslt != 0) {
            return rslt;
        }
        return this.description.compareToIgnoreCase(other.description);
    }
}

