/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Iterator;
import java.util.logging.Logger;
import tr.model.Data;
import tr.model.action.Action;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.project.Project;
import tr.util.ObservableImpl;

public class RecurrenceRemover
extends Thread {
    private static final Logger LOG = Logger.getLogger("tr.model.action");

    private RecurrenceRemover() {
    }

    public static void remove(Data data, int recurrenceID) {
        new RemoverThread(data, recurrenceID).start();
    }

    public static void removeAll(Data data) {
        new RemoverThread(data).start();
    }

    private static class RemoverThread
    extends Thread {
        private final Data data;
        private final boolean removeAll;
        private final int recurrenceID;

        public RemoverThread(Data data) {
            this.data = data;
            this.removeAll = true;
            this.recurrenceID = 0;
        }

        public RemoverThread(Data data, int recurrenceID) {
            this.data = data;
            this.recurrenceID = recurrenceID;
            this.removeAll = false;
        }

        public void run() {
            LOG.info("Start");
            if (this.data == null) {
                LOG.severe("Data instance was not provided.");
                return;
            }
            this.process(this.data.getRootActions());
            this.process(this.data.getRootProjects());
            LOG.info("Finish");
        }

        private void process(Project project) {
            Iterator<ObservableImpl> i = project.iterator(Action.class);
            while (i.hasNext()) {
                this.process(i.next());
            }
            i = project.iterator(Project.class);
            while (i.hasNext()) {
                this.process((Project)i.next());
            }
        }

        private void process(Action action) {
            ActionStateScheduled state;
            Recurrence recurrence;
            if (action.isStateScheduled() && (recurrence = (state = (ActionStateScheduled)action.getState()).getRecurrence()) != null && (this.removeAll || recurrence.getID() == this.recurrenceID)) {
                state.setRecurrence(null);
            }
        }
    }
}

