/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Resources;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateScheduled;
import tr.model.context.Context;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.topic.Topic;
import tr.util.DateUtils;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Utils;

public class Recurrence
extends ObservableImpl {
    private static final Logger LOG = Logger.getLogger("tr.recurrence");
    private final int id;
    private final Project project;
    private String description;
    private Topic topic;
    private Context context;
    private Value time;
    private Value energy;
    private Value priority;
    private byte scheduleHours;
    private byte scheduleMins;
    private byte durationHours;
    private byte durationMins;
    private byte basisID;
    private Date startDate;
    private byte periodID;
    private int frequency;
    private int advanceNbr;
    private Integer endNbr;
    private Date endDate;
    private int genNbr;
    private Date genToDate;
    private transient Period period;
    private transient Basis basis;
    private transient Data data;
    private transient int occursNbr;
    private transient int occursAdvanceNbr;
    private transient Date occursLastDate;

    public Recurrence(int id, Project project) {
        this.id = id;
        this.project = project;
    }

    public int getID() {
        return this.id;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        if (this.frequency != frequency) {
            this.frequency = frequency;
            this.notifyObservers((Observable)this);
        }
    }

    public Period getPeriod() {
        return Period.fromID(this.periodID);
    }

    public void setPeriod(Period period) {
        if (period == null) {
            period = Period.fromID((byte)0);
        }
        if (this.periodID != period.ID) {
            this.periodID = period.ID;
            this.notifyObservers((Observable)this);
        }
    }

    public Basis getBasis() {
        return Basis.fromID(this.basisID);
    }

    public void setBasis(Basis basis) {
        if (basis == null) {
            basis = Basis.fromID((byte)0);
        }
        if (this.basisID != basis.ID) {
            this.basisID = basis.ID;
            this.notifyObservers((Observable)this);
        }
    }

    public int getAdvanceNbr() {
        return this.advanceNbr;
    }

    public void setAdvanceNbr(int advanceNbr) {
        if (!Utils.equal((Object)this.advanceNbr, (Object)advanceNbr)) {
            this.advanceNbr = advanceNbr;
            this.notifyObservers((Observable)this);
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        if (!Utils.equal((Object)this.startDate, (Object)startDate)) {
            this.startDate = startDate;
            this.notifyObservers((Observable)this);
        }
    }

    public void setScheduleHours(int hours) {
        if (this.scheduleHours != (byte)hours) {
            this.scheduleHours = (byte)hours;
            this.notifyObservers((Observable)this);
        }
    }

    public int getScheduleHours() {
        return this.scheduleHours;
    }

    public void setScheduleMins(int minutes) {
        if (this.scheduleMins != (byte)minutes) {
            this.scheduleMins = (byte)minutes;
            this.notifyObservers((Observable)this);
        }
    }

    public int getScheduleMins() {
        return this.scheduleMins;
    }

    public void setDurationHours(int hours) {
        if (this.durationHours != (byte)hours) {
            this.durationHours = (byte)hours;
            this.notifyObservers((Observable)this);
        }
    }

    public int getDurationHours() {
        return this.durationHours;
    }

    public void setDurationMins(int minutes) {
        if (this.durationMins != (byte)minutes) {
            this.durationMins = (byte)minutes;
            this.notifyObservers((Observable)this);
        }
    }

    public int getDurationMins() {
        return this.durationMins;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        if (!Utils.equal((Object)this.endDate, (Object)endDate)) {
            this.endDate = endDate;
            this.endNbr = null;
            this.notifyObservers((Observable)this);
        }
    }

    public Integer getEndNbr() {
        return this.endNbr;
    }

    public void setEndNbr(Integer endNbr) {
        if (!Utils.equal((Object)this.endNbr, (Object)endNbr)) {
            this.endNbr = endNbr;
            this.endDate = null;
            this.notifyObservers((Observable)this);
        }
    }

    public Date getGeneratedToDate() {
        return this.genToDate;
    }

    public void generateForDoneDateBasis(Action scheduledAction) {
        LOG.fine("Start.");
        this.basis = this.getBasis();
        if (this.basis != Basis.DONE_DATE) {
            LOG.warning("Called for recurrence with basis not done-date.");
            return;
        }
        if (!scheduledAction.isDone()) {
            LOG.warning("Called for action that is not done.");
            return;
        }
        if (!scheduledAction.isStateScheduled()) {
            LOG.warning("Called for action with state not scheduled.");
            return;
        }
        if (this.endNbr != null && this.endNbr - (this.genNbr + 1) < 1) {
            LOG.warning("End number already reached.");
            return;
        }
        if (this.endDate != null && Calendar.getInstance().after(this.endDate)) {
            LOG.warning("End date already reached.");
            return;
        }
        this.data = this.getData();
        if (this.data == null) {
            return;
        }
        ActionStateScheduled saState = (ActionStateScheduled)scheduledAction.getState();
        if (saState.getDate() == null) {
            LOG.severe("State is null.");
            return;
        }
        Calendar calSchdDate = Calendar.getInstance();
        calSchdDate.setTime(saState.getDate());
        Calendar calStartDate = Calendar.getInstance();
        calStartDate.setTime(scheduledAction.getDoneDate());
        calStartDate.set(11, this.getScheduleHours());
        calStartDate.set(12, this.getScheduleMins());
        calStartDate.set(13, 0);
        calStartDate.set(14, 0);
        Date nextDate = this.calculateNextDate(calStartDate, this.getPeriod(), this.getFrequency());
        if (nextDate == null) {
            return;
        }
        if (this.endDate != null && nextDate.after(this.endDate)) {
            return;
        }
        this.createRecurrenceAction(nextDate, scheduledAction.getSuccess());
        saState.setRecurrence(null);
        ++this.genNbr;
        this.genToDate = nextDate;
        this.notifyObservers((Observable)this);
    }

    private Date calculateNextDate(Date start, Period period, int frequency) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(start);
        return this.calculateNextDate(calStart, period, frequency);
    }

    private Date calculateNextDate(Calendar start, Period period, int frequency) {
        switch (period) {
            case WEEKDAY: {
                return this.calculateNextWeekDay(start, frequency);
            }
            case DAY: {
                start.add(6, frequency);
                return start.getTime();
            }
            case WEEK: {
                start.add(3, frequency);
                return start.getTime();
            }
            case MONTH: {
                start.add(2, frequency);
                return start.getTime();
            }
            case YEAR: {
                start.add(1, frequency);
                return start.getTime();
            }
        }
        return null;
    }

    private Date calculateNextWeekDay(Calendar start, int weekdays) {
        int days = 0;
        switch (start.get(7)) {
            case 2: {
                days = weekdays + weekdays / 5 * 2;
                break;
            }
            case 3: {
                days = weekdays + (weekdays + 1) / 5 * 2;
                break;
            }
            case 4: {
                days = weekdays + (weekdays + 2) / 5 * 2;
                break;
            }
            case 5: {
                days = weekdays + (weekdays + 3) / 5 * 2;
                break;
            }
            case 6: {
                days = weekdays + (weekdays + 4) / 5 * 2;
                break;
            }
            case 7: {
                days = weekdays + (weekdays - 1) / 5 * 2 + 1;
                break;
            }
            case 1: {
                days = weekdays + (weekdays - 1) / 5 * 2;
            }
        }
        start.add(6, days);
        return start.getTime();
    }

    private Date calculatePreviousDate(Date start, Period period, int frequency) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(start);
        return this.calculatePreviousDate(calStart, period, frequency);
    }

    private Date calculatePreviousDate(Calendar start, Period period, int frequency) {
        switch (period) {
            case WEEKDAY: {
                return this.calculatePreviousWeekDay(start, frequency);
            }
            case DAY: {
                start.add(6, frequency * -1);
                return start.getTime();
            }
            case WEEK: {
                start.add(3, frequency * -1);
                return start.getTime();
            }
            case MONTH: {
                start.add(2, frequency * -1);
                return start.getTime();
            }
            case YEAR: {
                start.add(1, frequency * -1);
                return start.getTime();
            }
        }
        return null;
    }

    private Date calculatePreviousWeekDay(Calendar start, int weekdays) {
        int days = 0;
        switch (start.get(7)) {
            case 6: {
                days = weekdays + weekdays / 5 * 2;
                break;
            }
            case 5: {
                days = weekdays + (weekdays + 1) / 5 * 2;
                break;
            }
            case 4: {
                days = weekdays + (weekdays + 2) / 5 * 2;
                break;
            }
            case 3: {
                days = weekdays + (weekdays + 3) / 5 * 2;
                break;
            }
            case 2: {
                days = weekdays + (weekdays + 4) / 5 * 2;
                break;
            }
            case 1: {
                days = weekdays + (weekdays - 1) / 5 * 2 + 1;
                break;
            }
            case 7: {
                days = weekdays + (weekdays - 1) / 5 * 2;
            }
        }
        start.add(6, days * -1);
        return start.getTime();
    }

    private Data getData() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            LOG.severe("Data instance could not be obtained.");
        }
        return data;
    }

    private Date getStartDateTime() {
        LOG.fine("Start.");
        if (this.startDate == null) {
            LOG.warning("Called for recurrence with null start-date.");
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.startDate);
        c.set(11, this.scheduleHours);
        c.set(12, this.scheduleMins);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    private Date calculateEndDate() {
        Period period = this.getPeriod();
        int frequency = this.getFrequency();
        Date start = this.getStartDateTime();
        Date end = null;
        if (this.endDate != null) {
            end = this.endDate;
        } else if (this.endNbr != null) {
            end = this.calculateNextDate(start, period, frequency * (this.endNbr - 1));
        }
        if (end != null) {
            end = DateUtils.getEnd((Date)end);
        }
        LOG.fine("Calculated end date: " + end + " for period: " + (Object)((Object)period) + ", frequency: " + frequency + ", start date: " + start + ", end date: " + this.endDate);
        return end;
    }

    public void generateOccurrencesFromGenToDate() {
        LOG.fine("Start.");
        this.basis = this.getBasis();
        if (this.basis != Basis.START_DATE) {
            LOG.warning("Called for recurrence with basis not start-date.");
            return;
        }
        this.period = this.getPeriod();
        if (this.period == null) {
            LOG.warning("Called for recurrence with null period.");
            return;
        }
        if (this.startDate == null) {
            LOG.warning("Called for recurrence with null start-date.");
            return;
        }
        if (this.advanceNbr < 1) {
            LOG.warning("Called for recurrence with advance less than 1.");
            return;
        }
        if (this.frequency < 1) {
            LOG.warning("Called for recurrence with frequency less than 1.");
            return;
        }
        this.data = this.getData();
        if (this.data == null) {
            return;
        }
        this.determineStatistics();
        if (this.genToDate == null) {
            this.genToDate = this.occursLastDate;
        }
        Period period = this.getPeriod();
        int frequency = this.getFrequency();
        Date today = this.clearTime(Calendar.getInstance().getTime());
        if (this.clearTime(today).after(this.genToDate)) {
            LOG.fine("Generating occurrences up to today.");
            Date end = DateUtils.min((Date)this.calculateEndDate(), (Date)today);
            this.generateSubsequent(this.genToDate, Integer.MAX_VALUE, end);
            this.determineStatistics();
        }
        this.generateSubsequent(this.genToDate, this.advanceNbr - this.occursAdvanceNbr, this.calculateEndDate());
    }

    private void generateInitial(Date start, int advance, Date end) {
        LOG.fine("Generating occurrences; start: " + start + " end: " + end + " advance: " + advance);
        if (start == null) {
            return;
        }
        if (advance < 1) {
            return;
        }
        if (end == null) {
            end = DateUtils.MAX_DATE;
        }
        if (start.after(end)) {
            return;
        }
        Date endOfToday = DateUtils.getEnd((Date)Calendar.getInstance().getTime());
        this.data = this.getData();
        Period period = this.getPeriod();
        int frequency = this.getFrequency();
        if (this.existsRecurrentAction(start)) {
            if (start.after(endOfToday)) {
                --advance;
            }
        } else {
            this.createRecurrenceAction(start);
            this.genToDate = start;
            if (start.after(endOfToday)) {
                --advance;
            }
        }
        Date next = this.calculateNextDate(start, period, frequency);
        while (!next.after(end) && advance > 0) {
            this.createRecurrenceAction(next);
            this.genToDate = next;
            if (next.after(endOfToday)) {
                --advance;
            }
            next = this.calculateNextDate(next, period, frequency);
        }
    }

    private void generateSubsequent(Date lastGenToDate, int advance, Date end) {
        LOG.fine("Generating occurrences; genToDate: " + lastGenToDate + " end: " + end + " advance: " + advance);
        if (end == null) {
            end = DateUtils.MAX_DATE;
        }
        if (lastGenToDate.after(end)) {
            return;
        }
        Date endOfToday = DateUtils.getEnd((Date)Calendar.getInstance().getTime());
        this.data = this.getData();
        Period period = this.getPeriod();
        int frequency = this.getFrequency();
        Date next = this.calculateNextDate(lastGenToDate, period, frequency);
        while (!next.after(end) && advance > 0) {
            this.createRecurrenceAction(next);
            this.genToDate = next;
            if (next.after(endOfToday)) {
                --advance;
            }
            next = this.calculateNextDate(next, period, frequency);
        }
    }

    private void createRecurrenceAction(Date date) {
        this.createRecurrenceAction(date, null);
    }

    private void createRecurrenceAction(Date date, String success) {
        LOG.fine("Creating action for: " + date);
        Action newAction = new Action(this.data);
        newAction.setContext(this.getContext());
        newAction.setDescription(this.getDescription());
        newAction.setDone(false);
        newAction.setEnergy(this.getEnergy());
        newAction.setNotes("");
        newAction.setPriority(this.getPriority());
        newAction.setTime(this.getTime());
        newAction.setTopic(this.getTopic());
        newAction.setSuccess(success);
        ActionStateScheduled state = new ActionStateScheduled();
        state.setDate(date);
        state.setDurationHours(this.getDurationHours());
        state.setDurationMins(this.getDurationMins());
        state.setRecurrence(this);
        newAction.setState(state);
        this.project.add(newAction);
    }

    private boolean existsRecurrentAction(Date date) {
        if (date == null) {
            return false;
        }
        Date compareDate = this.clearTime(date);
        Iterator<Action> iter = this.project.iterator(Action.class);
        while (iter.hasNext()) {
            ActionStateScheduled schdState;
            Recurrence recurrence;
            Action child = iter.next();
            ActionState state = child.getState();
            if (!(state instanceof ActionStateScheduled) || (recurrence = (schdState = (ActionStateScheduled)state).getRecurrence()) == null || recurrence.id != this.id || !this.clearTime(schdState.getDate()).equals(compareDate)) continue;
            return true;
        }
        return false;
    }

    public void removeOccurrencesAfterStartDate() {
        LOG.fine("Start.");
        if (this.project == null) {
            LOG.warning("Called for recurrence with no project.");
            return;
        }
        if (this.startDate == null) {
            LOG.warning("Called for recurrence with null start-date.");
            return;
        }
        this.removeOccurrencesAfter(this.startDate);
    }

    private void removeOccurrencesAfter(Date date) {
        LOG.fine("Start.");
        if (date == null) {
            LOG.warning("Called with null date.");
            return;
        }
        Date endOfDate = DateUtils.getEnd((Date)date);
        Iterator<Action> iter = this.project.iterator(Action.class);
        while (iter.hasNext()) {
            Date schdDate;
            ActionStateScheduled schdState;
            Recurrence recurrence;
            Action action = iter.next();
            ActionState state = action.getState();
            if (!(state instanceof ActionStateScheduled) || (recurrence = (schdState = (ActionStateScheduled)state).getRecurrence()) == null || recurrence.id != this.id || (schdDate = schdState.getDate()) == null || !schdDate.after(endOfDate)) continue;
            LOG.fine("Removing action; Scheduled: " + schdDate + " Description: " + action.getDescription());
            action.removeFromParent();
        }
    }

    private void determineStatistics() {
        Date endOfToday = DateUtils.getEnd((Date)Calendar.getInstance().getTime());
        this.occursNbr = 0;
        this.occursAdvanceNbr = 0;
        this.occursLastDate = null;
        Iterator<Action> iter = this.project.iterator(Action.class);
        while (iter.hasNext()) {
            Date schdDate;
            ActionStateScheduled schdState;
            Recurrence recurrence;
            Action action = iter.next();
            ActionState state = action.getState();
            if (!(state instanceof ActionStateScheduled) || (recurrence = (schdState = (ActionStateScheduled)state).getRecurrence()) == null || recurrence.id != this.id || (schdDate = schdState.getDate()) == null) continue;
            ++this.occursNbr;
            if (schdDate.after(endOfToday)) {
                ++this.occursAdvanceNbr;
            }
            if (this.occursLastDate != null && !schdDate.after(this.occursLastDate)) continue;
            this.occursLastDate = schdDate;
        }
        LOG.fine("Occurrences: " + this.occursNbr + " Future: " + this.occursAdvanceNbr + " Last: " + this.occursLastDate);
    }

    public void generateOccurrencesFromStartDate() {
        LOG.fine("Start.");
        if (this.project == null) {
            LOG.warning("Called for recurrence with no project.");
            return;
        }
        if (this.startDate == null) {
            LOG.warning("Called for recurrence with null start-date.");
            return;
        }
        this.basis = this.getBasis();
        if (this.basis != Basis.START_DATE) {
            LOG.warning("Called for recurrence with basis not start-date.");
            return;
        }
        this.period = this.getPeriod();
        if (this.period == null) {
            LOG.warning("Called for recurrence with null period.");
            return;
        }
        if (this.frequency < 1) {
            LOG.warning("Called for recurrence with frequency less than 1.");
            return;
        }
        if (this.advanceNbr < 1) {
            LOG.warning("Called for recurrence with advance less than 1.");
            return;
        }
        this.data = this.getData();
        if (this.data == null) {
            return;
        }
        this.determineStatistics();
        Date start = this.getStartDateTime();
        Date end = this.calculateEndDate();
        this.generateInitial(start, this.advanceNbr, end);
    }

    public void updateTermination() {
        LOG.fine("Start.");
        if (this.project == null) {
            LOG.warning("Called for recurrence with no project.");
            return;
        }
        if (this.genToDate == null) {
            LOG.warning("Called for recurrence with null generated-to-date.");
            return;
        }
        if (this.startDate == null) {
            LOG.warning("Called for recurrence with null start-date.");
            return;
        }
        this.basis = this.getBasis();
        if (this.basis != Basis.START_DATE) {
            LOG.warning("Called for recurrence with basis not start-date.");
            return;
        }
        this.period = this.getPeriod();
        if (this.period == null) {
            LOG.warning("Called for recurrence with null period.");
            return;
        }
        if (this.frequency < 1) {
            LOG.warning("Called for recurrence with frequency less than 1.");
            return;
        }
        if (this.advanceNbr < 1) {
            LOG.warning("Called for recurrence with advance less than 1.");
            return;
        }
        this.data = this.getData();
        if (this.data == null) {
            return;
        }
        this.determineStatistics();
        this.removeOccurrencesAfter(this.calculateEndDate());
        this.generateOccurrencesFromGenToDate();
    }

    public void updateRecurrenceActions(Date fromDate) {
        LOG.fine("Start.");
        fromDate = DateUtils.getStart((Date)fromDate);
        Iterator<Action> iter = this.project.iterator(Action.class);
        while (iter.hasNext()) {
            Date schdDate;
            Recurrence recurrence;
            ActionStateScheduled state;
            Action child = iter.next();
            if (!child.isStateScheduled() || (state = (ActionStateScheduled)child.getState()) == null || (recurrence = state.getRecurrence()) == null || recurrence.id != this.id || (schdDate = state.getDate()) == null || schdDate.before(fromDate)) continue;
            child.setDescription(this.getDescription());
            child.setTopic(this.getTopic());
            child.setContext(this.getContext());
            child.setTime(this.getTime());
            child.setEnergy(this.getEnergy());
            child.setPriority(this.getPriority());
            state.setDurationHours(this.getDurationHours());
            state.setDurationMins(this.getDurationMins());
            Calendar calSchdDate = Calendar.getInstance();
            calSchdDate.setTime(schdDate);
            calSchdDate.set(11, this.getScheduleHours());
            calSchdDate.set(12, this.getScheduleMins());
            state.setDate(calSchdDate.getTime());
        }
    }

    private Date clearTime(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.clear(11);
        c.clear(12);
        c.clear(13);
        c.clear(14);
        return c.getTime();
    }

    public void setDescription(String description) {
        if (!Utils.equal((Object)this.description, (Object)description)) {
            this.description = description;
            this.notifyObservers((Observable)this);
        }
    }

    public void setTopic(Topic topic) {
        if (!Utils.equal((Object)this.topic, (Object)topic)) {
            this.topic = topic;
            this.notifyObservers((Observable)this);
        }
    }

    public void setContext(Context context) {
        if (!Utils.equal((Object)this.context, (Object)context)) {
            this.context = context;
            this.notifyObservers((Observable)this);
        }
    }

    public void setTime(Value time) {
        if (!Utils.equal((Object)this.time, (Object)time)) {
            this.time = time;
            this.notifyObservers((Observable)this);
        }
    }

    public void setEnergy(Value energy) {
        if (!Utils.equal((Object)this.energy, (Object)energy)) {
            this.energy = energy;
            this.notifyObservers((Observable)this);
        }
    }

    public void setPriority(Value priority) {
        if (!Utils.equal((Object)this.priority, (Object)priority)) {
            this.priority = priority;
            this.notifyObservers((Observable)this);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public Context getContext() {
        return this.context;
    }

    public Value getTime() {
        return this.time;
    }

    public Value getEnergy() {
        return this.energy;
    }

    public Value getPriority() {
        return this.priority;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Basis {
        START_DATE(1),
        DONE_DATE(2);

        public final byte ID;

        private Basis(byte id) {
            this.ID = id;
        }

        public static Basis fromID(byte id) {
            switch (id) {
                case 1: {
                    return START_DATE;
                }
                case 2: {
                    return DONE_DATE;
                }
            }
            return START_DATE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Period {
        WEEKDAY(1, "period.weekday"),
        DAY(2, "period.day"),
        WEEK(3, "period.week"),
        MONTH(4, "period.month"),
        YEAR(5, "period.year");

        public final byte ID;
        public final String KEY;

        private Period(byte id, String key) {
            this.ID = id;
            this.KEY = key;
        }

        public static Period fromID(byte id) {
            switch (id) {
                case 1: {
                    return WEEKDAY;
                }
                case 2: {
                    return DAY;
                }
                case 3: {
                    return WEEK;
                }
                case 4: {
                    return MONTH;
                }
                case 5: {
                    return YEAR;
                }
            }
            return DAY;
        }

        public String toString() {
            return Resources.getText(this.KEY);
        }
    }
}

