/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import tr.model.IDGenerator;
import tr.model.Item.Doable;
import tr.model.Item.Item;
import tr.model.Item.ItemList;
import tr.model.Resources;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.context.Context;
import tr.model.context.ContextChangeCookie;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.project.ProjectSingleActions;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.util.DateUtils;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Utils;

public class Action
extends ObservableImpl
implements Doable,
Item,
ContextChangeCookie,
TopicChangeCookie {
    private Integer id;
    private Date created;
    private Thought thought;
    private Project parent;
    private String description;
    private Topic topic;
    private Context context;
    private ActionState state;
    private String notes;
    private boolean done;
    private Date doneDate;
    private Value time;
    private Value energy;
    private Value priority;
    private String success;
    private Date startDate;
    private Date dueDate;
    private Date modified;

    public Action(IDGenerator idGenerator) {
        this.id = idGenerator.getNextID();
        this.setCreated();
        this.setModified();
        this.setParent(null);
        this.setThought(null);
        this.setDescription("");
        this.setTopic(Topic.getDefault());
        this.setContext(Context.getDefault());
        this.setState(new ActionStateASAP());
        this.setNotes("");
        this.setDone(false);
        this.doneDate = null;
        this.setTime(null);
        this.setEnergy(null);
        this.setPriority(null);
    }

    private void setCreated() {
        this.created = Calendar.getInstance().getTime();
    }

    public void setCreated(Date created) {
        if (created == null) {
            return;
        }
        if (Utils.equal((Object)this.created, (Object)created)) {
            return;
        }
        this.created = created;
        this.setModified();
        this.notifyObservers(this);
    }

    public Date getCreated() {
        return this.created;
    }

    private void setModified() {
        this.modified = Calendar.getInstance().getTime();
    }

    public Thought getThought() {
        return this.thought;
    }

    public void setThought(Thought thought) {
        if (Utils.equal((Object)this.thought, (Object)thought)) {
            return;
        }
        this.thought = thought;
        this.setModified();
        this.notifyObservers(this);
    }

    public boolean isSingleAction() {
        return this.parent == null || this.parent instanceof ProjectSingleActions;
    }

    public boolean isActive() {
        return !this.done && !this.isStateInactive();
    }

    public Date getDoneDate() {
        return this.doneDate;
    }

    public ActionState getState() {
        return this.state;
    }

    public void setDoneDate(Date date) {
        this.doneDate = date;
        this.setDone(this.doneDate != null);
        this.setModified();
        this.notifyObservers(this);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        if (date != null) {
            date = DateUtils.clearTime((Date)date);
        }
        if (!Utils.equal((Object)this.startDate, (Object)date)) {
            this.startDate = date;
            this.setModified();
            this.notifyObservers(this);
        }
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date date) {
        if (date != null) {
            date = DateUtils.clearTime((Date)date);
        }
        if (!Utils.equal((Object)this.dueDate, (Object)date)) {
            this.dueDate = date;
            this.setModified();
            this.notifyObservers(this);
        }
    }

    public void setState(ActionState state) {
        if (state == null) {
            return;
        }
        if (state.equals((Object)this.state)) {
            return;
        }
        this.state = state;
        this.state.addObserver(this);
        this.setModified();
        this.notifyObservers(this);
    }

    public boolean isStateASAP() {
        return this.state instanceof ActionStateASAP;
    }

    public boolean isStateScheduled() {
        return this.state instanceof ActionStateScheduled;
    }

    public boolean isStateDelegated() {
        return this.state instanceof ActionStateDelegated;
    }

    public boolean isStateInactive() {
        return this.state instanceof ActionStateInactive;
    }

    public Topic getTopic() {
        if (this.topic == null) {
            return Topic.getDefault();
        }
        if (this.topic.getName().equals(Topic.getDefault().getName())) {
            return Topic.getDefault();
        }
        return this.topic;
    }

    public void setTopic(Topic topic) {
        if (Utils.equal((Object)this.topic, (Object)topic)) {
            return;
        }
        if (this.topic != null) {
            this.topic.removeObserver(this);
        }
        this.topic = topic;
        if (this.topic != null) {
            this.topic.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
    }

    public Context getContext() {
        if (this.context == null) {
            return Context.getDefault();
        }
        if (this.context.getName().equals(Context.getDefault().getName())) {
            return Context.getDefault();
        }
        return this.context;
    }

    public void setContext(Context context) {
        if (Utils.equal((Object)this.context, (Object)context)) {
            return;
        }
        if (this.context != null) {
            this.context.removeObserver(this);
        }
        this.context = context;
        if (this.context != null) {
            this.context.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
    }

    public Value getTime() {
        return this.time;
    }

    public void setTime(Value time) {
        if (Utils.equal((Object)this.time, (Object)time)) {
            return;
        }
        if (this.time != null) {
            this.time.removeObserver(this);
        }
        this.time = time;
        if (this.time != null) {
            this.time.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
    }

    public Value getEnergy() {
        return this.energy;
    }

    public void setEnergy(Value energy) {
        if (Utils.equal((Object)this.energy, (Object)energy)) {
            return;
        }
        if (this.energy != null) {
            this.energy.removeObserver(this);
        }
        this.energy = energy;
        if (this.energy != null) {
            this.energy.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
    }

    public Value getPriority() {
        return this.priority;
    }

    public void setPriority(Value priority) {
        if (Utils.equal((Object)this.priority, (Object)priority)) {
            return;
        }
        if (this.priority != null) {
            this.priority.removeObserver(this);
        }
        this.priority = priority;
        if (this.priority != null) {
            this.priority.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
    }

    public String getNotes() {
        return this.notes == null ? "" : this.notes;
    }

    public void setNotes(String notes) {
        if (Utils.equal((Object)this.notes, (Object)notes)) {
            return;
        }
        this.notes = notes;
        this.setModified();
        this.notifyObservers(this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Action)) {
            return false;
        }
        Action action = (Action)object;
        if (!Utils.equal((Object)this.created, (Object)action.created)) {
            return false;
        }
        if (!Utils.equal((Object)this.thought, (Object)action.thought)) {
            return false;
        }
        if (!Utils.equal((Object)this.description, (Object)action.description)) {
            return false;
        }
        if (!Utils.equal((Object)((Object)this.state), (Object)((Object)action.state))) {
            return false;
        }
        if (!Utils.equal((Object)this.context, (Object)action.context)) {
            return false;
        }
        if (!Utils.equal((Object)this.time, (Object)action.time)) {
            return false;
        }
        if (!Utils.equal((Object)this.energy, (Object)action.energy)) {
            return false;
        }
        if (!Utils.equal((Object)this.priority, (Object)action.priority)) {
            return false;
        }
        if (!Utils.equal((Object)this.success, (Object)action.success)) {
            return false;
        }
        if (!Utils.equal((Object)this.topic, (Object)action.topic)) {
            return false;
        }
        if (!Utils.equal((Object)this.notes, (Object)action.notes)) {
            return false;
        }
        if (!Utils.equal((Object)this.startDate, (Object)this.startDate)) {
            return false;
        }
        if (!Utils.equal((Object)this.dueDate, (Object)this.dueDate)) {
            return false;
        }
        if (this.done != this.done) {
            return false;
        }
        return Utils.equal((Object)this.doneDate, (Object)this.doneDate);
    }

    public String toString() {
        return this.getDescription();
    }

    public void update(Observable observable, Object arguement) {
        this.notifyObservers(this, arguement);
    }

    public void resetObservers() {
        if (this.state != null) {
            this.state.addObserver(this);
            this.state.resetObservers();
        }
        if (this.topic != null) {
            this.topic.addObserver(this);
            this.topic.resetObservers();
        }
        if (this.context != null) {
            this.context.addObserver(this);
            this.context.resetObservers();
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean canSetDone(boolean b) {
        return true;
    }

    public void setDone(boolean done) {
        if (this.done == done) {
            return;
        }
        this.done = done;
        if (done) {
            ActionStateScheduled s;
            Recurrence r;
            if (this.doneDate == null) {
                this.doneDate = Calendar.getInstance().getTime();
            }
            if (this.parent != null && !this.parent.isRoot()) {
                this.parent.sequence();
            }
            if (this.isStateScheduled() && (r = (s = (ActionStateScheduled)this.getState()).getRecurrence()) != null && r.getBasis() == Recurrence.Basis.DONE_DATE) {
                r.generateForDoneDateBasis(this);
            }
        } else {
            this.doneDate = null;
            if (this.parent != null && !this.parent.isRoot()) {
                this.parent.setDone(false);
            }
        }
        this.setModified();
        this.notifyObservers(this);
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.filter(this.description);
    }

    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        String newdesc = this.filter(description);
        if (Utils.equal((Object)this.description, (Object)newdesc)) {
            return;
        }
        this.description = newdesc;
        this.setModified();
        this.notifyObservers(this);
    }

    public String getSuccess() {
        return this.success == null ? "" : this.success;
    }

    public void setSuccess(String success) {
        if (Utils.equal((Object)this.success, (Object)success)) {
            return;
        }
        this.success = success;
        this.setModified();
        this.notifyObservers(this);
    }

    private String filter(String str) {
        str = str.replaceAll("\t", " ");
        str = str.replaceAll("\n", " ");
        str = str.replaceAll("\f", "");
        str = str.replaceAll("\r", "");
        return str;
    }

    public Icon getIcon(boolean expanded) {
        if (this.isStateASAP()) {
            return Resources.ICON_DOASAP;
        }
        if (this.isStateDelegated()) {
            return Resources.ICON_DELEGATED;
        }
        if (this.isStateScheduled()) {
            ActionStateScheduled s = (ActionStateScheduled)this.getState();
            Recurrence r = s.getRecurrence();
            if (r == null) {
                return Resources.ICON_SCHEDULED;
            }
            if (r.getBasis() == Recurrence.Basis.START_DATE) {
                return Resources.ICON_RECUR_START_BASIS;
            }
            return Resources.ICON_RECUR_DONE_BASIS;
        }
        if (this.isStateInactive()) {
            return Resources.ICON_INACTIVE;
        }
        return Resources.ICON_DOASAP;
    }

    public ItemList getParent() {
        return this.parent;
    }

    public void setParent(ItemList parent) {
        if (Utils.equal((Object)this.parent, (Object)parent)) {
            return;
        }
        if (parent instanceof Project) {
            this.parent = (Project)parent;
            this.setModified();
            this.notifyObservers(this);
        }
    }

    public Item copy(IDGenerator idGenerator) {
        Action copy = new Action(idGenerator);
        copy.setCreated();
        copy.setModified();
        copy.thought = this.thought;
        copy.parent = this.parent;
        copy.description = this.description;
        copy.success = this.success;
        copy.topic = this.topic;
        copy.context = this.context;
        copy.time = this.time;
        copy.energy = this.energy;
        copy.priority = this.priority;
        copy.state = this.state.copy();
        copy.notes = this.notes;
        copy.startDate = this.startDate;
        copy.dueDate = this.dueDate;
        copy.done = this.done;
        copy.doneDate = this.doneDate;
        return copy;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public boolean isWithin(ItemList list) {
        if (list == null || this.parent == null) {
            return false;
        }
        if (list == this.parent) {
            return true;
        }
        return this.parent.isWithin(list);
    }

    public boolean isEditable() {
        return true;
    }
}

