/*
 * Decompiled with CFR 0.152.
 */
package tr.model.Item;

import java.util.Iterator;
import java.util.Vector;
import tr.model.IDGenerator;
import tr.model.Item.AbstractItem;
import tr.model.Item.Item;
import tr.model.Item.ItemList;
import tr.model.Item.ItemSelector;
import tr.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemList
extends AbstractItem
implements ItemList {
    protected Vector<Item> items = new Vector();

    public AbstractItemList(IDGenerator idGenerator) {
        super(idGenerator);
    }

    @Override
    public void resetObservers() {
        for (Item item : this.items) {
            item.addObserver(this);
            item.resetObservers();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractItemList)) {
            return false;
        }
        AbstractItemList itemlist = (AbstractItemList)object;
        if (!Utils.equal(this.items, itemlist.items)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public abstract boolean canAdd(Item var1);

    @Override
    public boolean add(Item item) {
        if (!this.canAdd(item)) {
            return false;
        }
        if (!this.items.add(item)) {
            return false;
        }
        item.setParent(this);
        item.addObserver(this);
        this.notifyObservers(this, item);
        return true;
    }

    @Override
    public void add(int index, Item item) {
        if (!this.canAdd(item)) {
            return;
        }
        this.items.add(index, item);
        item.setParent(this);
        item.addObserver(this);
        this.notifyObservers(this, item);
    }

    @Override
    public Item remove(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        Item removed = this.items.remove(index);
        if (removed != null) {
            removed.removeObserver(this);
            this.notifyObservers(this, removed);
        }
        return removed;
    }

    @Override
    public boolean remove(Item item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return false;
        }
        return this.remove(index) != null;
    }

    @Override
    public boolean contains(Item item) {
        return this.items.contains(item);
    }

    @Override
    public boolean contains(Item item, boolean recurse) {
        if (this.contains(item)) {
            return true;
        }
        if (recurse) {
            Iterator<ItemList> i = this.iterator(ItemList.class);
            while (i.hasNext()) {
                if (!i.next().contains(item, recurse)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(ItemSelector selector, boolean recurse) {
        for (Item item : this.items) {
            if (selector.isSelected(item)) {
                return true;
            }
            if (!recurse || !(item instanceof ItemList) || !((ItemList)item).contains(selector, recurse)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Item> Iterator<T> iterator(Class<T> clazz) {
        Vector<T> result = new Vector<T>();
        for (Item item : this.items) {
            if (!clazz.isAssignableFrom(item.getClass())) continue;
            result.add(clazz.cast(item));
        }
        return result.iterator();
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public int indexOf(Item item) {
        return this.items.indexOf(item);
    }
}

