/*
 * Decompiled with CFR 0.152.
 */
package tr.model.Item;

import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.Item.ItemList;
import tr.model.project.Project;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Utils;

public abstract class AbstractItem
extends ObservableImpl
implements Item {
    protected Integer id;
    protected Date created;
    protected ItemList parent;
    protected String description;

    public AbstractItem(IDGenerator idGenerator) {
        this.id = idGenerator.getNextID();
        this.setCreated();
        this.setParent(null);
        this.setDescription("");
    }

    private void setCreated() {
        this.created = Calendar.getInstance().getTime();
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractItem)) {
            return false;
        }
        AbstractItem item = (AbstractItem)object;
        if (!Utils.equal((Object)this.created, (Object)item.created)) {
            return false;
        }
        return Utils.equal((Object)this.description, (Object)item.description);
    }

    public int getID() {
        return this.id;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (Utils.equal((Object)this.description, (Object)description)) {
            return;
        }
        this.description = description == null ? "" : description;
        this.notifyObservers(this);
    }

    public abstract Icon getIcon(boolean var1);

    public ItemList getParent() {
        return this.parent;
    }

    public void setParent(ItemList parent) {
        if (Utils.equal((Object)this.parent, (Object)parent)) {
            return;
        }
        if (parent instanceof Project) {
            this.parent = (Project)parent;
            this.notifyObservers(this);
        }
    }

    public abstract Item copy(IDGenerator var1);

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public boolean isWithin(ItemList list) {
        if (list == null || this.parent == null) {
            return false;
        }
        if (list == this.parent) {
            return true;
        }
        return this.parent.isWithin(list);
    }

    public boolean isEditable() {
        return true;
    }

    public void update(Observable observable, Object arguement) {
        this.notifyObservers(this, arguement);
    }

    public void resetObservers() {
    }
}

