/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

final class CloseButtonTabbedPane
extends JTabbedPane
implements ChangeListener {
    private final Image closeTabImage = this.isWindowsVista() ? Utilities.loadImage((String)"org/netbeans/core/output2/resources/vista_close_enabled.png") : Utilities.loadImage((String)"org/netbeans/core/output2/resources/tabclose.gif");
    private final Image closeTabPressedImage = this.isWindowsVista() ? Utilities.loadImage((String)"org/netbeans/core/output2/resources/vista_close_pressed.png") : null;
    private final Image closeTabMouseOverImage = this.isWindowsVista() ? Utilities.loadImage((String)"org/netbeans/core/output2/resources/vista_close_over.png") : null;
    private final Image closeTabInactiveImage = this.isWindowsVista() ? null : Utilities.loadImage((String)"org/netbeans/core/output2/resources/tabcloseinactive.gif");
    public static final String PROP_CLOSE = "close";
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private boolean draggedOut = false;

    CloseButtonTabbedPane() {
        this.addChangeListener(this);
        CloseButtonListener.install();
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new CBTPPolicy());
    }

    private Component sel() {
        int n = this.getTabCount();
        int n2 = this.getSelectedIndex();
        if (n2 != -1 && n2 >= n) {
            return n > 0 ? this.getComponentAt(n - 1) : this;
        }
        Component component = this.getSelectedComponent();
        return component == null ? this : component;
    }

    public int tabForCoordinate(int n, int n2) {
        return this.getUI().tabForCoordinate(this, n, n2);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.reset();
        if (this.getSelectedComponent() instanceof AbstractOutputPane) {
            ((AbstractOutputPane)this.getSelectedComponent()).ensureCaretPosition();
        }
    }

    public Component add(Component component) {
        Component component2 = super.add(component);
        String string = component.getName();
        if (string != null) {
            string = string + " ";
        }
        this.setTitleAt(this.getComponentCount() - 1, string);
        return component2;
    }

    public void setTitleAt(int n, String string) {
        String string2;
        String string3 = string2 = string.indexOf("</html>") != -1 ? Utilities.replaceString((String)string, (String)"</html>", (String)"&nbsp;&nbsp;</html>") : string + "  ";
        if (!string.equals(this.getTitleAt(n))) {
            super.setTitleAt(n, string2);
        }
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private Rectangle getCloseButtonBoundsAt(int n) {
        Rectangle rectangle = this.getBoundsAt(n);
        if (rectangle == null) {
            return null;
        }
        rectangle = new Rectangle(rectangle);
        CloseButtonTabbedPane.fixGetBoundsAt(rectangle);
        Dimension dimension = this.getSize();
        if (rectangle.x + rectangle.width >= dimension.width || rectangle.y + rectangle.height >= dimension.height) {
            return null;
        }
        if (this.isWindowsVista() && n == this.getSelectedIndex()) {
            --rectangle.x;
            rectangle.y -= 2;
        }
        return new Rectangle(rectangle.x + rectangle.width - 13, rectangle.y + rectangle.height / 2 - 5, 8, 8);
    }

    private static void checkUIColors() {
        if (UIManager.getColor("Button.shadow") == null) {
            UIManager.put("Button.shadow", new ColorUIResource(153, 153, 153));
        }
        if (UIManager.getColor("Button.darkShadow") == null) {
            UIManager.put("Button.darkShadow", new ColorUIResource(102, 102, 102));
        }
        if (UIManager.getColor("Button.highlight") == null) {
            UIManager.put("Button.highlight", new ColorUIResource(Color.white));
        }
        if (UIManager.getColor("Button.background") == null) {
            UIManager.put("Button.background", new ColorUIResource(204, 204, 204));
        }
    }

    private boolean isWindowsVista() {
        String string = System.getProperty("os.name");
        return string.indexOf("Vista") >= 0 || string.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        CloseButtonTabbedPane.checkUIColors();
        if (this.isWindowsVista()) {
            int n = this.getSelectedIndex();
            int n2 = this.getTabCount();
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle = this.getCloseButtonBoundsAt(i);
                if (rectangle == null) continue;
                if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                    graphics.drawImage(this.closeTabMouseOverImage, rectangle.x, rectangle.y, this);
                    continue;
                }
                if (i == this.pressedCloseButtonIndex) {
                    graphics.drawImage(this.closeTabPressedImage, rectangle.x, rectangle.y, this);
                    continue;
                }
                graphics.drawImage(this.closeTabImage, rectangle.x, rectangle.y, this);
            }
        } else {
            int n = this.getSelectedIndex();
            int n3 = this.getTabCount();
            for (int i = 0; i < n3; ++i) {
                Rectangle rectangle = this.getCloseButtonBoundsAt(i);
                if (rectangle == null) continue;
                if (i == this.pressedCloseButtonIndex && !this.draggedOut) {
                    graphics.setColor(UIManager.getColor("Button.shadow"));
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (i != n) {
                    graphics.drawImage(this.closeTabInactiveImage, rectangle.x + 2, rectangle.y + 2, this);
                } else {
                    graphics.drawImage(this.closeTabImage, rectangle.x + 2, rectangle.y + 2, this);
                }
                if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                    graphics.setColor(UIManager.getColor("Button.darkShadow"));
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.setColor(i == n ? UIManager.getColor("Button.highlight") : UIManager.getColor("Button.background"));
                    graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width, rectangle.height);
                    graphics.setColor(UIManager.getColor("Button.highlight").brighter());
                    graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + 1, rectangle.x + rectangle.width, rectangle.y + 1);
                    graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height, rectangle.x + 1, rectangle.y + rectangle.height);
                    continue;
                }
                if (i != this.pressedCloseButtonIndex) continue;
                graphics.setColor(UIManager.getColor("Button.shadow"));
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(i == n ? UIManager.getColor("Button.highlight") : UIManager.getColor("Button.background"));
                graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height + 1, rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height + 1);
                graphics.drawLine(rectangle.x + rectangle.width + 1, rectangle.y + 1, rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height + 1);
                graphics.setColor(UIManager.getColor("Button.background"));
                graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width, rectangle.y + 1);
                graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height);
            }
        }
    }

    private void setPressedCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.pressedCloseButtonIndex == n) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            JComponent jComponent = (JComponent)this.getComponentAt(this.pressedCloseButtonIndex);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, jComponent.getToolTipText());
        }
        this.pressedCloseButtonIndex = n;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.mouseOverCloseButtonIndex == n) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            JComponent jComponent = (JComponent)this.getComponentAt(this.mouseOverCloseButtonIndex);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, jComponent.getToolTipText());
        }
        this.mouseOverCloseButtonIndex = n;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private void fireCloseRequest(Component component) {
        this.firePropertyChange(PROP_CLOSE, null, component);
    }

    public static void fixGetBoundsAt(Rectangle rectangle) {
        if (rectangle.y < 0) {
            rectangle.y = -rectangle.y;
        }
        if (rectangle.x < 0) {
            rectangle.x = -rectangle.x;
        }
    }

    public static int findTabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            Rectangle rectangle = jTabbedPane.getBoundsAt(i);
            if (rectangle == null) continue;
            rectangle = new Rectangle(rectangle);
            CloseButtonTabbedPane.fixGetBoundsAt(rectangle);
            if (!rectangle.contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        try {
            super.processMouseEvent(mouseEvent);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ErrorManager.getDefault().annotate((Throwable)arrayIndexOutOfBoundsException, "Suppressed AIOOBE bug in BasicTabbedPaneUI");
            ErrorManager.getDefault().notify(1, (Throwable)arrayIndexOutOfBoundsException);
        }
    }

    private class CBTPPolicy
    extends FocusTraversalPolicy {
        private CBTPPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getComponentBefore(Container container, Component component) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getFirstComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getLastComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getDefaultComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }
    }

    private static class CloseButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private CloseButtonListener() {
        }

        private static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new CloseButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            Component component;
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            for (component = (Component)mouseEvent.getSource(); component != null && !(component instanceof CloseButtonTabbedPane); component = component.getParent()) {
            }
            if (component == null) {
                return;
            }
            CloseButtonTabbedPane closeButtonTabbedPane = (CloseButtonTabbedPane)component;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), closeButtonTabbedPane);
            if (mouseEvent.getID() == 500) {
                return;
            }
            int n = CloseButtonTabbedPane.findTabForCoordinate(closeButtonTabbedPane, point.x, point.y);
            Rectangle rectangle = null;
            if (n >= 0) {
                rectangle = closeButtonTabbedPane.getCloseButtonBoundsAt(n);
            }
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, 0, 0);
            }
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!rectangle.contains(point)) break;
                    closeButtonTabbedPane.setPressedCloseButtonIndex(n);
                    closeButtonTabbedPane.draggedOut = false;
                    mouseEvent.consume();
                    return;
                }
                case 502: {
                    if (rectangle.contains(point) && closeButtonTabbedPane.pressedCloseButtonIndex >= 0) {
                        Component component2 = closeButtonTabbedPane.getComponentAt(closeButtonTabbedPane.pressedCloseButtonIndex);
                        closeButtonTabbedPane.reset();
                        closeButtonTabbedPane.fireCloseRequest(component2);
                        mouseEvent.consume();
                        return;
                    }
                    closeButtonTabbedPane.reset();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (rectangle.contains(point)) {
                        closeButtonTabbedPane.setMouseOverCloseButtonIndex(n);
                        closeButtonTabbedPane.draggedOut = false;
                        mouseEvent.consume();
                        return;
                    }
                    if (closeButtonTabbedPane.mouseOverCloseButtonIndex < 0) break;
                    closeButtonTabbedPane.setMouseOverCloseButtonIndex(-1);
                    closeButtonTabbedPane.draggedOut = false;
                    mouseEvent.consume();
                    break;
                }
                case 506: {
                    if (closeButtonTabbedPane.pressedCloseButtonIndex < 0) break;
                    if (closeButtonTabbedPane.draggedOut != !rectangle.contains(point)) {
                        closeButtonTabbedPane.draggedOut = !rectangle.contains(point);
                        closeButtonTabbedPane.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
                    }
                    mouseEvent.consume();
                    return;
                }
            }
        }
    }
}

