/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.netbeans.core.output2.ui.CloseButtonTabbedPane;
import org.openide.windows.TopComponent;

public abstract class AbstractOutputWindow
extends TopComponent
implements ChangeListener,
PropertyChangeListener {
    protected JTabbedPane pane = new CloseButtonTabbedPane();
    private Runnable pendingFocusRunnable = null;
    private AbstractOutputTab lastKnownSelection = null;
    private final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID()) || UIManager.getLookAndFeel().getClass().getSuperclass().getName().indexOf("Synth") != -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractOutputWindow() {
        this.pane.addChangeListener(this);
        this.pane.addPropertyChangeListener("close", this);
        this.setFocusable(true);
        this.setBackground(UIManager.getColor("text"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("close".equals(propertyChangeEvent.getPropertyName())) {
            AbstractOutputTab abstractOutputTab = (AbstractOutputTab)propertyChangeEvent.getNewValue();
            this.closeRequest(abstractOutputTab);
        }
    }

    protected abstract void closeRequest(AbstractOutputTab var1);

    protected abstract void removed(AbstractOutputTab var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        this.setFocusable(false);
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean bl = this.hasFocus() || this.isAncestorOf(component2);
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            if (component instanceof AbstractOutputTab) {
                AbstractOutputTab abstractOutputTab = this.getInternalTab();
                if (abstractOutputTab != null) {
                    if (abstractOutputTab == component) {
                        return;
                    }
                    super.remove((Component)abstractOutputTab);
                    if (!$assertionsDisabled && this.pane.getParent() == this) {
                        throw new AssertionError();
                    }
                    this.pane.add(abstractOutputTab);
                    this.pane.add(component);
                    super.addImpl((Component)this.pane, object, n);
                    this.updateSingletonName(null);
                    this.revalidate();
                } else if (this.pane.getParent() == this) {
                    this.pane.add(component);
                    this.revalidate();
                } else {
                    super.addImpl(component, object, n);
                    this.revalidate();
                }
                if (bl) {
                    this.requestFocus();
                }
                return;
            }
            super.addImpl(component, object, n);
        }
        if (this.getComponentCount() == 1 && this.getComponent(0) instanceof AbstractOutputTab) {
            this.updateSingletonName(this.getComponent(0).getName());
        }
        this.revalidate();
    }

    public final AbstractOutputTab[] getTabs() {
        ArrayList<Component> arrayList = new ArrayList<Component>(this.pane.getParent() == this ? this.pane.getTabCount() : this.getComponentCount());
        if (this.pane.getParent() == this) {
            int n = this.pane.getTabCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.pane.getComponentAt(i);
                if (!(component instanceof AbstractOutputTab)) continue;
                arrayList.add(component);
            }
        } else {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof AbstractOutputTab)) continue;
                arrayList.add(componentArray[i]);
            }
        }
        AbstractOutputTab[] abstractOutputTabArray = new AbstractOutputTab[arrayList.size()];
        abstractOutputTabArray = arrayList.toArray(abstractOutputTabArray);
        return abstractOutputTabArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component component) {
        AbstractOutputTab abstractOutputTab = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.getParent() == this.pane && component instanceof AbstractOutputTab) {
                if (component == this.pane.getSelectedComponent()) {
                    if (Controller.log) {
                        Controller.log("Selected view is being removed: " + component.getName());
                    }
                    abstractOutputTab = (AbstractOutputTab)component;
                }
                this.checkWinXPLFBug();
                this.pane.remove(component);
                if (this.pane.getTabCount() == 1) {
                    Component component2 = this.pane.getComponentAt(0);
                    this.pane.remove(component2);
                    super.remove((Component)this.pane);
                    this.add(component2);
                    this.updateSingletonName(component.getName());
                    this.revalidate();
                }
            } else {
                if (component == this.getSelectedTab()) {
                    abstractOutputTab = (AbstractOutputTab)component;
                }
                super.remove(component);
                this.updateSingletonName(null);
            }
            if (abstractOutputTab != null) {
                this.fire(abstractOutputTab);
            }
        }
        if (component instanceof AbstractOutputTab && component.getParent() == null) {
            this.removed((AbstractOutputTab)component);
        }
        if (this.getComponentCount() == 1 && this.getComponent(0) instanceof AbstractOutputTab) {
            this.updateSingletonName(this.getComponent(0).getName());
        }
        this.revalidate();
        this.setFocusable(this.getComponentCount() == 0);
    }

    private AbstractOutputTab getInternalTab() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractOutputTab)) continue;
            return (AbstractOutputTab)componentArray[i];
        }
        return null;
    }

    public final AbstractOutputTab getSelectedTab() {
        if (this.pane.getParent() == this) {
            return (AbstractOutputTab)this.pane.getSelectedComponent();
        }
        return this.getInternalTab();
    }

    public void setSelectedTab(AbstractOutputTab abstractOutputTab) {
        if (!$assertionsDisabled && abstractOutputTab.getParent() != this && abstractOutputTab.getParent() != this.pane) {
            throw new AssertionError();
        }
        if (Controller.log) {
            Controller.log("SetSelectedTab: " + abstractOutputTab + " parent is " + abstractOutputTab.getParent());
        }
        if (this.pane.getParent() == this && abstractOutputTab != this.pane.getSelectedComponent()) {
            this.pane.setSelectedComponent(abstractOutputTab);
        }
        this.getActionMap().setParent(abstractOutputTab.getActionMap());
    }

    public void setTabTitle(AbstractOutputTab abstractOutputTab, String string) {
        if (abstractOutputTab.getParent() == this.pane) {
            this.pane.setTitleAt(this.pane.indexOfComponent(abstractOutputTab), string);
        } else if (abstractOutputTab.getParent() == this) {
            this.updateSingletonName(string);
        }
        abstractOutputTab.setName(string);
    }

    public void requestFocus() {
        if (!this.isShowing()) {
            return;
        }
        AbstractOutputTab abstractOutputTab = this.getSelectedTab();
        if (abstractOutputTab != null && this.pendingFocusRunnable == null) {
            this.pendingFocusRunnable = new Runnable(){

                public void run() {
                    AbstractOutputTab abstractOutputTab = AbstractOutputWindow.this.getSelectedTab();
                    if (abstractOutputTab != null) {
                        abstractOutputTab.requestFocus();
                    }
                    AbstractOutputWindow.this.pendingFocusRunnable = null;
                }
            };
            SwingUtilities.invokeLater(this.pendingFocusRunnable);
        } else {
            super.requestFocus();
        }
    }

    protected abstract void updateSingletonName(String var1);

    public void doLayout() {
        Insets insets = this.getInsets();
        Component component = null;
        if (this.pane.getParent() == this) {
            component = this.pane;
        } else if (this.getComponentCount() > 0) {
            component = this.getComponent(0);
        }
        if (component != null) {
            component.setBounds(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
        }
    }

    protected void fire(AbstractOutputTab abstractOutputTab) {
        AbstractOutputTab abstractOutputTab2 = this.getSelectedTab();
        if (abstractOutputTab != abstractOutputTab2) {
            this.selectionChanged(abstractOutputTab, abstractOutputTab2);
            this.lastKnownSelection = abstractOutputTab2;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fire(this.lastKnownSelection);
    }

    protected abstract void selectionChanged(AbstractOutputTab var1, AbstractOutputTab var2);

    public void paint(Graphics graphics) {
        if (this.isGtk) {
            Color color = this.getBackground();
            if (color == null) {
                color = Color.WHITE;
            }
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(graphics);
    }

    public final void selectNextTab(AbstractOutputTab abstractOutputTab) {
        AbstractOutputTab[] abstractOutputTabArray = this.getTabs();
        if (abstractOutputTabArray.length > 1) {
            int n = this.getSelectedTabIndex(abstractOutputTabArray, abstractOutputTab) + 1;
            if (n > abstractOutputTabArray.length - 1) {
                n = 0;
            }
            this.setSelectedTab(abstractOutputTabArray[n]);
        }
    }

    public final void selectPreviousTab(AbstractOutputTab abstractOutputTab) {
        AbstractOutputTab[] abstractOutputTabArray = this.getTabs();
        if (abstractOutputTabArray.length > 1) {
            int n = this.getSelectedTabIndex(abstractOutputTabArray, abstractOutputTab) - 1;
            if (n < 0) {
                n = abstractOutputTabArray.length - 1;
            }
            this.setSelectedTab(abstractOutputTabArray[n]);
        }
    }

    private int getSelectedTabIndex(AbstractOutputTab[] abstractOutputTabArray, AbstractOutputTab abstractOutputTab) {
        for (int i = 0; i < abstractOutputTabArray.length; ++i) {
            if (abstractOutputTabArray[i] != abstractOutputTab) continue;
            return i;
        }
        return -1;
    }

    private void checkWinXPLFBug() {
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            TabbedPaneUI tabbedPaneUI = this.pane.getUI();
            try {
                Method method = tabbedPaneUI.getClass().getDeclaredMethod("setRolloverTab", Integer.TYPE);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke((Object)tabbedPaneUI, new Integer(-1));
                    method.setAccessible(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        $assertionsDisabled = !AbstractOutputWindow.class.desiredAssertionStatus();
    }
}

