/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.InputPanel;
import org.netbeans.core.output2.ui.WeakAction;

public abstract class AbstractOutputTab
extends JComponent
implements ActionListener,
Accessible {
    private JToolBar toolbar = null;
    private InputPanel input = null;
    private AbstractOutputPane outputPane;
    private Action[] actions = new Action[0];
    private Component toFocus;

    public AbstractOutputTab() {
        this.outputPane = this.createOutputPane();
        this.add(this.outputPane);
        this.setFocusable(false);
    }

    public void setDocument(Document document) {
        this.outputPane.setDocument(document);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return AbstractOutputTab.this.getName();
                }
            };
        }
        return this.accessibleContext;
    }

    public void setToFocus(Component component) {
        this.toFocus = component;
    }

    public void requestFocus() {
        if (this.toFocus != null) {
            this.toFocus.requestFocus();
            this.toFocus = null;
            return;
        }
        if (this.isInputVisible()) {
            this.input.requestFocus();
        } else {
            this.outputPane.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.isInputVisible()) {
            return this.input.requestFocusInWindow();
        }
        return this.getOutputPane().requestFocusInWindow();
    }

    protected abstract AbstractOutputPane createOutputPane();

    protected abstract void inputSent(String var1);

    public final AbstractOutputPane getOutputPane() {
        return this.outputPane;
    }

    public final void setToolbarActions(Action[] actionArray) {
        if (actionArray == null || actionArray.length == 0) {
            this.setToolbarVisible(false);
            return;
        }
        if (actionArray.length > 5) {
            throw new IllegalArgumentException("No more than 5 actions allowedin the output window toolbar");
        }
        this.setToolbarVisible(true);
        if (this.toolbar.getComponentCount() > 0) {
            this.toolbar.removeAll();
        }
        this.actions = new Action[actionArray.length];
        JButton[] jButtonArray = new JButton[actionArray.length];
        for (int i = 0; i < jButtonArray.length; ++i) {
            this.actions[i] = actionArray[i];
            this.installKeyboardAction(this.actions[i]);
            jButtonArray[i] = new JButton(this.actions[i]);
            jButtonArray[i].setBorderPainted(false);
            jButtonArray[i].setOpaque(false);
            jButtonArray[i].setText(null);
            jButtonArray[i].putClientProperty("hideActionText", Boolean.TRUE);
            if (actionArray[i].getValue("SmallIcon") == null) {
                throw new IllegalStateException("No icon provided for " + actionArray);
            }
            this.toolbar.add(jButtonArray[i]);
        }
    }

    public Action[] getToolbarActions() {
        return this.actions;
    }

    public void installKeyboardAction(Action action) {
        if (!(action instanceof WeakAction)) {
            action = new WeakAction(action);
        }
        KeyStroke keyStroke = null;
        Object object = action.getValue("AcceleratorKey");
        if (object instanceof KeyStroke) {
            keyStroke = (KeyStroke)object;
        }
        String string = (String)action.getValue("Name");
        if (keyStroke != null) {
            if (Controller.log) {
                Controller.log("Installed action " + string + " on " + keyStroke);
            }
            JEditorPane jEditorPane = this.getOutputPane().textView;
            jEditorPane.getInputMap().put(keyStroke, string);
            jEditorPane.getActionMap().put(string, action);
            this.getInputMap(1).put(keyStroke, string);
            this.getActionMap().put(string, action);
        }
    }

    public final boolean isInputVisible() {
        return this.input != null && this.input.getParent() == this && this.input.isVisible();
    }

    public final boolean isToolbarVisible() {
        return this.toolbar != null && this.toolbar.getParent() == this && this.toolbar.isVisible();
    }

    public final void setInputVisible(boolean bl) {
        if (bl == this.isInputVisible()) {
            return;
        }
        if (bl) {
            if (this.input == null) {
                this.input = new InputPanel();
                this.input.addActionListener(this);
            }
            if (this.input.getParent() != this) {
                this.add(this.input);
                this.validate();
            }
        }
        this.input.setVisible(bl);
        this.validate();
        this.getOutputPane().ensureCaretPosition();
    }

    public final void setToolbarVisible(boolean bl) {
        if (bl == this.isToolbarVisible()) {
            return;
        }
        if (bl) {
            if (this.toolbar == null) {
                this.toolbar = new JToolBar();
                this.toolbar.setOrientation(1);
                this.toolbar.setLayout(new BoxLayout(this.toolbar, 1));
                this.toolbar.setFloatable(false);
                this.toolbar.setOpaque(false);
            }
            if (this.toolbar.getParent() != this) {
                this.add(this.toolbar);
            }
        }
        this.toolbar.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        InputPanel inputPanel = (InputPanel)actionEvent.getSource();
        if ("eof".equals(actionEvent.getActionCommand())) {
            this.inputEof();
        } else {
            this.inputSent(inputPanel.getText());
        }
    }

    protected abstract void inputEof();

    public void doLayout() {
        AbstractOutputPane abstractOutputPane;
        int n;
        boolean bl = this.isToolbarVisible();
        boolean bl2 = this.isInputVisible();
        Insets insets = this.getInsets();
        int n2 = insets.left;
        int n3 = n = bl2 ? this.getHeight() - insets.bottom - this.input.getPreferredSize().height - 3 : this.getHeight() - insets.bottom;
        if (bl) {
            n2 = insets.left + Math.max(32, this.toolbar.getPreferredSize().width);
            this.toolbar.setBounds(insets.left, insets.top, n2, this.getHeight() - (insets.top + insets.bottom));
        }
        if ((abstractOutputPane = this.outputPane) != null) {
            abstractOutputPane.setBounds(n2, insets.top, this.getWidth() - (n2 + insets.right), n - insets.top);
        }
        if (bl2) {
            this.input.setBounds(n2, n, this.getWidth() - (n2 + insets.right), this.getHeight() - n);
        }
    }

    public abstract void hasSelectionChanged(boolean var1);

    void notifyInputFocusGained() {
        this.getOutputPane().lockScroll();
        this.getOutputPane().ensureCaretPosition();
    }
}

