/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IntList;
import org.netbeans.core.output2.IntMap;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.SparseIntList;
import org.netbeans.core.output2.Storage;
import org.openide.ErrorManager;
import org.openide.util.Mutex;
import org.openide.windows.OutputListener;

abstract class AbstractLines
implements Lines,
Runnable {
    IntList lineStartList;
    IntMap linesToListeners;
    private int longestLine = 0;
    private static Boolean unitTestUseCache;
    private int knownCharCount = -1;
    private SparseIntList knownLogicalLineCounts = null;
    private int lastCharCountForWrapCalculation = -1;
    private int lastWrappedLineCount = -1;
    private int lastCharCountForWrapAboveCalculation = -1;
    private int lastWrappedAboveLineCount = -1;
    private int lastWrappedAboveLine = -1;
    private IntList errLines = null;
    private int lastErrLineMarked = -1;
    private ChangeListener listener = null;
    private boolean dirty;
    private IntList importantLines = new IntList(10);
    private String lastSearchString = null;
    private Matcher matcher = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractLines() {
        if (Controller.log) {
            Controller.log("Creating a new AbstractLines");
        }
        this.init();
    }

    protected abstract Storage getStorage();

    protected abstract boolean isDisposed();

    protected abstract boolean isTrouble();

    protected abstract void handleException(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getText(int n, int n2, char[] cArray) {
        if (this.isDisposed() || this.isTrouble()) {
            if (Controller.log) {
                Controller.log(this + "  !!!!!REQUEST FOR SUBRANGE " + n + "-" + n2 + " AFTER OUTWRITER HAS BEEN DISPOSED!!");
            }
            char[] cArray2 = "THIS OUTPUT HAS BEEN DISPOSED! ".toCharArray();
            if (cArray == null) {
                cArray = new char[n2 - n];
            }
            int n3 = 0;
            for (int i = 0; i < cArray.length; ++i) {
                if (n3 == cArray2.length - 1) {
                    n3 = 0;
                }
                cArray[i] = cArray2[n3];
                ++n3;
            }
            return cArray;
        }
        if (n2 < n) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + n2);
        }
        Object object = this.readLock();
        synchronized (object) {
            int n4 = AbstractLines.toByteIndex(n);
            int n5 = AbstractLines.toByteIndex(n2 - n);
            try {
                CharBuffer charBuffer = this.getStorage().getReadBuffer(n4, n5).asCharBuffer();
                int n6 = Math.min(n2 - n, charBuffer.remaining());
                if (cArray.length < n6) {
                    cArray = new char[n6];
                }
                charBuffer.get(cArray, 0, n6);
                return cArray;
            }
            catch (Exception exception) {
                this.handleException(exception);
                return new char[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int n, int n2) {
        if (this.isDisposed() || this.isTrouble()) {
            return new String(new char[n2 - n]);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + n2);
        }
        Object object = this.readLock();
        synchronized (object) {
            int n3 = AbstractLines.toByteIndex(n);
            int n4 = AbstractLines.toByteIndex(n2 - n);
            int n5 = this.getStorage().size();
            if (n5 < n3 + n4) {
                throw new ArrayIndexOutOfBoundsException("Bytes from " + n3 + " to " + (n3 + n4) + " requested, " + "but storage is only " + n5 + " bytes long");
            }
            try {
                return this.getStorage().getReadBuffer(n3, n4).asCharBuffer().toString();
            }
            catch (Exception exception) {
                this.handleException(exception);
                return new String(new char[n2 - n]);
            }
        }
    }

    void markErr() {
        int n;
        if (this.isTrouble() || this.getStorage().isClosed()) {
            return;
        }
        if (this.errLines == null) {
            this.errLines = new IntList(20);
        }
        if ((n = this.getLineCount()) != this.lastErrLineMarked) {
            this.errLines.add(n == 0 ? 0 : n - 1);
            this.lastErrLineMarked = n;
        }
    }

    public boolean isErr(int n) {
        return this.errLines != null ? this.errLines.contains(n) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
        AbstractLines abstractLines = this;
        synchronized (abstractLines) {
            if (this.getLineCount() > 0) {
                this.fire();
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listener == changeListener) {
            this.listener = null;
        }
    }

    public void fire() {
        if (this.isTrouble()) {
            return;
        }
        if (Controller.log) {
            Controller.log(this + ": Writer firing " + this.getStorage().size() + " bytes written");
        }
        if (this.listener != null) {
            Mutex.EVENT.readAccess((Runnable)this);
        }
    }

    public void run() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean hasHyperlinks() {
        return this.firstListenerLine() != -1;
    }

    public boolean isHyperlink(int n) {
        return this.getListenerForLine(n) != null;
    }

    private void init() {
        this.knownLogicalLineCounts = null;
        this.lineStartList = new IntList(100);
        this.linesToListeners = new IntMap();
        this.setLastWrappedLineCount(-1);
        this.longestLine = 0;
        this.errLines = null;
        this.matcher = null;
        this.listener = null;
        this.dirty = false;
    }

    public boolean checkDirty(boolean bl) {
        if (this.isTrouble()) {
            return false;
        }
        boolean bl2 = this.dirty;
        if (bl) {
            this.dirty = false;
        }
        return bl2;
    }

    public int[] allListenerLines() {
        return this.linesToListeners.getKeys();
    }

    void clear() {
        this.init();
    }

    public int getCharCount() {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        Storage storage = this.getStorage();
        return storage == null ? 0 : AbstractLines.toCharIndex(this.getStorage().size());
    }

    public String getLine(int n) throws IOException {
        if (this.isDisposed() || this.isTrouble()) {
            return "";
        }
        int n2 = this.lineStartList.get(n);
        int n3 = n != this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) : this.getStorage().size();
        CharBuffer charBuffer = this.getStorage().getReadBuffer(n2, n3 - n2).asCharBuffer();
        char[] cArray = new char[charBuffer.limit()];
        charBuffer.get(cArray);
        return new String(cArray);
    }

    private int getLineLength(int n) {
        int n2 = this.lineStartList.get(n);
        int n3 = n != this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) : this.getStorage().size();
        return n3 - n2;
    }

    public boolean isLineStart(int n) {
        int n2 = AbstractLines.toByteIndex(n);
        return this.lineStartList.contains(n2);
    }

    public int length(int n) {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        if (this.lineStartList.size() == 0) {
            return 0;
        }
        int n2 = this.lineStartList.get(n);
        int n3 = n != this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) : this.getStorage().size();
        return AbstractLines.toCharIndex(n3 - n2);
    }

    public int getLineStart(int n) {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        if (this.lineStartList.size() == 0) {
            return 0;
        }
        return AbstractLines.toCharIndex(this.lineStartList.get(n));
    }

    public int getLineAt(int n) {
        if (this.isDisposed() || this.isTrouble()) {
            return -1;
        }
        int n2 = AbstractLines.toByteIndex(n);
        int n3 = this.lineStartList.indexOf(n2);
        if (n3 != -1) {
            return n3;
        }
        n3 = this.lineStartList.findNearest(n2);
        return n3;
    }

    public int getLineCount() {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        return this.lineStartList.size();
    }

    public OutputListener getListenerForLine(int n) {
        return (OutputListener)this.linesToListeners.get(n);
    }

    public int firstListenerLine() {
        if (this.isDisposed() || this.isTrouble()) {
            return -1;
        }
        return this.linesToListeners.isEmpty() ? -1 : this.linesToListeners.first();
    }

    public int nearestListenerLine(int n, boolean bl) {
        if (this.isDisposed() || this.isTrouble()) {
            return -1;
        }
        return this.linesToListeners.nearest(n, bl);
    }

    public int getLongestLineLength() {
        return AbstractLines.toCharIndex(this.longestLine);
    }

    public void toLogicalLineIndex(int[] nArray, int n) {
        int n2 = nArray[0];
        nArray[1] = 0;
        if (n2 == 0) {
            nArray[1] = 0;
            nArray[2] = this.length(n2) / n;
        }
        if (n >= this.getLongestLineLength() || this.getLineCount() <= 1) {
            nArray[1] = 0;
            nArray[2] = 1;
            return;
        }
        int n3 = this.findFirstLineWithoutMoreLinesAboveItThan(n2, n);
        int n4 = this.getLogicalLineCountAbove(n3, n);
        int n5 = this.length(n3);
        int n6 = n5 > n ? n5 / n + 1 : 1;
        nArray[0] = n3;
        int n7 = n4 + n6;
        nArray[1] = n6 - (n7 - n2);
        nArray[2] = n6;
    }

    private int findFirstLineWithoutMoreLinesAboveItThan(int n, int n2) {
        int n3 = 0;
        int n4 = this.getLineCount();
        int n5 = n3 + (n4 - n3 >> 1);
        int n6 = this.getLogicalLineCountAbove(n5, n2);
        int n7 = this.divideAndConquer(n, n3, n5, n4, n2, n6);
        return Math.min(n4, n7) - 1;
    }

    private int divideAndConquer(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 == n) {
            return n3 + 1;
        }
        if (n4 - n2 <= 1 || n3 == n2 || n3 == n4) {
            return n4;
        }
        if (n6 > n) {
            int n7 = n2 + (n3 - n2 >> 1);
            if ((n3 - n2) % 2 != 0) {
                ++n7;
            }
            int n8 = this.getLogicalLineCountAbove(n7, n5);
            return this.divideAndConquer(n, n2, n7, n3, n5, n8);
        }
        int n9 = (n4 - n2 >> 2) + n3;
        if ((n4 - n3) % 2 != 0) {
            ++n9;
        }
        int n10 = this.getLogicalLineCountAbove(n9, n5);
        return this.divideAndConquer(n, n3, n9, n4, n5, n10);
    }

    public int getLogicalLineCountAbove(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (AbstractLines.toByteIndex(n2) > this.longestLine) {
            return n;
        }
        if (unitTestUseCache != null) {
            if (Boolean.TRUE.equals(unitTestUseCache)) {
                return this.dynLogicalLineCountAbove(n, n2);
            }
            return this.cachedLogicalLineCountAbove(n, n2);
        }
        if (this.getStorage().size() < 100000) {
            return this.dynLogicalLineCountAbove(n, n2);
        }
        return this.cachedLogicalLineCountAbove(n, n2);
    }

    public int getLogicalLineCountIfWrappedAt(int n) {
        if (AbstractLines.toByteIndex(n) > this.longestLine) {
            return this.getLineCount();
        }
        if (unitTestUseCache != null) {
            if (Boolean.TRUE.equals(unitTestUseCache)) {
                return this.dynLogicalLineCountIfWrappedAt(n);
            }
            return this.cachedLogicalLineCountIfWrappedAt(n);
        }
        if (this.getStorage().size() < 100000) {
            return this.dynLogicalLineCountIfWrappedAt(n);
        }
        return this.cachedLogicalLineCountIfWrappedAt(n);
    }

    public void addListener(int n, OutputListener outputListener, boolean bl) {
        if (outputListener == null) {
            ErrorManager.getDefault().log(1, "Warning: Issue #56826 - Adding a null OutputListener for line:" + n);
        } else {
            this.linesToListeners.put(n, outputListener);
            if (bl) {
                this.importantLines.add(n);
            }
        }
    }

    public int firstImportantListenerLine() {
        return this.importantLines.size() == 0 ? -1 : this.importantLines.get(0);
    }

    public boolean isImportantHyperlink(int n) {
        return this.importantLines.contains(n);
    }

    static void unitTestUseCache(Boolean bl) {
        unitTestUseCache = bl;
    }

    private int cachedLogicalLineCountAbove(int n, int n2) {
        if (n2 != this.knownCharCount || this.knownLogicalLineCounts == null) {
            this.knownCharCount = n2;
            this.calcCharCounts(n2);
        }
        return this.knownLogicalLineCounts.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cachedLogicalLineCountIfWrappedAt(int n) {
        int n2 = this.getLineCount();
        if (n == 0 || n2 == 0) {
            return 0;
        }
        Object object = this.readLock();
        synchronized (object) {
            if (n != this.knownCharCount || this.knownLogicalLineCounts == null) {
                this.knownCharCount = n;
                this.calcCharCounts(n);
            }
            int n3 = this.knownLogicalLineCounts.get(n2 - 1);
            int n4 = this.length(n2 - 1);
            return n3 += n4 / n + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcCharCounts(int n) {
        Object object = this.readLock();
        synchronized (object) {
            int n2 = this.getLineCount();
            this.knownLogicalLineCounts = new SparseIntList(30);
            int n3 = 0;
            for (int i = 1; i < n2; ++i) {
                int n4 = this.length(i);
                if (n4 > n) {
                    this.knownLogicalLineCounts.add(n3 += n4 / n + 1, i);
                    continue;
                }
                ++n3;
            }
            this.knownCharCount = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dynLogicalLineCountIfWrappedAt(int n) {
        Object object = this.readLock();
        synchronized (object) {
            int n2 = AbstractLines.toByteIndex(n);
            if (this.longestLine <= n2) {
                return this.lineStartList.size();
            }
            if (n == this.lastCharCountForWrapCalculation && this.lastWrappedLineCount != -1) {
                return this.lastWrappedLineCount;
            }
            if (this.lineStartList.size() == 0) {
                return 0;
            }
            int n3 = this.lineStartList.size();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                int n5 = this.getLineLength(i);
                n4 += n5 > n2 ? n5 / n2 + 1 : 1;
            }
            this.setLastCharCountForWrapCalculation(n);
            this.lastWrappedLineCount = n4;
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dynLogicalLineCountAbove(int n, int n2) {
        int n3 = this.getLineCount();
        if (n == 0 || n3 == 0) {
            return 0;
        }
        if (n2 == this.lastCharCountForWrapAboveCalculation && this.lastWrappedAboveLineCount != -1 && n == this.lastWrappedAboveLine) {
            return this.lastWrappedAboveLineCount;
        }
        Object object = this.readLock();
        synchronized (object) {
            this.lastWrappedAboveLineCount = 0;
            for (int i = 0; i < n; ++i) {
                int n4 = this.length(i);
                if (n4 > n2) {
                    this.lastWrappedAboveLineCount += n4 / n2 + 1;
                    continue;
                }
                ++this.lastWrappedAboveLineCount;
            }
            this.lastWrappedAboveLine = n;
            this.setLastCharCountForWrapAboveCalculation(n2);
            return this.lastWrappedAboveLineCount;
        }
    }

    void markDirty() {
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineStarted(int n) {
        if (Controller.verbose) {
            Controller.log("AbstractLines.lineStarted " + n);
        }
        int n2 = 0;
        Object object = this.readLock();
        synchronized (object) {
            this.setLastWrappedLineCount(-1);
            this.setLastCharCountForWrapAboveCalculation(-1);
            this.lineStartList.add(n);
            this.matcher = null;
            n2 = this.lineStartList.size();
        }
        if (n2 == 20 || n2 == 10 || n2 == 1) {
            if (Controller.log) {
                Controller.log("Firing initial write event");
            }
            this.fire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineFinished(int n) {
        Object object = this.readLock();
        synchronized (object) {
            this.setLastWrappedLineCount(-1);
            this.setLastCharCountForWrapAboveCalculation(-1);
            this.longestLine = Math.max(this.longestLine, n);
            this.matcher = null;
            int n2 = this.lineStartList.size();
            int n3 = n2 - 1;
            this.checkLogicalLineCount(n3);
        }
    }

    private void checkLogicalLineCount(int n) {
        int n2;
        if (this.knownLogicalLineCounts != null && (n2 = this.length(n)) > this.knownCharCount) {
            int n3 = this.knownLogicalLineCounts.lastIndex() != -1 ? n - (this.knownLogicalLineCounts.lastIndex() + 1) + this.knownLogicalLineCounts.lastAdded() : Math.max(0, n - 1);
            this.knownLogicalLineCounts.add(n3 += n2 / this.knownCharCount + 1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineWritten(int n, int n2) {
        if (Controller.verbose) {
            Controller.log("AbstractLines.lineWritten " + n + " length:" + n2);
        }
        int n3 = 0;
        Object object = this.readLock();
        synchronized (object) {
            this.setLastWrappedLineCount(-1);
            this.setLastCharCountForWrapAboveCalculation(-1);
            this.longestLine = Math.max(this.longestLine, n2);
            this.lineStartList.add(n);
            this.matcher = null;
            n3 = this.lineStartList.size();
            int n4 = n3 - 1;
            this.checkLogicalLineCount(n4);
        }
        if (n3 == 20 || n3 == 10 || n3 == 1) {
            if (Controller.log) {
                Controller.log("Firing initial write event");
            }
            this.fire();
        }
    }

    static int toByteIndex(int n) {
        return n << 1;
    }

    static int toCharIndex(int n) {
        if (!$assertionsDisabled && n % 2 != 0) {
            throw new AssertionError((Object)("bad index: " + n));
        }
        int n2 = n >> 1;
        return n2;
    }

    public void saveAs(String string) throws IOException {
        if (this.getStorage() == null) {
            throw new IOException("Data has already been disposed");
        }
        File file = new File(string);
        CharBuffer charBuffer = this.getStorage().getReadBuffer(0, this.getStorage().size()).asCharBuffer();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        String string2 = System.getProperty("file.encoding");
        if (string2 == null) {
            string2 = "UTF-8";
        }
        Charset charset = Charset.forName(string2);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
        FileChannel fileChannel = fileOutputStream.getChannel();
        fileChannel.write(byteBuffer);
        fileChannel.close();
    }

    public Matcher getForwardMatcher() {
        return this.matcher;
    }

    public Matcher getReverseMatcher() {
        try {
            Storage storage = this.getStorage();
            if (storage == null) {
                return null;
            }
            if (this.matcher != null && this.lastSearchString != null && this.lastSearchString.length() > 0 && storage.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer(this.lastSearchString);
                stringBuffer.reverse();
                CharBuffer charBuffer = storage.getReadBuffer(0, storage.size()).asCharBuffer();
                StringBuffer stringBuffer2 = new StringBuffer(charBuffer.toString());
                stringBuffer2.reverse();
                Pattern pattern = AbstractLines.escapePattern(stringBuffer.toString());
                return pattern.matcher(stringBuffer2);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return null;
    }

    public Matcher find(String string) {
        Storage storage;
        if (Controller.log) {
            Controller.log(this + ": Executing find for string " + string + " on ");
        }
        if ((storage = this.getStorage()) == null) {
            return null;
        }
        if (this.matcher != null && string.equals(this.lastSearchString)) {
            return this.matcher;
        }
        try {
            int n = storage.size();
            if (n > 0) {
                CharBuffer charBuffer;
                Pattern pattern = AbstractLines.escapePattern(string);
                Matcher matcher = pattern.matcher(charBuffer = storage.getReadBuffer(0, n).asCharBuffer());
                if (!matcher.find(0)) {
                    return null;
                }
                this.matcher = matcher;
                this.lastSearchString = string;
                return this.matcher;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return null;
    }

    static Pattern escapePattern(String string) {
        String string2 = string.replaceAll("([\\(\\)\\[\\]\\^\\*\\.\\$\\{\\}\\?\\+\\\\])", "\\\\$1");
        return Pattern.compile(string2, 2);
    }

    private void setLastCharCountForWrapCalculation(int n) {
        this.lastCharCountForWrapCalculation = n;
    }

    private void setLastWrappedLineCount(int n) {
        this.lastWrappedLineCount = n;
    }

    private void setLastCharCountForWrapAboveCalculation(int n) {
        this.lastCharCountForWrapAboveCalculation = n;
    }

    public String toString() {
        return this.lineStartList.toString();
    }

    static {
        $assertionsDisabled = !AbstractLines.class.desiredAssertionStatus();
        unitTestUseCache = null;
    }
}

