/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects.actions;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.openide.actions.PasteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.project.Project;
import tr.view.projects.AddActionAction;
import tr.view.projects.HideDoneAction;
import tr.view.projects.ProjectNode;
import tr.view.projects.Resources;
import tr.view.projects.ShowDoneAction;
import tr.view.projects.TransferNode;
import tr.view.projects.actions.SingleActionsChildren;
import tr.view.projects.actions.SingleActionsLookup;

public class SingleActionsRootNode
extends ProjectNode {
    private final Project root;
    static final int MASK_ANY = 7;

    public SingleActionsRootNode(Project root, boolean showDone) {
        super(new SingleActionsChildren(root, showDone));
        this.root = root;
    }

    public Image getIcon(int type) {
        return Resources.ICON_PROJECT.getImage();
    }

    public Image getOpenedIcon(int type) {
        return Resources.ICON_PROJECT_OPENED.getImage();
    }

    public javax.swing.Action[] getActions(boolean popup) {
        return new javax.swing.Action[]{SystemAction.get(ShowDoneAction.class), SystemAction.get(HideDoneAction.class), null, SystemAction.get(AddActionAction.class), null, SystemAction.get(PasteAction.class)};
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public PasteType getDropType(Transferable t, int actn, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        if (dropNode != null && dropNode instanceof TransferNode) {
            final TransferNode transferNode = (TransferNode)dropNode;
            Action dropAction = (Action)dropNode.getLookup().lookup(Action.class);
            if (dropAction != null) {
                Action transferAction;
                Action action = transferAction = transferNode.isMoveTransfer() ? dropAction : (Action)dropAction.copy((IDGenerator)this.getData());
                if (transferAction != null && this.root.canAdd((Item)transferAction)) {
                    return new PasteType(){

                        public Transferable paste() throws IOException {
                            if (transferNode.isMoveTransfer()) {
                                SingleActionsRootNode.this.move(transferAction, transferNode);
                            } else {
                                transferAction.setThought(null);
                                SingleActionsRootNode.this.root.add((Item)transferAction);
                            }
                            return null;
                        }
                    };
                }
            }
        }
        return null;
    }

    public synchronized void setShowDone(boolean showDone) {
        this.showDone = showDone;
        this.setChildren((Children)new SingleActionsChildren(this.root, showDone));
        this.fireCookieChange();
        this.getTreeView().expandNode((Node)this);
    }

    public TreeView getTreeView() {
        return SingleActionsLookup.lookup().getTreeView();
    }

    public ExplorerManager getExplorerManager() {
        return SingleActionsLookup.lookup().getExplorerManager();
    }
}

