/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.global.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectsTreeLookup;
import tr.view.projects.ProjectsTreeTopComponent;
import tr.view.projects.Resources;
import tr.view.projects.actions.SingleActionsLookup;
import tr.view.projects.actions.SingleActionsTopComponent;
import tr.view.projects.future.FutureTopComponent;
import tr.view.projects.templates.TemplatesTopComponent;

public class ProjectsAction
extends AbstractAction
implements InitialAction {
    private static final Logger LOG = Logger.getLogger("tr.archive");

    public ProjectsAction() {
        super(NbBundle.getMessage(ProjectsAction.class, (String)"CTL_ProjectsAction"));
        this.putValue("SmallIcon", Resources.ICON_PROJECTS);
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ProjectsAction.this.enableDisable();
            }
        });
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public void actionPerformed(ActionEvent evt) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        WindowUtils.closeWindows();
        ProjectsTreeTopComponent tcProjects = ProjectsTreeTopComponent.findInstance();
        ProjectsTreeLookup.register(tcProjects);
        SingleActionsTopComponent tcSingleActions = SingleActionsTopComponent.findInstance();
        SingleActionsLookup.register(tcSingleActions);
        FutureTopComponent tcFuture = FutureTopComponent.findInstance();
        TemplatesTopComponent tcTemplates = TemplatesTopComponent.findInstance();
        EditorTopComponent tcEdit = EditorTopComponent.findInstance();
        Mode mode = WindowManager.getDefault().findMode("projects-tree");
        if (mode == null) {
            LOG.severe("Mode projects-tree was not found.");
        } else {
            mode.dockInto((TopComponent)tcProjects);
            mode.dockInto((TopComponent)tcSingleActions);
            mode.dockInto((TopComponent)tcFuture);
            mode.dockInto((TopComponent)tcTemplates);
        }
        mode = WindowManager.getDefault().findMode("projects-editor");
        if (mode == null) {
            LOG.severe("Mode projects-editor was not found.");
        } else {
            mode.dockInto((TopComponent)tcEdit);
            tcEdit.open();
        }
        tcProjects.open();
        tcSingleActions.open();
        tcFuture.open();
        tcTemplates.open();
        tcEdit.open();
        tcProjects.requestActive();
    }

    public String getID() {
        return "projects";
    }

    public String getName() {
        return (String)this.getValue("Name");
    }
}

