/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.project.Project;
import tr.view.Window;
import tr.view.action.ActionPanel;
import tr.view.project.ProjectPanel;
import tr.view.projects.Resources;

public final class EditorTopComponent
extends Window {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    private static final String PREFERRED_ID = "EditorTopComponent";
    private static EditorTopComponent instance;
    private transient boolean initialised;
    private transient ActionPanel actionPanel;
    private transient ProjectPanel projectPanel;
    private JPanel emptyPanel;
    private JScrollPane scrollPane;

    private EditorTopComponent() {
        this.initComponents();
    }

    private void initialise() {
        if (this.initialised) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            LOG.severe("Data model could not be found.");
            return;
        }
        this.projectPanel = new ProjectPanel(data);
        this.actionPanel = new ActionPanel(data);
        this.initialised = true;
    }

    protected void componentOpened() {
        super.componentOpened();
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data != null) {
            this.view(data.getRootProjects());
        }
    }

    public boolean isViewing(Action action) {
        if (action == null) {
            return false;
        }
        if (this.actionPanel == null) {
            return false;
        }
        if (this.actionPanel != this.scrollPane.getViewport().getView()) {
            return false;
        }
        return action.equals((Object)this.actionPanel.getModel());
    }

    public boolean isViewing(Project project) {
        if (project == null) {
            return false;
        }
        if (this.projectPanel == null) {
            return false;
        }
        if (this.projectPanel != this.scrollPane.getViewport().getView()) {
            return false;
        }
        return project.equals((Object)this.projectPanel.getModel());
    }

    private void initComponents() {
        this.emptyPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.add(this.scrollPane, "Center");
    }

    public static synchronized EditorTopComponent getDefault() {
        if (instance == null) {
            instance = new EditorTopComponent();
        }
        return instance;
    }

    public static synchronized EditorTopComponent findInstance() {
        Object tc = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (tc == null) {
            ErrorManager.getDefault().log(16, "Cannot find edit component. It will not be located properly in the window system.");
            tc = EditorTopComponent.getDefault();
        }
        if (!(tc instanceof EditorTopComponent)) {
            ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'EditorTopComponent' ID. That is a potential source of errors and unexpected behavior.");
            tc = EditorTopComponent.getDefault();
        }
        EditorTopComponent etc = (EditorTopComponent)((Object)tc);
        etc.initialise();
        return etc;
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public void edit(Action action) {
        if (this.actionPanel == null) {
            return;
        }
        this.requestActive();
        this.view(action);
        this.actionPanel.edit();
    }

    public void edit(Project project) {
        if (this.projectPanel == null) {
            return;
        }
        this.requestActive();
        this.view(project);
        this.projectPanel.edit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void view(Project project) {
        assert (project != null);
        if (!this.isOpened()) {
            return;
        }
        if (this.isViewing(project)) {
            return;
        }
        EditorTopComponent editorTopComponent = this;
        synchronized (editorTopComponent) {
            this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ProjectTopComponent"));
            this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TTT_ProjectTopComponent"));
            this.setIcon(Resources.ICON_PROJECT.getImage());
            if (project.isEditable()) {
                this.projectPanel.initModel(project);
                this.scrollPane.setViewportView((Component)this.projectPanel);
            } else {
                this.setName(project.getDescription());
                this.scrollPane.setViewportView(this.emptyPanel);
            }
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void view(Action action) {
        if (!this.isOpened()) {
            return;
        }
        if (this.isViewing(action)) {
            return;
        }
        EditorTopComponent editorTopComponent = this;
        synchronized (editorTopComponent) {
            this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ActionTopComponent"));
            this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TTT_ActionTopComponent"));
            this.setIcon(Resources.ICON_ACTION.getImage());
            if (action != null && action.isEditable()) {
                this.actionPanel.initModel(action);
                this.scrollPane.setViewportView((Component)this.actionPanel);
            } else {
                this.scrollPane.setViewportView(this.emptyPanel);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.projects");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return EditorTopComponent.getDefault();
        }
    }
}

