/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.Color;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.context.Context;
import tr.model.context.ContextChangeCookie;
import tr.model.project.Project;
import tr.model.project.ProjectSingleActions;
import tr.model.project.Sequencing;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.prefs.projects.ProjectsPrefs;
import tr.util.HTML;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.ReprocessAction;
import tr.view.ReprocessCookie;
import tr.view.context.ContextChangeAction;
import tr.view.process.ProcessThoughtsAction;
import tr.view.projects.EditAction;
import tr.view.projects.EditCookie;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectiseAction;
import tr.view.projects.ProjectiseCookie;
import tr.view.projects.SearchableNode;
import tr.view.projects.TransferNode;
import tr.view.topic.TopicChangeAction;

public class ActionNode
extends AbstractNode
implements Observer,
EditCookie,
ProjectiseCookie,
ReprocessCookie,
SearchableNode,
TransferNode {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    public final Action action;
    private int transferType;

    public ActionNode(Action action) {
        super(Children.LEAF, Lookups.singleton((Object)action));
        this.action = action;
        this.action.addObserver((Observer)this);
    }

    public String getName() {
        return this.action.getDescription();
    }

    public void setName(String name) {
        super.setName(name);
    }

    private String escapeHTML(String str) {
        str = StringEscapeUtils.escapeXml((String)str);
        return str.replace("&apos;", "'");
    }

    public String getHtmlDisplayName() {
        String color;
        String name = this.escapeHTML(this.getName());
        String string = color = this.action.isStateInactive() ? HTML.format((Color)Color.GRAY) : HTML.format((Color)this.action.getTopic().getForeground());
        if (this.action.isDone()) {
            return "<s><font color='" + color + "'>" + name + "</font></s>";
        }
        return "<font color='" + color + "'>" + name + "</font>";
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        this.action.removeFromParent();
    }

    public boolean canRename() {
        return false;
    }

    public javax.swing.Action[] getActions(boolean popup) {
        return new javax.swing.Action[]{SystemAction.get(EditAction.class), null, SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(ReprocessAction.class), SystemAction.get(ProjectiseAction.class), null, SystemAction.get(ContextChangeAction.class), SystemAction.get(TopicChangeAction.class)};
    }

    public javax.swing.Action getPreferredAction() {
        return SystemAction.get(EditAction.class);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == EditCookie.class) {
            return this;
        }
        if (clazz == ReprocessCookie.class) {
            return this;
        }
        if (clazz == ProjectiseCookie.class) {
            return this;
        }
        if (clazz == TopicChangeCookie.class) {
            return this.action;
        }
        if (clazz == ContextChangeCookie.class) {
            return this.action;
        }
        return super.getCookie(clazz);
    }

    public Image getIcon(int type) {
        Icon icon = this.action.getIcon(false);
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return super.getIcon(type);
    }

    public void reprocess() {
        if (this.action == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        this.action.removeObserver((Observer)this);
        this.action.removeFromParent();
        Thought thought = new Thought();
        thought.setDescription(this.action.getDescription());
        thought.setTopic(this.action.getTopic());
        thought.setAction(this.action);
        data.getThoughtManager().insert((Observable)thought, 0);
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        ProcessThoughtsAction pta = (ProcessThoughtsAction)SystemAction.get(ProcessThoughtsAction.class);
        pta.performAction();
    }

    public void projectise() {
        if (this.action == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Project parent = (Project)this.action.getParent();
        int index = parent.indexOf((Item)this.action);
        this.action.removeObserver((Observer)this);
        this.action.removeFromParent();
        this.fireNodeDestroyed();
        Project project = new Project((IDGenerator)data);
        project.setThought(this.action.getThought());
        project.setDescription(this.action.getDescription());
        project.setTopic(this.action.getTopic());
        project.setNotes(this.action.getNotes());
        if (parent.isRoot()) {
            if (ProjectsPrefs.isSequencing()) {
                project.setSequencing(true);
                project.setSequenceType(Sequencing.INTO_SUBPROJECTS);
            }
        } else {
            project.setSequencing(parent.isSequencing());
            project.setSequenceType(parent.getSequenceType());
        }
        project.add((Item)this.action);
        if (parent instanceof ProjectSingleActions) {
            data.getRootProjects().add((Item)project);
        } else {
            parent.add(index, (Item)project);
        }
    }

    public void update(Observable observable, Object arguement) {
        this.setName(this.action.getDescription());
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Node find(Object o) {
        return this.action.equals(o) ? this : null;
    }

    public Transferable clipboardCut() throws IOException {
        this.setTransferType(2);
        return super.clipboardCut();
    }

    public Transferable clipboardCopy() throws IOException {
        this.setTransferType(1);
        return super.clipboardCopy();
    }

    public void setTransferType(int type) {
        this.transferType = type;
    }

    public boolean isMoveTransfer() {
        return (this.transferType & 2) != 0;
    }

    public boolean isCopyTransfer() {
        return (this.transferType & 1) != 0;
    }

    public void edit() {
        EditorTopComponent.findInstance().edit(this.action);
    }

    public void changeTopic(Topic topic) {
        this.action.setTopic(topic);
    }

    public void changeContext(Context context) {
        this.action.setContext(context);
    }
}

