/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.Line;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

final class EditorSupportLineSet
extends DocumentLine.Set {
    private CloneableEditorSupport support;

    public EditorSupportLineSet(CloneableEditorSupport cloneableEditorSupport, StyledDocument styledDocument) {
        super(styledDocument, cloneableEditorSupport);
        this.support = cloneableEditorSupport;
    }

    WeakHashMap findWeakHashMap() {
        return this.support.findWeakHashMap();
    }

    public Line createLine(int n) {
        PositionRef positionRef = new PositionRef(this.support.getPositionManager(), n, Position.Bias.Forward);
        return new SupportLine(this.support.getLookup(), positionRef, this.support);
    }

    static class Closed
    extends Line.Set
    implements ChangeListener {
        private CloneableEditorSupport support;
        private Line.Set delegate;

        public Closed(CloneableEditorSupport cloneableEditorSupport) {
            this.support = cloneableEditorSupport;
            cloneableEditorSupport.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)((Object)cloneableEditorSupport)));
        }

        WeakHashMap findWeakHashMap() {
            return this.support.findWeakHashMap();
        }

        public List getLines() {
            if (this.delegate != null) {
                return this.delegate.getLines();
            }
            return new ArrayList();
        }

        public Line getOriginal(int n) throws IndexOutOfBoundsException {
            if (this.delegate != null) {
                return this.delegate.getOriginal(n);
            }
            return this.getCurrent(n);
        }

        public Line getCurrent(int n) throws IndexOutOfBoundsException {
            PositionRef positionRef = new PositionRef(this.support.getPositionManager(), n, 0, Position.Bias.Forward);
            Lookup lookup = this.support.getLookup();
            return this.registerLine(new SupportLine(lookup, positionRef, this.support));
        }

        public synchronized void stateChanged(ChangeEvent changeEvent) {
            if (this.delegate == null) {
                StyledDocument styledDocument = this.support.getDocument();
                if (styledDocument != null) {
                    this.delegate = new EditorSupportLineSet(this.support, styledDocument);
                }
            } else if (this.support.getDocument() == null) {
                this.delegate = null;
            }
        }
    }

    private static final class SupportLine
    extends DocumentLine {
        static final long serialVersionUID = 7282223299866986051L;

        public SupportLine(Lookup lookup, PositionRef positionRef, CloneableEditorSupport cloneableEditorSupport) {
            super(lookup, positionRef);
        }

        public void show(int n, int n2) {
            CloneableEditorSupport cloneableEditorSupport = this.pos.getCloneableEditorSupport();
            if (n == 0 && !cloneableEditorSupport.isDocumentLoaded()) {
                return;
            }
            CloneableEditorSupport.Pane pane = cloneableEditorSupport.openAt(this.pos, n2);
            if (n == 2) {
                pane.getComponent().requestActive();
            } else if (n == 3) {
                pane.getComponent().toFront();
                pane.getComponent().requestActive();
            }
        }

        public Line.Part createPart(int n, int n2) {
            DocumentLine.Part part = new DocumentLine.Part(this, new PositionRef(this.pos.getCloneableEditorSupport().getPositionManager(), this.pos.getOffset() + n, Position.Bias.Forward), n2);
            this.addLinePart(part);
            return part;
        }

        public String getDisplayName() {
            CloneableEditorSupport cloneableEditorSupport = this.pos.getCloneableEditorSupport();
            return cloneableEditorSupport.messageLine(this);
        }

        public String toString() {
            return "SupportLine@" + Integer.toHexString(System.identityHashCode(this)) + " at line: " + this.getLineNumber();
        }
    }
}

