/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import tr.util.DateButton;
import tr.view.actions.screens.fields.ActionsFilterComboBox;
import tr.view.actions.screens.fields.DateItem;
import tr.view.actions.screens.fields.DateType;

public class DateCombo
extends ActionsFilterComboBox
implements ActionListener {
    private final boolean calculate;
    private final DateItem chosen;

    public DateCombo(DateItem[] items, boolean calculate) {
        super((ComboBoxModel)new DefaultComboBoxModel<DateItem>(items));
        this.calculate = calculate;
        this.chosen = new DateItem(DateType.NONE, "", 0L);
        this.insertItemAt(this.chosen, 0);
        this.setMaximumRowCount(items.length + 1);
        this.setSelectedItem(null);
        this.addActionListener(this);
    }

    protected void stopChangeEvents() {
        this.removeActionListener(this);
    }

    protected void startChangeEvents() {
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        DateItem item = (DateItem)this.getSelectedItem();
        if (item != null) {
            if (item == DateItem.DATE_CHOOSER) {
                DateButton db = new DateButton();
                db.component = this;
                if (this.chosen.type == DateType.DAYS) {
                    Calendar c = Calendar.getInstance();
                    c.add(6, (int)this.chosen.value);
                    db.setDate(c.getTime());
                } else if (this.chosen.type == DateType.MS) {
                    db.setDate(new Date(this.chosen.value));
                }
                db.doClick();
                Date date = db.getDate();
                if (date == null) {
                    this.chosen.type = DateType.NONE;
                    this.chosen.label = "";
                    this.chosen.value = 0L;
                } else {
                    this.chosen.type = DateType.MS;
                    this.chosen.label = db.getText();
                    this.chosen.value = date.getTime();
                }
            } else if (this.calculate) {
                if (item.type == DateType.DAYS) {
                    this.chosen.type = DateType.MS;
                    Calendar c = Calendar.getInstance();
                    c.add(6, (int)item.value);
                    this.chosen.label = DateButton.DATE_FORMAT.format(c.getTime());
                    this.chosen.value = c.getTimeInMillis();
                } else if (item.type == DateType.MS) {
                    this.chosen.type = DateType.MS;
                    this.chosen.value = item.value;
                    this.chosen.label = DateButton.DATE_FORMAT.format(new Date(item.value));
                }
            } else {
                this.chosen.type = item.type;
                this.chosen.label = item.label;
                this.chosen.value = item.value;
            }
            this.setSelectedIndex(0);
            this.firePropertyChange("filter-value", null, null);
        }
    }

    public DateItem getDateItem(DateType type, long value) {
        if (type == DateType.MS) {
            this.chosen.type = type;
            this.chosen.value = value;
            this.chosen.label = DateButton.DATE_FORMAT.format(new Date(value));
            return this.chosen;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            DateItem item = (DateItem)this.getItemAt(i);
            if (item.type != type || item.value != value) continue;
            return item;
        }
        return null;
    }

    public static Date getDate(DateItem item) {
        if (item == null) {
            return null;
        }
        if (item.type == DateType.DAYS) {
            Calendar c = Calendar.getInstance();
            c.add(6, (int)item.value);
            return c.getTime();
        }
        if (item.type == DateType.MS) {
            return new Date(item.value);
        }
        return null;
    }

    public void setSelectedItem(Object object) {
        if (object == null) {
            this.chosen.type = DateType.NONE;
            this.chosen.label = "";
            this.chosen.value = 0L;
        }
        super.setSelectedItem(object);
    }
}

