/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import org.openide.util.NbBundle;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.actions.screens.fields.ActionsField;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsFilterDone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsScreen
extends ObservableImpl
implements Observable,
Observer {
    private String key;
    private Manager<ActionsField> fields;
    private byte[] fieldOrder;
    private byte[] sortFields;
    private byte[] sortStatus;
    private Manager<ActionsFilter> filters;

    private ActionsScreen(String key) {
        this.key = key;
    }

    public static ActionsScreen create(String key) {
        ActionsScreen screen = new ActionsScreen(key);
        for (int i = 0; i < ActionsField.TYPES.length; ++i) {
            screen.getFields().add((Observable)ActionsField.createField(ActionsField.TYPES[i]));
        }
        for (int j = 0; j < ActionsFilter.IDS.length; ++j) {
            screen.getFilters().add((Observable)ActionsFilter.createFilter(ActionsFilter.IDS[j]));
        }
        return screen;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        String string = key = key == null ? "" : key;
        if (!Utils.equal((Object)this.key, (Object)key)) {
            this.key = key;
            this.notifyObservers(this);
        }
    }

    public String toString() {
        try {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.key);
        }
        catch (Exception ex) {
            return this.key;
        }
    }

    public Manager<ActionsField> getFields() {
        if (this.fields == null) {
            this.fields = new Manager();
            this.fields.addObserver((Observer)this);
        }
        return this.fields;
    }

    public byte[] getFieldOrder() {
        if (this.fieldOrder == null) {
            this.fieldOrder = new byte[0];
        }
        return this.fieldOrder;
    }

    public void setFieldOrder(byte[] order) {
        this.fieldOrder = order;
        this.notifyObservers(this);
    }

    public byte[] getSortFields() {
        if (this.sortFields == null) {
            this.sortFields = new byte[0];
        }
        return this.sortFields;
    }

    public void setSortFields(byte[] fields) {
        this.sortFields = fields;
        this.notifyObservers(this);
    }

    public byte[] getSortStatus() {
        if (this.sortStatus == null) {
            this.sortStatus = new byte[0];
        }
        return this.sortStatus;
    }

    public void setSortStatus(byte[] status) {
        this.sortStatus = status;
        this.notifyObservers(this);
    }

    public Manager<ActionsFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new Manager();
            this.filters.addObserver((Observer)this);
        }
        return this.filters;
    }

    public boolean isShowAll() {
        for (ActionsFilter filter : this.getFilters().list()) {
            if (!(filter instanceof ActionsFilterDone)) continue;
            return ((ActionsFilterDone)filter).acceptAll();
        }
        return true;
    }

    public boolean isShowDone() {
        for (ActionsFilter filter : this.getFilters().list()) {
            if (!(filter instanceof ActionsFilterDone)) continue;
            return ((ActionsFilterDone)filter).acceptDone();
        }
        return true;
    }

    public boolean isShowToDo() {
        for (ActionsFilter filter : this.getFilters().list()) {
            if (!(filter instanceof ActionsFilterDone)) continue;
            return ((ActionsFilterDone)filter).acceptToDo();
        }
        return true;
    }

    public void resetObservers() {
        if (this.fields != null) {
            this.fields.resetObservers();
            this.fields.addObserver((Observer)this);
        }
        if (this.filters != null) {
            this.filters.resetObservers();
            this.filters.addObserver((Observer)this);
        }
    }

    public void update(Observable observable, Object object) {
        this.notifyObservers(observable, object);
    }
}

