/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsFilterComboBox;
import tr.view.actions.screens.fields.MultiChoiceDialog;

public class ActionsFilterTopic
extends ActionsFilter {
    public static final byte ID = 6;
    public static final String KEY = "filter-topic";
    public static final String ALL = "all";
    public static final String MULTIPLE = "multiple";
    private transient TopicsComboBox combo;

    protected ActionsFilterTopic() {
        super((byte)6);
    }

    public String toString() {
        return this.getText(KEY);
    }

    public void setUsed(boolean used) {
        if (!used && this.combo != null) {
            this.combo.setSelectedItem(null);
        }
        super.setUsed(used);
    }

    public synchronized JComboBox getComboBox() {
        if (this.combo == null) {
            this.combo = new TopicsComboBox(new TopicsComboBoxModel());
            this.combo.setBackground(Color.white);
        }
        return this.combo;
    }

    public TableCellRenderer getValuesRenderer() {
        return (TableCellRenderer)((Object)this.getComboBox());
    }

    public TableCellEditor getValuesEditor() {
        return new DefaultCellEditor(this.getComboBox());
    }

    public boolean accept(Action action) {
        Topic topic = (Topic)this.getComboBox().getSelectedItem();
        if (topic == null || topic.key != null && topic.key.equals(ALL)) {
            return true;
        }
        if (topic.key != null && topic.key.equals(MULTIPLE)) {
            return this.combo.chosen.contains(action.getTopic());
        }
        return topic.equals((Object)action.getTopic());
    }

    public boolean acceptAll() {
        Topic topic = (Topic)this.getComboBox().getSelectedItem();
        return topic == null || topic.key != null && topic.key.equals(ALL);
    }

    public String[] getSerialValues() {
        Topic topic = (Topic)this.getComboBox().getSelectedItem();
        if (topic == null) {
            return null;
        }
        if (topic.key != null && topic.key.equals(ALL)) {
            return new String[]{ALL};
        }
        if (topic.key != null && topic.key.equals(MULTIPLE)) {
            if (this.combo == null || this.combo.chosen == null) {
                return null;
            }
            String[] values = new String[this.combo.chosen.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.combo.chosen.get(i).getName();
            }
            return values;
        }
        return new String[]{topic.getName()};
    }

    public void setSerialValues(String[] values) {
        this.getComboBox();
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.combo.setSelectedItem(null);
        } else if (values.length == 1) {
            if (values[0].equals(ALL)) {
                this.combo.setSelectedIndex(0);
            } else {
                this.combo.setSelectedItem(this.getTopic(values[0]));
            }
        } else if (values.length > 1) {
            this.combo.setSelectedIndex(1);
            this.combo.chosen = new Vector();
            for (String name : values) {
                this.combo.chosen.add(this.getTopic(name));
            }
        }
        this.combo.startChangeEvents();
    }

    private Topic getTopic(String name) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        Manager manager = data.getTopicManager();
        for (Topic topic : manager.list()) {
            if (!topic.getName().equals(name)) continue;
            return topic;
        }
        return null;
    }

    public class TopicsComboBox
    extends ActionsFilterComboBox
    implements TableCellRenderer {
        private ActionListener listener;
        public Vector<Topic> chosen;

        public TopicsComboBox(TopicsComboBoxModel model) {
            super((ComboBoxModel)model);
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Topic t = (Topic)TopicsComboBox.this.getSelectedItem();
                    if (t != null && t.key != null && t.key.equals(ActionsFilterTopic.MULTIPLE)) {
                        Data data = (Data)DataLookup.instance().lookup(Data.class);
                        Vector all = data == null ? new Vector() : data.getTopicManager().list();
                        if (TopicsComboBox.this.chosen == null) {
                            TopicsComboBox.this.chosen = new Vector();
                        }
                        MultiChoiceDialog<Topic> d = new MultiChoiceDialog<Topic>(TopicsComboBox.this, all, TopicsComboBox.this.chosen);
                        d.setTitle(ActionsFilterTopic.this.getText(ActionsFilterTopic.KEY));
                        d.setLocationRelativeTo(TopicsComboBox.this);
                        d.setVisible(true);
                        if (d.isOkay()) {
                            TopicsComboBox.this.chosen = d.getChosen();
                        }
                    }
                    TopicsComboBox.this.firePropertyChange("filter-value", null, null);
                }
            };
            this.setPreferredSize(new Dimension(120, 24));
            this.addActionListener(this.listener);
        }

        protected void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        protected void startChangeEvents() {
            this.addActionListener(this.listener);
        }
    }

    public class TopicsComboBoxModel
    extends DefaultComboBoxModel
    implements Observer {
        private final Topic allTopic = new Topic();
        private final Topic multipleTopic;
        private Manager<Topic> topicManager;
        private List<Topic> topics;
        private Lookup.Result result;

        public TopicsComboBoxModel() {
            this.allTopic.setName(ActionsFilterTopic.this.getText("filter-all"));
            this.allTopic.key = ActionsFilterTopic.ALL;
            this.multipleTopic = new Topic();
            this.multipleTopic.setName(ActionsFilterTopic.this.getText("filter-multiple"));
            this.multipleTopic.key = ActionsFilterTopic.MULTIPLE;
            this.initialise();
        }

        private void initialise() {
            Data data;
            if (this.topicManager != null) {
                this.topicManager.removeObserver((Observer)this);
            }
            if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
                this.topicManager = null;
                this.topics = new Vector<Topic>();
            } else {
                this.topicManager = data.getTopicManager();
                this.topicManager.addObserver((Observer)this);
                this.topics = this.topicManager.list();
                Collections.sort(this.topics);
            }
            this.topics.add(0, this.allTopic);
            this.topics.add(1, this.multipleTopic);
            if (this.result == null) {
                this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        TopicsComboBoxModel.this.update(null, null);
                    }
                });
            }
        }

        public Object getElementAt(int index) {
            return this.topics.get(index);
        }

        public int getSize() {
            return this.topics.size();
        }

        public void update(Observable o, Object arg) {
            this.initialise();
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

