/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateDelegated;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsFilterComboBox;

public class ActionsFilterSearch
extends ActionsFilter {
    public static final byte ID = 13;
    public static final String KEY = "filter-search";
    protected SearchComboBox combo;

    protected ActionsFilterSearch() {
        super((byte)13);
    }

    public String toString() {
        return this.getText(KEY);
    }

    public void setUsed(boolean used) {
        if (!used && this.combo != null) {
            this.combo.setSelectedItem(null);
        }
        super.setUsed(used);
    }

    public Object getValueAt() {
        return "";
    }

    public synchronized JComboBox getComboBox() {
        if (this.combo == null) {
            this.combo = new SearchComboBox(new SearchComboBoxModel());
            this.combo.setBackground(Color.white);
        }
        return this.combo;
    }

    public TableCellRenderer getValuesRenderer() {
        return (TableCellRenderer)((Object)this.getComboBox());
    }

    public TableCellEditor getValuesEditor() {
        this.getComboBox().setBackground(Color.white);
        return new DefaultCellEditor(this.getComboBox());
    }

    public boolean accept(Action action) {
        return this.contains(action, this.combo.string);
    }

    private boolean contains(Action action, String string) {
        ActionStateDelegated stateDelegated;
        if (action.getDescription().toLowerCase().contains(string)) {
            return true;
        }
        if (action.getNotes().toLowerCase().contains(string)) {
            return true;
        }
        ActionState state = action.getState();
        return state instanceof ActionStateDelegated && (stateDelegated = (ActionStateDelegated)state).getTo().toLowerCase().contains(string);
    }

    public boolean acceptAll() {
        return this.combo.string == null;
    }

    public String[] getSerialValues() {
        if (this.combo == null || this.combo.string == null) {
            return null;
        }
        return new String[]{this.combo.string};
    }

    public void setSerialValues(String[] values) {
        this.getComboBox();
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.getComboBox().setSelectedItem(null);
        } else {
            this.combo.setSelectedItem(values[0]);
        }
        this.combo.startChangeEvents();
    }

    public class SearchComboBox
    extends ActionsFilterComboBox
    implements TableCellRenderer {
        private ActionListener listener;
        public String string;

        public SearchComboBox(SearchComboBoxModel model) {
            super((ComboBoxModel)model);
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String string;
                    SearchComboBox.this.setString(null);
                    Object object = ActionsFilterSearch.this.getComboBox().getSelectedItem();
                    if (object instanceof String && (string = ((String)object).trim()).length() > 0) {
                        SearchComboBox.this.setString(string);
                    }
                }
            };
            this.setEditable(true);
            this.addActionListener(this.listener);
        }

        protected void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        protected void startChangeEvents() {
            this.addActionListener(this.listener);
        }

        private void setString(String string) {
            if (string == null || string.trim().length() == 0) {
                this.string = null;
            } else {
                this.string = string.trim().toLowerCase();
                SearchComboBoxModel model = (SearchComboBoxModel)ActionsFilterSearch.this.combo.getModel();
                model.addSearch(string);
            }
            this.firePropertyChange("filter-value", null, null);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComboBox dummy = new JComboBox();
            dummy.setEnabled(true);
            dummy.setBackground(Color.white);
            return dummy;
        }
    }

    public class SearchComboBoxModel
    extends DefaultComboBoxModel {
        public final Vector<String> searches = new Vector();

        public void addSearch(String search) {
            if (search == null) {
                return;
            }
            if ((search = search.trim()).length() > 0 && !this.searches.contains(search)) {
                this.searches.add(search);
                this.fireContentsChanged(search, 0, this.searches.size());
            }
        }

        public Object getElementAt(int index) {
            return this.searches.get(index);
        }

        public int getSize() {
            return this.searches.size();
        }
    }
}

