/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tr.model.action.Action;
import tr.util.DateUtils;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.DateCombo;
import tr.view.actions.screens.fields.DateItem;
import tr.view.actions.screens.fields.DateType;

public class ActionsFilterCreatedTo
extends ActionsFilter {
    public static final byte ID = 10;
    public static final String KEY = "filter-created-to";
    private DateItem[] dateItems = new DateItem[]{DateItem.DATE_CHOOSER, DateItem.TODAY, DateItem.YESTERDAY, DateItem.WEEKS_AGO_1, DateItem.WEEKS_AGO_2, DateItem.WEEKS_AGO_3, DateItem.WEEKS_AGO_4};
    private DateCombo combo;

    protected ActionsFilterCreatedTo() {
        super((byte)10);
    }

    public String toString() {
        return this.getText(KEY);
    }

    public void setUsed(boolean used) {
        if (!used && this.combo != null) {
            this.combo.setSelectedItem(null);
        }
        super.setUsed(used);
    }

    public JComboBox getComboBox() {
        if (this.combo == null) {
            this.combo = new DateCombo(this.dateItems, false);
            this.combo.setBackground(Color.white);
            this.combo.addPropertyChangeListener("filter-value", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ActionsFilterCreatedTo.this.notifyObservers(null);
                }
            });
        }
        return this.combo;
    }

    public TableCellRenderer getValuesRenderer() {
        return (TableCellRenderer)((Object)this.getComboBox());
    }

    public TableCellEditor getValuesEditor() {
        return new DefaultCellEditor(this.getComboBox());
    }

    public boolean accept(Action action) {
        if (this.combo == null) {
            return true;
        }
        DateItem item = (DateItem)this.getComboBox().getSelectedItem();
        Date date = DateCombo.getDate(item);
        return date == null || !action.getCreated().after(DateUtils.getEnd((Date)date));
    }

    public String[] getSerialValues() {
        if (this.combo == null) {
            return null;
        }
        DateItem item = (DateItem)this.combo.getSelectedItem();
        if (item == null || item.type == DateType.NONE) {
            return null;
        }
        return new String[]{String.valueOf(item.value)};
    }

    public void setSerialValues(String[] values) {
        this.getComboBox();
        this.combo.stopChangeEvents();
        if (values == null || values.length != 1) {
            this.getComboBox().setSelectedItem(null);
        } else {
            try {
                long value = Long.parseLong(values[0]);
                if (value < 1000L) {
                    this.combo.setSelectedItem(this.combo.getDateItem(DateType.DAYS, value));
                } else {
                    this.combo.setSelectedItem(this.combo.getDateItem(DateType.MS, value));
                }
            }
            catch (Exception ex) {
                this.getComboBox().setSelectedItem(null);
            }
        }
        this.combo.startChangeEvents();
    }

    public boolean acceptAll() {
        DateItem item = (DateItem)this.getComboBox().getSelectedItem();
        return item == null;
    }
}

