/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import javax.swing.Icon;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import tr.swing.StyledDate;
import tr.swing.StyledString;
import tr.swing.StyledStringRenderer;
import tr.util.Observable;
import tr.util.ObservableImpl;

public class ActionsField
extends ObservableImpl {
    public static final byte ICON = 0;
    public static final byte DONE = 1;
    public static final byte DESCR = 2;
    public static final byte DELEGATED_TO = 3;
    public static final byte CREATED_DATE = 4;
    public static final byte DONE_DATE = 5;
    public static final byte ACTION_DATE = 6;
    public static final byte CONTEXT = 7;
    public static final byte TIME = 8;
    public static final byte ENERGY = 9;
    public static final byte PRIORITY = 10;
    public static final byte TOPIC = 11;
    public static final byte FROM_ICON = 12;
    public static final byte FROM_DESCR = 13;
    public static final byte FROM_TOPIC = 14;
    public static final byte START_DATE = 15;
    public static final byte DUE_DATE = 16;
    public static final byte[] TYPES = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final String[] FIELD_NAME_KEYS = new String[]{"icon", "done", "descr", "delegated-to", "created-date", "done-date", "action-date", "context", "time", "energy", "priority", "topic", "from-icon", "from-descr", "from-topic", "start-date", "due-date"};
    private static final String[] COLUMN_NAME_KEYS = new String[]{"", "done", "descr", "delegated-to", "created-date", "done-date", "action-date", "context", "time", "energy", "priority", "topic", "", "from-descr", "from-topic", "start-date", "due-date"};
    private static final Class[] CLASSES = new Class[]{Icon.class, Boolean.class, StyledString.class, StyledString.class, StyledDate.class, StyledDate.class, StyledDate.class, StyledString.class, StyledString.class, StyledString.class, StyledString.class, StyledString.class, Icon.class, StyledString.class, StyledString.class, StyledDate.class, StyledDate.class};
    private static final int[] PRE_WIDTHS = new int[]{17, 17, -1, -1, 164, 164, 164, -1, -1, -1, -1, -1, 17, -1, -1, 164, 164};
    private static final int[] MIN_WIDTHS = new int[]{17, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, -1, -1, -1};
    private static final int[] MAX_WIDTHS = new int[]{17, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, -1, -1, -1};
    private final byte type;
    private boolean visible;
    private int width;

    public static ActionsField createField(byte type) {
        return new ActionsField(type);
    }

    public static ActionsField createField(byte type, boolean visible, int width) {
        return new ActionsField(type, visible, width);
    }

    private ActionsField(byte type) {
        this(type, true, PRE_WIDTHS[type]);
    }

    private ActionsField(byte type, boolean visible, int width) {
        this.type = type;
        this.visible = visible;
        this.width = width;
    }

    public final byte getType() {
        return this.type;
    }

    public String toString() {
        return this.getFieldName();
    }

    public String getFieldName() {
        try {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)FIELD_NAME_KEYS[this.type]);
        }
        catch (Exception ex) {
            return FIELD_NAME_KEYS[this.type];
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.notifyObservers((Observable)this);
        }
    }

    public Class getColumnClass() {
        return CLASSES[this.type];
    }

    public String getColumnName() {
        try {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)COLUMN_NAME_KEYS[this.type]);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public int getMaximumWidth() {
        return MAX_WIDTHS[this.type];
    }

    public int getMinimumWidth() {
        return MIN_WIDTHS[this.type];
    }

    public int getPreferredWidth() {
        return PRE_WIDTHS[this.type];
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.notifyObservers((Observable)this);
        }
    }

    public TableCellRenderer getRenderer() {
        if (CLASSES[this.type] == StyledString.class || CLASSES[this.type] == StyledDate.class) {
            return new StyledStringRenderer();
        }
        return null;
    }
}

