/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.SortOrder;
import org.openide.util.NbBundle;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.util.Manager;
import tr.view.actions.RAProjectsTreeTopComponent;
import tr.view.actions.RASingleActionsTopComponent;
import tr.view.actions.Resources;
import tr.view.actions.screens.ColumnsDialog;
import tr.view.actions.screens.FiltersActionSelector;
import tr.view.actions.screens.FiltersDialog;
import tr.view.actions.screens.ItemCountShower;
import tr.view.actions.screens.ReviewActionsTableModel;
import tr.view.actions.screens.fields.ActionsField;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsScreen;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectsTreeTopComponent;
import tr.view.projects.actions.SingleActionsTopComponent;

public class ReviewActionsPanel
extends JPanel {
    private static SingleActionsTopComponent tcSingleActions;
    private static ProjectsTreeTopComponent tcProjectsTree;
    private static EditorTopComponent tcEditor;
    private boolean isEditing;
    private Action editingAction;
    private JButton columnsButton;
    private JButton filtersButton;
    private JPanel northPanel;
    private JTable table;
    private JScrollPane tableScrollPane;
    private static final Logger LOG;
    private static final String HIDDEN_COLUMN = "HiddenColumn:";
    private final ActionsScreen screen;
    private final Data data;
    private final ItemCountShower itemCountShower;
    private ReviewActionsTableModel tableModel;
    private FiltersActionSelector selector;

    public ReviewActionsPanel(ActionsScreen screen, ItemCountShower itemCountShower) {
        this.screen = screen;
        this.itemCountShower = itemCountShower;
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        tcSingleActions = RASingleActionsTopComponent.findInstance();
        tcProjectsTree = RAProjectsTreeTopComponent.findInstance();
        tcEditor = EditorTopComponent.findInstance();
        this.initComponents();
        this.showFilters();
    }

    public void addNotify() {
        super.addNotify();
        this.getTableModel().addListeners();
    }

    public void removeNotify() {
        this.getTableModel().removeListeners();
        super.removeNotify();
    }

    private void initComponents() {
        this.northPanel = new JPanel();
        this.columnsButton = new JButton();
        this.filtersButton = new JButton();
        this.tableScrollPane = new JScrollPane();
        this.table = this.getTable();
        this.setLayout(new BorderLayout());
        this.northPanel.setLayout(new FlowLayout(0, 3, 1));
        this.northPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.northPanel.setMinimumSize(new Dimension(48, 25));
        this.northPanel.setPreferredSize(new Dimension(10, 25));
        this.columnsButton.setIcon(this.getColumnsIcon());
        this.columnsButton.setToolTipText(NbBundle.getMessage(ReviewActionsPanel.class, (String)"ColumnsButtonToolTip"));
        this.columnsButton.setIconTextGap(0);
        this.columnsButton.setMargin(new Insets(0, 0, 0, 0));
        this.columnsButton.setMaximumSize(new Dimension(21, 21));
        this.columnsButton.setMinimumSize(new Dimension(21, 21));
        this.columnsButton.setPreferredSize(new Dimension(21, 21));
        this.columnsButton.putClientProperty("JButton.buttonType", "toolbar");
        this.columnsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReviewActionsPanel.this.columnsButtonActionPerformed(evt);
            }
        });
        this.northPanel.add(this.columnsButton);
        this.filtersButton.setIcon(this.getFiltersIcon());
        this.filtersButton.setToolTipText(NbBundle.getMessage(ReviewActionsPanel.class, (String)"FiltersButtonToolTip"));
        this.filtersButton.setIconTextGap(0);
        this.filtersButton.setMargin(new Insets(0, 0, 0, 0));
        this.filtersButton.setMaximumSize(new Dimension(21, 21));
        this.filtersButton.setMinimumSize(new Dimension(21, 21));
        this.filtersButton.setPreferredSize(new Dimension(21, 21));
        this.columnsButton.putClientProperty("JButton.buttonType", "toolbar");
        this.filtersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReviewActionsPanel.this.filtersButtonActionPerformed(evt);
            }
        });
        this.northPanel.add(this.filtersButton);
        this.add((Component)this.northPanel, "First");
        this.tableScrollPane.setViewportView(this.table);
        this.add((Component)this.tableScrollPane, "Center");
    }

    private void filtersButtonActionPerformed(ActionEvent evt) {
        final Component component = (Component)evt.getSource();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FiltersDialog dialog = new FiltersDialog(ReviewActionsPanel.this.screen);
                dialog.setLocationRelativeTo(component);
                dialog.setVisible(true);
                ReviewActionsPanel.this.showFilters();
            }
        });
    }

    private void showFilters() {
        Manager<ActionsFilter> filters = this.screen.getFilters();
        if (filters == null || filters.size() == 0) {
            return;
        }
        this.northPanel.removeAll();
        this.northPanel.add(this.columnsButton);
        this.northPanel.add(this.filtersButton);
        this.northPanel.add(new JLabel(" "));
        for (ActionsFilter filter : filters.list()) {
            if (!filter.isUsed() || !filter.isVisible()) continue;
            this.northPanel.add(new JLabel(filter.toString()));
            JComboBox cb = filter.getComboBox();
            cb.addPropertyChangeListener("filter-value", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (ReviewActionsPanel.this.tableModel != null) {
                        ReviewActionsPanel.this.tableModel.initRowData();
                    }
                }
            });
            cb.setBackground(this.northPanel.getBackground());
            this.northPanel.add(cb);
        }
        this.tableModel.initRowData();
        this.revalidate();
        this.repaint();
    }

    private void columnsButtonActionPerformed(ActionEvent evt) {
        final Component component = (Component)evt.getSource();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ColumnsDialog dialog = new ColumnsDialog(ReviewActionsPanel.this.screen);
                dialog.setLocationRelativeTo(component);
                dialog.setVisible(true);
                ReviewActionsPanel.this.showColumns();
            }
        });
    }

    private JTable getTable() {
        this.table = new JXTable((TableModel)this.getTableModel());
        JTableHeader tableHeader = this.table.getTableHeader();
        TableCellRenderer tcr = tableHeader.getDefaultRenderer();
        if (tcr instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tcr).setHorizontalAlignment(2);
        }
        for (int col = 0; col < this.tableModel.getColumnCount(); ++col) {
            Object value = this.tableModel.getHeaderValue(col);
            if (value == null) continue;
            TableCellRenderer renderer = this.tableModel.getHeaderRenderer(col);
            tableHeader.getColumnModel().getColumn(col).setHeaderRenderer(renderer);
            tableHeader.getColumnModel().getColumn(col).setHeaderValue(value);
        }
        this.table.setShowGrid(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = ReviewActionsPanel.this.table.getSelectedRow();
                if (row == -1) {
                    return;
                }
                ReviewActionsPanel.this.viewRow();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    ReviewActionsPanel.this.editRow();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    e.consume();
                    ReviewActionsPanel.this.editRow();
                }
            }
        });
        this.initColumns();
        this.showColumns();
        this.orderColumns();
        this.sortColumns();
        return this.table;
    }

    private void editRow() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int row = ReviewActionsPanel.this.table.getSelectedRow();
                if (row > -1 && row < ReviewActionsPanel.this.table.getRowCount()) {
                    JXTable jxtable = (JXTable)ReviewActionsPanel.this.table;
                    int modelRow = jxtable.convertRowIndexToModel(row);
                    ReviewActionsPanel.this.editingAction = ((ReviewActionsPanel)ReviewActionsPanel.this).getTableModel().getRowDataAt((int)modelRow).action;
                    if (ReviewActionsPanel.this.editingAction.isSingleAction()) {
                        if (tcSingleActions != null) {
                            tcSingleActions.setShowDone(ReviewActionsPanel.this.tableModel.isShowDone());
                            tcSingleActions.select(ReviewActionsPanel.this.editingAction);
                            tcEditor.edit(ReviewActionsPanel.this.editingAction);
                        }
                    } else if (tcProjectsTree != null) {
                        tcProjectsTree.setShowDone(ReviewActionsPanel.this.tableModel.isShowDone());
                        tcProjectsTree.select(ReviewActionsPanel.this.editingAction);
                        tcEditor.edit(ReviewActionsPanel.this.editingAction);
                    }
                }
            }
        });
    }

    public void viewRow() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int row = ReviewActionsPanel.this.table.getSelectedRow();
                if (row < 0 || row >= ReviewActionsPanel.this.table.getRowCount()) {
                    tcProjectsTree.setShowDone(ReviewActionsPanel.this.tableModel.isShowDone());
                    tcProjectsTree.clearSelection();
                    tcSingleActions.setShowDone(ReviewActionsPanel.this.tableModel.isShowDone());
                    tcSingleActions.clearSelection();
                    tcEditor.view((Action)null);
                } else {
                    JXTable jxtable = (JXTable)ReviewActionsPanel.this.table;
                    int modelRow = jxtable.convertRowIndexToModel(row);
                    Action viewAction = ((ReviewActionsPanel)ReviewActionsPanel.this).getTableModel().getRowDataAt((int)modelRow).action;
                    if (viewAction.isSingleAction()) {
                        if (tcSingleActions != null) {
                            tcSingleActions.setShowDone(ReviewActionsPanel.this.tableModel.isShowDone());
                            tcSingleActions.select(viewAction);
                            tcEditor.view(viewAction);
                        }
                    } else if (tcProjectsTree != null) {
                        tcProjectsTree.setShowDone(ReviewActionsPanel.this.tableModel.isShowDone());
                        tcProjectsTree.select(viewAction);
                        tcEditor.view(viewAction);
                    }
                }
            }
        });
    }

    private void initColumns() {
        ReviewActionsTableModel tm = this.getTableModel();
        TableColumnModel tcm = this.table.getColumnModel();
        for (int column = 0; column < tm.getColumnCount(); ++column) {
            if (column >= tcm.getColumnCount()) {
                tcm.addColumn(new TableColumn());
            }
            TableColumn tc = tcm.getColumn(column);
            ActionsField field = (ActionsField)this.screen.getFields().get(column);
            tc.setIdentifier(new Byte(field.getType()));
            if (tm.getTableCellRenderer(column) != null) {
                tc.setCellRenderer(tm.getTableCellRenderer(column));
            }
            if (tm.getMaximumWidth(column) > -1) {
                tc.setMaxWidth(tm.getMaximumWidth(column));
            }
            if (tm.getMinimumWidth(column) > -1) {
                tc.setMinWidth(tm.getMinimumWidth(column));
            }
            if (tm.getPreferredWidth(column) > -1) {
                tc.setPreferredWidth(tm.getPreferredWidth(column));
            }
            if (field.getWidth() <= -1) continue;
            tc.setPreferredWidth(field.getWidth());
            tc.setWidth(field.getWidth());
        }
    }

    private void showColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < this.screen.getFields().size(); ++i) {
            ActionsField field = (ActionsField)this.screen.getFields().get(i);
            Byte identifier = new Byte(field.getType());
            if (field.isVisible()) {
                ReviewActionsPanel.showColumn(this.table, identifier);
                continue;
            }
            ReviewActionsPanel.hideColumn(this.table, identifier);
        }
    }

    private void orderColumns() {
        byte[] order = this.screen.getFieldOrder();
        if (order == null) {
            return;
        }
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < order.length; ++i) {
            Byte id = new Byte(order[i]);
            int p = tcm.getColumnIndex(id);
            if (p <= -1) continue;
            tcm.moveColumn(p, i);
        }
    }

    private void sortColumns() {
        byte[] fields = this.screen.getSortFields();
        if (fields == null || fields.length == 0) {
            return;
        }
        byte[] status = this.screen.getSortStatus();
        if (status == null || status.length == 0) {
            return;
        }
        if (fields.length != status.length) {
            return;
        }
        JXTable jxtable = (JXTable)this.table;
        for (int i = 0; i < fields.length; ++i) {
            SortOrder sortOrder = this.convertSortOrder(status[i]);
            if (!sortOrder.isSorted()) continue;
            byte column = fields[i];
            jxtable.setSortOrder((int)column, sortOrder);
            return;
        }
    }

    private byte convertSortOrder(SortOrder order) {
        if (!order.isSorted()) {
            return 0;
        }
        if (order.isAscending()) {
            return 1;
        }
        return 2;
    }

    private SortOrder convertSortOrder(byte b) {
        if (b == 1) {
            return SortOrder.ASCENDING;
        }
        if (b == 2) {
            return SortOrder.DESCENDING;
        }
        return SortOrder.UNSORTED;
    }

    private ReviewActionsTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new ReviewActionsTableModel(this.screen, this.data, this.getSelector());
            this.tableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    ReviewActionsPanel.this.itemCountShower.showItemCount(ReviewActionsPanel.this.tableModel.getRowCount());
                }
            });
        }
        return this.tableModel;
    }

    private FiltersActionSelector getSelector() {
        if (this.selector == null) {
            this.selector = new FiltersActionSelector(this.screen.getFilters());
        }
        return this.selector;
    }

    private Icon getColumnsIcon() {
        return Resources.ICON_COLUMNS;
    }

    private Icon getFiltersIcon() {
        return Resources.ICON_FILTERS;
    }

    public void save() {
        LOG.fine("Save table preferences");
        TableColumnModel tcm = this.table.getColumnModel();
        byte[] order = new byte[tcm.getColumnCount()];
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            int modelIndex = tc.getModelIndex();
            order[i] = (byte)modelIndex;
            ((ActionsField)this.screen.getFields().get(modelIndex)).setWidth(tc.getWidth());
        }
        this.screen.setFieldOrder(order);
        JXTable jxtable = (JXTable)this.table;
        byte[] sortFields = new byte[]{};
        byte[] sortStatus = new byte[]{};
        for (int i = 0; i < jxtable.getColumnCount(); ++i) {
            SortOrder sortOrder = jxtable.getSortOrder(i);
            if (!sortOrder.isSorted()) continue;
            sortFields = new byte[]{(byte)i};
            sortStatus = new byte[]{this.convertSortOrder(sortOrder)};
        }
        this.screen.setSortFields(sortFields);
        this.screen.setSortStatus(sortStatus);
    }

    public static void hideColumn(JTable table, Byte identifier) {
        try {
            TableColumn column = table.getColumn(identifier);
            table.getColumnModel().removeColumn(column);
            ArrayList<TableColumn> list = (ArrayList<TableColumn>)table.getClientProperty(HIDDEN_COLUMN);
            if (list == null) {
                list = new ArrayList<TableColumn>();
                table.putClientProperty(HIDDEN_COLUMN, list);
            }
            list.add(column);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void showColumn(JTable table, Byte identifier) {
        ArrayList list = (ArrayList)table.getClientProperty(HIDDEN_COLUMN);
        if (list == null) {
            return;
        }
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            TableColumn column = (TableColumn)iter.next();
            if (!column.getIdentifier().equals(identifier)) continue;
            table.getColumnModel().addColumn(column);
            iter.remove();
            break;
        }
    }

    static {
        LOG = Logger.getLogger("tr.view.actions");
    }
}

