/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.view.actions.screens.FiltersTable;
import tr.view.actions.screens.FiltersTableModel;
import tr.view.actions.screens.fields.ActionsScreen;

public class FiltersDialog
extends JDialog {
    private JPanel bottomPanel;
    private JButton closeButton;
    private JScrollPane scrollPane;
    private JTable table;
    private final ActionsScreen screen;
    private FiltersTableModel tableModel;

    public FiltersDialog(ActionsScreen screen) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.screen = screen;
        this.initComponents();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = this.getTable();
        this.bottomPanel = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getText("FiltersDialog.title"));
        this.setModal(true);
        this.scrollPane.setFocusable(false);
        this.scrollPane.setOpaque(false);
        this.scrollPane.setPreferredSize(new Dimension(400, 400));
        this.table.setFocusable(false);
        this.table.setGridColor(SystemColor.control);
        this.table.setRowSelectionAllowed(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.scrollPane.setViewportView(this.table);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.bottomPanel.setLayout(new FlowLayout(2, 20, 5));
        this.bottomPanel.setFocusable(false);
        this.closeButton.setText(this.getText("FiltersDialog.close"));
        this.closeButton.setFocusCycleRoot(true);
        this.closeButton.setSelected(true);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.closeActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.bottomPanel, "Last");
        this.pack();
    }

    private void closeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private JTable getTable() {
        FiltersTable table = new FiltersTable(this.getTableModel());
        table.setRowHeight(22);
        JTableHeader tableHeader = table.getTableHeader();
        TableCellRenderer tcr = tableHeader.getDefaultRenderer();
        if (tcr instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tcr).setHorizontalAlignment(2);
        }
        for (int column = 0; column < this.getTableModel().getColumnCount(); ++column) {
            TableColumn tc = table.getColumnModel().getColumn(column);
            if (this.tableModel.getCellRenderer(column) != null) {
                tc.setCellRenderer(this.tableModel.getCellRenderer(column));
            }
            if (this.tableModel.getMaximumWidth(column) > -1) {
                tc.setMaxWidth(this.tableModel.getMaximumWidth(column));
            }
            if (this.tableModel.getMinimumWidth(column) > -1) {
                tc.setMinWidth(this.tableModel.getMinimumWidth(column));
            }
            if (this.tableModel.getPreferredWidth(column) <= -1) continue;
            tc.setPreferredWidth(this.tableModel.getPreferredWidth(column));
        }
        return table;
    }

    private FiltersTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new FiltersTableModel(this.screen);
        }
        return this.tableModel;
    }

    private String getText(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }
}

