/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.screens.fields.ActionsField;
import tr.view.actions.screens.fields.ActionsScreen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsTableModel
extends AbstractTableModel
implements Observer {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private static final int[] maxwidths = new int[]{48, -1};
    private static final int[] minwidths = new int[]{48, -1};
    private static final int[] prewidths = new int[]{48, -1};
    private static final Class[] classes = new Class[]{Boolean.class, String.class};
    private static final TableCellRenderer[] renderers = new TableCellRenderer[]{null, null};
    private static final String[] headings = new String[]{ColumnsTableModel.getText("ColumnsDialog.column.visible"), ColumnsTableModel.getText("ColumnsDialog.column.column")};
    private static final byte COLUMN_VISIBLE = 0;
    private static final byte COLUMN_COLUMN = 1;
    private final ActionsScreen actionsScreen;

    public ColumnsTableModel(ActionsScreen screendef) {
        this.actionsScreen = screendef;
        this.actionsScreen.addObserver(this);
    }

    public TableCellRenderer getTableCellRenderer(int column) {
        return renderers[column];
    }

    public int getMaximumWidth(int column) {
        return maxwidths[column];
    }

    public int getMinimumWidth(int column) {
        return minwidths[column];
    }

    public int getPreferredWidth(int column) {
        return prewidths[column];
    }

    @Override
    public int getColumnCount() {
        return classes.length;
    }

    @Override
    public String getColumnName(int column) {
        return headings[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return classes[column];
    }

    @Override
    public int getRowCount() {
        return this.actionsScreen.getFields().size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        ActionsField actionsField = (ActionsField)this.actionsScreen.getFields().get(row);
        switch (column) {
            case 0: {
                return actionsField.isVisible();
            }
            case 1: {
                return actionsField.toString();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        LOG.fine("SetValueAt: row = " + row + " col = " + column);
        if (column == 0 && value instanceof Boolean) {
            ((ActionsField)this.actionsScreen.getFields().get(row)).setVisible((Boolean)value);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public void update(Observable o, Object arg) {
        this.fireTableDataChanged();
    }

    private static String getText(String key) {
        return NbBundle.getMessage(ColumnsTableModel.class, (String)key);
    }
}

