/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import tr.extract.Extract;
import tr.extract.Param;
import tr.model.Data;
import tr.view.actions.prefs.ActionsPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsPrint
extends Extract {
    public String context;
    public String topic;
    public boolean done;
    public boolean inactive;
    public boolean doasap;
    public boolean delegated;
    public boolean scheduled;
    public int upto;
    public List<Field> fields;
    public List<Field> sortfields;
    public List<String> sortorders;

    public String getID() {
        return "actions";
    }

    public String getName() {
        return "";
    }

    public List<Param> getParams() {
        Field f;
        int i;
        Vector<Param> params = new Vector<Param>();
        params.add(new Param("context", this.context));
        params.add(new Param("topic", this.topic));
        params.add(new Param("done", Boolean.toString(this.done)));
        params.add(new Param("inactive", Boolean.toString(this.inactive)));
        params.add(new Param("doasap", Boolean.toString(this.doasap)));
        params.add(new Param("delegated", Boolean.toString(this.delegated)));
        params.add(new Param("scheduled", Boolean.toString(this.scheduled)));
        params.add(new Param("upto", Integer.toString(this.upto)));
        params.add(new Param("colour", Boolean.toString(ActionsPrefs.isReportUseColour())));
        for (i = 0; i < this.fields.size(); ++i) {
            f = this.fields.get(i);
            params.add(new Param("field-" + i, f.value));
        }
        for (i = 0; i < this.sortfields.size(); ++i) {
            f = this.sortfields.get(i);
            params.add(new Param("sort-field-" + i, f.value));
            String o = this.sortorders.get(i);
            params.add(new Param("sort-order-" + i, o));
        }
        return params;
    }

    public void process(Data data) throws Exception {
        File xmlfile = this.getTmpFile("data.xml");
        URL xslfoURL = ((Object)((Object)this)).getClass().getResource("actions.fo.xml");
        File outfile = this.getOutFile(this.getID() + "-" + this.getTimeStamp() + ".pdf");
        this.extractData(data, xmlfile);
        this.transformXSLFO(xmlfile, xslfoURL, this.getParams(), outfile);
        this.openFile(outfile);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Field {
        ACTION_ICON("icon"),
        ACTION_DONE("done"),
        ACTION_DESC("desc"),
        ACTION_DATE("action-date"),
        ACTION_DELEGATE("delegate"),
        ACTION_CONTEXT("context-name"),
        ACTION_TOPIC("topic-name"),
        FROM_ICON("from-icon"),
        FROM_DESC("from-desc"),
        FROM_TOPIC("from-topic-name"),
        CREATED_DATE("created-date"),
        DONE_DATE("done-date");

        private final String value;

        private Field(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

