/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.global.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.actions.RAProjectsTreeTopComponent;
import tr.view.actions.RASingleActionsTopComponent;
import tr.view.actions.Resources;
import tr.view.actions.screens.ReviewActionsTopComponent;
import tr.view.actions.screens.fields.ActionsScreen;
import tr.view.actions.screens.fields.ActionsScreens;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectsTreeLookup;
import tr.view.projects.ProjectsTreeTopComponent;
import tr.view.projects.actions.SingleActionsLookup;
import tr.view.projects.actions.SingleActionsTopComponent;

public class RAAction
extends AbstractAction
implements InitialAction {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private static RAAction instance;
    private Lookup.Result result;

    public RAAction() {
        super(NbBundle.getMessage(RAAction.class, (String)"CTL_RAAction"));
        this.putValue("SmallIcon", Resources.ICON_ACTIONS);
        this.enableDisable();
        this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                LOG.fine("DataLookup Data.class result changed.");
                RAAction.this.enableDisable();
            }
        });
        instance = this;
    }

    public static RAAction getInstance() {
        if (instance == null) {
            instance = new RAAction();
        }
        return instance;
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public void actionPerformed(ActionEvent evt) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        WindowUtils.closeWindows();
        Mode mode = WindowManager.getDefault().findMode("ra-actions");
        if (mode == null) {
            LOG.severe("Mode ra-actions was not found.");
            return;
        }
        boolean first = true;
        for (ActionsScreen s : ActionsScreens.instance().getScreens().list()) {
            ReviewActionsTopComponent tc = ReviewActionsTopComponent.createInstance(s);
            mode.dockInto((TopComponent)tc);
            tc.open();
            if (!first) continue;
            tc.requestActive();
            first = false;
        }
        ProjectsTreeTopComponent tcProjects = RAProjectsTreeTopComponent.findInstance();
        ProjectsTreeLookup.register((ProjectsTreeTopComponent)tcProjects);
        SingleActionsTopComponent tcSingleActions = RASingleActionsTopComponent.findInstance();
        SingleActionsLookup.register((SingleActionsTopComponent)tcSingleActions);
        EditorTopComponent tcEdit = EditorTopComponent.findInstance();
        mode = WindowManager.getDefault().findMode("ra-projects");
        if (mode == null) {
            LOG.severe("Mode ra-projects was not found.");
        } else {
            mode.dockInto((TopComponent)tcProjects);
            mode.dockInto((TopComponent)tcSingleActions);
        }
        mode = WindowManager.getDefault().findMode("ra-editor");
        if (mode == null) {
            LOG.severe("Mode ra-editor was not found.");
        } else {
            mode.dockInto((TopComponent)tcEdit);
        }
        tcProjects.open();
        tcSingleActions.open();
        tcEdit.open();
    }

    public String getID() {
        return "actions";
    }

    public String getName() {
        return (String)this.getValue("Name");
    }
}

