/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.netbeans.modules.settings.convertors.ModuleInfoManager;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.filesystems.FileObject;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class XMLSettingsSupport {
    public static final String INSTANCE_DTD_ID = "-//NetBeans//DTD Session settings 1.0//EN";
    public static final String INSTANCE_DTD_WWW = "http://www.netbeans.org/dtds/sessionsettings-1_0.dtd";
    public static final String XML_EXT = "settings";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final ErrorManager err = ErrorManager.getDefault().getInstance(XMLSettingsSupport.class.getName());
    private static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7'};
    private static final int INDENT = 8;
    private static final int BLOCK = 100;
    private static final int BUFFSIZE = 108;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$util$SharedClassObject;
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;

    XMLSettingsSupport() {
    }

    private static void storeInstanceOf(Set set, PrintWriter printWriter) throws IOException {
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            treeSet.add(((Class)iterator.next()).getName());
        }
        iterator = treeSet.iterator();
        StringBuffer stringBuffer = new StringBuffer(200);
        while (iterator.hasNext()) {
            stringBuffer.append("    <instanceof class=\"").append((String)iterator.next()).append("\"/>" + LINE_SEPARATOR);
        }
        printWriter.print(stringBuffer.toString());
    }

    public static void storeToXML10(Object object, Writer writer, ModuleInfo moduleInfo) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<!DOCTYPE settings PUBLIC \"-//NetBeans//DTD Session settings 1.0//EN\" \"http://www.netbeans.org/dtds/sessionsettings-1_0.dtd\">");
        printWriter.println("<settings version=\"1.0\">");
        XMLSettingsSupport.storeModule(moduleInfo, printWriter);
        XMLSettingsSupport.storeInstanceOf(XMLSettingsSupport.getSuperClasses(object.getClass(), null), printWriter);
        XMLSettingsSupport.storeSerialData(object, printWriter);
        printWriter.println("</settings>");
        printWriter.flush();
    }

    private static void storeToXML10(Class clazz, Writer writer, ModuleInfo moduleInfo) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<!DOCTYPE settings PUBLIC \"-//NetBeans//DTD Session settings 1.0//EN\" \"http://www.netbeans.org/dtds/sessionsettings-1_0.dtd\">");
        printWriter.println("<settings version=\"1.0\">");
        XMLSettingsSupport.storeModule(moduleInfo, printWriter);
        XMLSettingsSupport.storeInstanceOf(XMLSettingsSupport.getSuperClasses(clazz, null), printWriter);
        printWriter.println("    <instance class=\"" + clazz.getName() + "\"/>");
        printWriter.println("</settings>");
        printWriter.flush();
    }

    private static void storeModule(ModuleInfo moduleInfo, PrintWriter printWriter) throws IOException {
        if (moduleInfo == null) {
            return;
        }
        String string = moduleInfo.getCodeName();
        SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("    <module");
        if (string != null && string.length() != 0) {
            stringBuffer.append(" name=\"").append(string).append('\"');
        }
        if (specificationVersion != null) {
            stringBuffer.append(" spec=\"").append(specificationVersion.toString()).append('\"');
        }
        stringBuffer.append("/>");
        printWriter.println(stringBuffer.toString());
    }

    private static void storeSerialData(Object object, PrintWriter printWriter) throws IOException {
        int n;
        printWriter.println("    <serialdata class=\"" + object.getClass().getName() + "\">");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        SpecialObjectOutputStream specialObjectOutputStream = new SpecialObjectOutputStream(byteArrayOutputStream);
        specialObjectOutputStream.writeObject(object);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        char[] cArray = new char[108];
        for (n = 0; n < 8; ++n) {
            cArray[n] = 32;
        }
        n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            int n3;
            int n4 = 8 + Math.min(2 * (n2 - n), 100);
            for (n3 = 8; n3 < n4; n3 += 2) {
                int n5 = byArray[n++] + 256;
                cArray[n3] = HEXDIGITS[n5 >> 4];
                cArray[n3 + 1] = HEXDIGITS[n5 & 0xF];
            }
            printWriter.write(cArray, 0, n3);
            printWriter.println();
        }
        printWriter.println("    </serialdata>");
        printWriter.flush();
    }

    private static Set getSuperClasses(Class clazz, Set hashSet) {
        if (hashSet == null) {
            hashSet = new HashSet<Class>();
        }
        if (clazz == null || !hashSet.add(clazz)) {
            return hashSet;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                XMLSettingsSupport.getSuperClasses(classArray[i], hashSet);
            }
        } else {
            ErrorManager.getDefault().log(65536, "Error: if you encounter this message, please attach the class name to the issue http://www.netbeans.org/issues/show_bug.cgi?id=16257. Class.getInterfaces() == null for the class: " + clazz);
        }
        return XMLSettingsSupport.getSuperClasses(clazz.getSuperclass(), hashSet);
    }

    private static Class getServiceTypeClass(Class clazz) {
        if (!ServiceType.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        while (clazz.getSuperclass() != (class$org$openide$ServiceType == null ? XMLSettingsSupport.class$("org.openide.ServiceType") : class$org$openide$ServiceType)) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static final class Convertor
    extends org.netbeans.spi.settings.Convertor {
        public Object read(Reader reader) throws IOException, ClassNotFoundException {
            SettingsRecognizer settingsRecognizer = new SettingsRecognizer(false, null);
            settingsRecognizer.parse(reader);
            return settingsRecognizer.instanceCreate();
        }

        public void registerSaver(Object object, Saver saver) {
        }

        public void unregisterSaver(Object object, Saver saver) {
        }

        public void write(Writer writer, Object object) throws IOException {
            XMLSettingsSupport.storeToXML10(object, writer, ModuleInfoManager.getDefault().getModuleInfo(object.getClass()));
        }
    }

    static final class SettingsRecognizer
    extends DefaultHandler {
        private static final String ELM_SETTING = "settings";
        private static final String ATR_SETTING_VERSION = "version";
        private static final String ELM_MODULE = "module";
        private static final String ATR_MODULE_NAME = "name";
        private static final String ATR_MODULE_SPEC = "spec";
        private static final String ATR_MODULE_IMPL = "impl";
        private static final String ELM_INSTANCE = "instance";
        private static final String ATR_INSTANCE_CLASS = "class";
        private static final String ATR_INSTANCE_METHOD = "method";
        private static final String ELM_INSTANCEOF = "instanceof";
        private static final String ATR_INSTANCEOF_CLASS = "class";
        private static final String ELM_SERIALDATA = "serialdata";
        private static final String ATR_SERIALDATA_CLASS = "class";
        private boolean header;
        private Stack stack;
        private String version;
        private String instanceClass;
        private String instanceMethod;
        private Set instanceOf = new HashSet();
        private byte[] serialdata;
        private CharArrayWriter chaos = null;
        private String codeName;
        private String codeNameBase;
        private int codeNameRelease;
        private SpecificationVersion moduleSpec;
        private String moduleImpl;
        private final FileObject source;
        private static final byte[] MODULE_SETTINGS_INTRO = "<?xml version=\"1.0\"?> <!DOCTYPE settings PUBLIC \"-//NetBeans//DTD Session settings 1.0//EN\" \"http://www.netbeans.org/dtds/sessionsettings-1_0.dtd\"> <settings version=\"".getBytes();
        private static final byte[] MODULE_SETTINGS_INTRO_END = "> <".getBytes();
        private static final byte[] MODULE_SETTINGS_MODULE_NAME = "odule name=\"".getBytes();
        private static final byte[] MODULE_SETTINGS_MODULE_SPEC = "spec=\"".getBytes();
        private static final byte[] MODULE_SETTINGS_MODULE_IMPL = "impl=\"".getBytes();
        private static final byte[] MODULE_SETTINGS_TAG_END = "> <".getBytes();
        private static final byte[] MODULE_SETTINGS_INSTANCE = "nstance".getBytes();
        private static final byte[] MODULE_SETTINGS_INSTANCE_CLZ = "class=\"".getBytes();
        private static final byte[] MODULE_SETTINGS_INSTANCE_MTD = "method=\"".getBytes();
        private static final byte[] MODULE_SETTINGS_OF = "f class=\"".getBytes();
        private static final byte[] MODULE_SETTINGS_SERIAL = "erialdata class=\"".getBytes();
        private static final byte[] MODULE_SETTINGS_END = "settings>".getBytes();

        public SettingsRecognizer(boolean bl, FileObject fileObject) {
            this.header = bl;
            this.source = fileObject;
        }

        public boolean isAllRead() {
            return !this.header;
        }

        public void setAllRead(boolean bl) {
            if (!this.header) {
                return;
            }
            this.header = bl;
        }

        public String getSettingsVerison() {
            return this.version;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public String getCodeNameBase() {
            return this.codeNameBase;
        }

        public int getCodeNameRelease() {
            return this.codeNameRelease;
        }

        public SpecificationVersion getSpecificationVersion() {
            return this.moduleSpec;
        }

        public String getModuleImpl() {
            return this.moduleImpl;
        }

        public Set getInstanceOf() {
            return this.instanceOf;
        }

        public String getMethodName() {
            return this.instanceMethod;
        }

        private InputStream getSerializedInstance() {
            if (this.serialdata == null) {
                return null;
            }
            return new ByteArrayInputStream(this.serialdata);
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (XMLSettingsSupport.INSTANCE_DTD_ID.equals(string)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.header) {
                return;
            }
            String string = (String)this.stack.peek();
            if (ELM_SERIALDATA.equals(string)) {
                if (this.chaos == null) {
                    this.chaos = new CharArrayWriter(n2);
                }
                this.chaos.write(cArray, n, n2);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.stack.push(string3);
            if ("settings".equals(string3)) {
                this.version = attributes.getValue(ATR_SETTING_VERSION);
            } else if (ELM_MODULE.equals(string3)) {
                this.codeName = attributes.getValue(ATR_MODULE_NAME);
                this.resolveModuleElm(this.codeName);
                this.moduleImpl = attributes.getValue(ATR_MODULE_IMPL);
                try {
                    String string4 = attributes.getValue(ATR_MODULE_SPEC);
                    this.moduleSpec = string4 == null ? null : new SpecificationVersion(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException(numberFormatException);
                }
            } else if (ELM_INSTANCEOF.equals(string3)) {
                this.instanceOf.add(Utilities.translate((String)attributes.getValue("class")));
            } else if (ELM_INSTANCE.equals(string3)) {
                this.instanceClass = attributes.getValue("class");
                if (this.instanceClass == null) {
                    System.err.println("Hint: NPE is caused by broken settings file: " + this.source);
                }
                this.instanceClass = Utilities.translate((String)this.instanceClass);
                this.instanceMethod = attributes.getValue(ATR_INSTANCE_METHOD);
            } else if (ELM_SERIALDATA.equals(string3)) {
                this.instanceClass = attributes.getValue("class");
                this.instanceClass = Utilities.translate((String)this.instanceClass);
                if (this.header) {
                    throw new StopSAXException();
                }
            }
        }

        private void resolveModuleElm(String string) {
            if (string != null) {
                int n = string.indexOf("/");
                if (n == -1) {
                    this.codeNameBase = string;
                    this.codeNameRelease = -1;
                } else {
                    this.codeNameBase = string.substring(0, n);
                    try {
                        this.codeNameRelease = Integer.parseInt(string.substring(n + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ErrorManager errorManager = ErrorManager.getDefault();
                        errorManager.annotate((Throwable)numberFormatException, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                        errorManager.annotate((Throwable)numberFormatException, "Source: " + this.source);
                        errorManager.notify(1, (Throwable)numberFormatException);
                        this.codeNameRelease = -1;
                    }
                }
            } else {
                this.codeNameBase = null;
                this.codeNameRelease = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = (String)this.stack.pop();
            if (ELM_SERIALDATA.equals(string4) && this.chaos != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.chaos.size() >> 1);
                try {
                    this.chars2Bytes(byteArrayOutputStream, this.chaos.toCharArray(), 0, this.chaos.size());
                    this.serialdata = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(16, (Throwable)iOException);
                }
                finally {
                    this.chaos = null;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object readSerial(InputStream inputStream) throws IOException, ClassNotFoundException {
            Object object;
            if (inputStream == null) {
                return null;
            }
            SpecialObjectInputStream specialObjectInputStream = new SpecialObjectInputStream(inputStream);
            try {
                Object object2;
                object = object2 = specialObjectInputStream.readObject();
            }
            catch (Throwable throwable) {
                try {
                    specialObjectInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)iOException, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                    errorManager.annotate((Throwable)iOException, "Source: " + this.source);
                    errorManager.annotate((Throwable)iOException, "Cannot read class: " + this.instanceClass);
                    throw iOException;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)classNotFoundException, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                    errorManager.annotate((Throwable)classNotFoundException, "Source: " + this.source);
                    throw classNotFoundException;
                }
            }
            specialObjectInputStream.close();
            return object;
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            Object object = null;
            object = this.readSerial(this.getSerializedInstance());
            if (object == null) {
                Class clazz;
                if (this.instanceMethod != null) {
                    object = this.createFromMethod(this.instanceClass, this.instanceMethod);
                } else if ((class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = XMLSettingsSupport.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).isAssignableFrom(clazz = this.instanceClass())) {
                    object = SharedClassObject.findObject((Class)clazz, (boolean)false);
                    if (null != object) {
                        try {
                            Method method = (class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = XMLSettingsSupport.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).getDeclaredMethod("reset", new Class[0]);
                            method.setAccessible(true);
                            method.invoke(object, new Object[0]);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                    } else {
                        object = SharedClassObject.findObject((Class)clazz, (boolean)true);
                    }
                } else {
                    try {
                        object = clazz.newInstance();
                    }
                    catch (Exception exception) {
                        IOException iOException = new IOException();
                        ErrorManager errorManager = ErrorManager.getDefault();
                        errorManager.annotate((Throwable)iOException, (Throwable)exception);
                        errorManager.annotate((Throwable)iOException, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                        errorManager.annotate((Throwable)iOException, "Class: " + clazz);
                        errorManager.annotate((Throwable)iOException, "Source: " + this.source);
                        throw iOException;
                    }
                }
            }
            return object;
        }

        private static String getFileContent(FileObject fileObject) {
            try {
                int n;
                InputStreamReader inputStreamReader = new InputStreamReader(fileObject.getInputStream());
                char[] cArray = new char[1024];
                StringBuffer stringBuffer = new StringBuffer(1024);
                while ((n = inputStreamReader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n);
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                return stringWriter.toString();
            }
        }

        private Object createFromMethod(String string, String string2) throws ClassNotFoundException, IOException {
            String string3;
            String string4;
            int n = this.instanceMethod.lastIndexOf(46);
            if (n > 0) {
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            } else {
                string4 = string;
                string3 = string2;
            }
            Class clazz = this.loadClass(string4);
            try {
                Object object;
                try {
                    Method method = clazz.getMethod(string3, class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = XMLSettingsSupport.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject);
                    method.setAccessible(true);
                    object = method.invoke(null, (Object[])new FileObject[]{this.source});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = clazz.getMethod(string3, null);
                    method.setAccessible(true);
                    object = method.invoke(null, new Object[0]);
                }
                if (object == null) {
                    throw new IOException("Null return not permitted from " + string4 + "." + string3);
                }
                return object;
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Error reading " + this.source + ": " + exception);
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, "Class: " + clazz);
                errorManager.annotate((Throwable)iOException, "Method: " + string2);
                errorManager.annotate((Throwable)iOException, (Throwable)exception);
                errorManager.annotate((Throwable)iOException, "Content:\n" + SettingsRecognizer.getFileContent(this.source));
                throw iOException;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            if (this.instanceClass == null) {
                throw new ClassNotFoundException(this.source + ": missing 'class' attribute in 'instance' element");
            }
            return this.loadClass(this.instanceClass);
        }

        private Class loadClass(String string) throws ClassNotFoundException {
            return ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = XMLSettingsSupport.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass(string);
        }

        public String instanceName() {
            if (this.instanceClass == null) {
                return "";
            }
            return this.instanceClass;
        }

        private int tr(char c) {
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'A' && c <= 'F') {
                return c - 65 + 10;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
            return -1;
        }

        private void chars2Bytes(OutputStream outputStream, char[] cArray, int n, int n2) throws IOException {
            int n3 = n;
            block0: while (n3 < n2) {
                int n4;
                if ((n4 = this.tr(cArray[n3++])) < 0) continue;
                byte by = (byte)(n4 << 4);
                while (n3 < n2) {
                    if ((n4 = this.tr(cArray[n3++])) < 0) continue;
                    by = (byte)(by + (byte)n4);
                    outputStream.write(by);
                    continue block0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse() throws IOException {
            Object object;
            Object object2;
            InputStream inputStream = null;
            try {
                if (this.header) {
                    if (err.isLoggable(1) && this.source.getSize() < 12000L) {
                        object2 = new byte[(int)this.source.getSize()];
                        object = this.source.getInputStream();
                        int n = ((InputStream)object).read((byte[])object2);
                        if (n != ((Object)object2).length) {
                            throw new IOException("Could not read " + ((Object)object2).length + " bytes from " + this.source + " just " + n);
                        }
                        err.log("Parsing:" + new String((byte[])object2));
                        ((InputStream)object).close();
                        inputStream = new ByteArrayInputStream((byte[])object2);
                    } else {
                        inputStream = new BufferedInputStream(this.source.getInputStream());
                    }
                    object2 = this.quickParse(new BufferedInputStream(inputStream));
                    if (object2 != null) {
                        this.instanceOf = object2;
                        return;
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            this.stack = new Stack();
            try {
                inputStream = this.source.getInputStream();
                object2 = XMLUtil.createXMLReader();
                object2.setContentHandler(this);
                object2.setErrorHandler(this);
                object2.setEntityResolver(this);
                object2.parse(new InputSource(new BufferedInputStream(inputStream)));
            }
            catch (StopSAXException stopSAXException) {
            }
            catch (SAXException sAXException) {
                object = new IOException(this.source.toString());
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)object, (Throwable)sAXException);
                if (sAXException.getException() != null) {
                    errorManager.annotate((Throwable)object, (Throwable)sAXException.getException());
                }
                errorManager.annotate((Throwable)object, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                errorManager.annotate((Throwable)object, "Source: " + this.source);
                throw object;
            }
            finally {
                this.stack = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        public void parse(Reader reader) throws IOException {
            this.stack = new Stack();
            try {
                XMLReader xMLReader = XMLUtil.createXMLReader();
                xMLReader.setContentHandler(this);
                xMLReader.setErrorHandler(this);
                xMLReader.setEntityResolver(this);
                xMLReader.parse(new InputSource(reader));
            }
            catch (StopSAXException stopSAXException) {
            }
            catch (SAXException sAXException) {
                IOException iOException = new IOException(reader.toString());
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, (Throwable)sAXException);
                if (sAXException.getException() != null) {
                    errorManager.annotate((Throwable)iOException, (Throwable)sAXException.getException());
                }
                throw iOException;
            }
            finally {
                this.stack = null;
            }
        }

        /*
         * Unable to fully structure code
         */
        private Set quickParse(InputStream var1_1) throws IOException {
            var2_2 = new HashSet<String>();
            if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INTRO)) {
                XMLSettingsSupport.err.log("Could not read intro " + this.source);
                return null;
            }
            this.version = this.readTo(var1_1, '\"');
            if (this.version == null) {
                XMLSettingsSupport.err.log("Could not read version " + this.source);
                return null;
            }
            if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INTRO_END)) {
                XMLSettingsSupport.err.log("Could not read stuff after cnb " + this.source);
                return null;
            }
            block8: while (true) lbl-1000:
            // 7 sources

            {
                var3_3 = var1_1.read();
                switch (var3_3) {
                    case 109: {
                        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_MODULE_NAME)) {
                            XMLSettingsSupport.err.log("Could not read up to <module name=\" " + this.source);
                            return null;
                        }
                        var4_4 = this.readTo(var1_1, '\"');
                        if (var4_4 == null) {
                            XMLSettingsSupport.err.log("Could not read module name value " + this.source);
                            return null;
                        }
                        var4_4 = var4_4.intern();
                        this.resolveModuleElm(var4_4);
                        var3_3 = var1_1.read();
                        if (var3_3 != 47) ** GOTO lbl30
                        if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                        XMLSettingsSupport.err.log("Could not read up to end of module tag " + this.source);
                        return null;
lbl30:
                        // 1 sources

                        if (var3_3 != 32) {
                            XMLSettingsSupport.err.log("Could not space after module name " + this.source);
                            return null;
                        }
                        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_MODULE_SPEC)) {
                            XMLSettingsSupport.err.log("Could not read up to spec=\" " + this.source);
                            return null;
                        }
                        var5_5 = this.readTo(var1_1, '\"');
                        if (var5_5 == null) {
                            XMLSettingsSupport.err.log("Could not read module spec value " + this.source);
                            return null;
                        }
                        try {
                            this.moduleSpec = new SpecificationVersion(var5_5);
                        }
                        catch (NumberFormatException var6_7) {
                            return null;
                        }
                        var3_3 = var1_1.read();
                        if (var3_3 != 47) ** GOTO lbl50
                        if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                        XMLSettingsSupport.err.log("Could not read up to end of <module name spec/> tag " + this.source);
                        return null;
lbl50:
                        // 1 sources

                        if (var3_3 != 32) {
                            XMLSettingsSupport.err.log("Could not read space after module name " + this.source);
                            return null;
                        }
                        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_MODULE_IMPL)) {
                            XMLSettingsSupport.err.log("Could not read up to impl=\" " + this.source);
                            return null;
                        }
                        this.moduleImpl = this.readTo(var1_1, '\"');
                        if (this.moduleImpl == null) {
                            XMLSettingsSupport.err.log("Could not read module impl value " + this.source);
                            return null;
                        }
                        this.moduleImpl = this.moduleImpl.intern();
                        if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                        XMLSettingsSupport.err.log("Could not read up to /> < " + this.source);
                        return null;
                    }
                    case 105: {
                        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INSTANCE)) {
                            XMLSettingsSupport.err.log("Could not read up to instance " + this.source);
                            return null;
                        }
                        var3_3 = var1_1.read();
                        if (var3_3 != 111) ** GOTO lbl86
                        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_OF)) {
                            XMLSettingsSupport.err.log("Could not read up to instance");
                            return null;
                        }
                        var6_6 = this.readTo(var1_1, '\"');
                        if (var6_6 == null) {
                            XMLSettingsSupport.err.log("Could not read instanceof value " + this.source);
                            return null;
                        }
                        var6_6 = Utilities.translate((String)var6_6).intern();
                        var2_2.add(var6_6);
                        if (var1_1.read() != 47) {
                            XMLSettingsSupport.err.log("No / at end of <instanceof> " + var6_6 + " " + this.source);
                            return null;
                        }
                        if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                        XMLSettingsSupport.err.log("Could not read up to next tag after <instanceof> " + var6_6 + " " + this.source);
                        return null;
lbl86:
                        // 1 sources

                        if (var3_3 != 32) ** GOTO lbl118
                        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INSTANCE_CLZ)) {
                            XMLSettingsSupport.err.log("Could not read up to class=\" " + this.source);
                            return null;
                        }
                        this.instanceClass = this.readTo(var1_1, '\"');
                        if (this.instanceClass == null) {
                            XMLSettingsSupport.err.log("Could not read instance class value " + this.source);
                            return null;
                        }
                        this.instanceClass = Utilities.translate((String)this.instanceClass).intern();
                        var3_3 = var1_1.read();
                        if (var3_3 != 47) ** GOTO lbl100
                        if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                        XMLSettingsSupport.err.log("Could not read up to end of instance tag " + this.source);
                        return null;
lbl100:
                        // 1 sources

                        if (var3_3 != 32) {
                            XMLSettingsSupport.err.log("Could not space after instance class " + this.source);
                            return null;
                        }
                        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INSTANCE_MTD)) {
                            XMLSettingsSupport.err.log("Could not read up to method=\" " + this.source);
                            return null;
                        }
                        this.instanceMethod = this.readTo(var1_1, '\"');
                        if (this.instanceMethod == null) {
                            XMLSettingsSupport.err.log("Could not read method value " + this.source);
                            return null;
                        }
                        this.instanceMethod = this.instanceMethod.intern();
                        var3_3 = var1_1.read();
                        if (var3_3 == 47) {
                            if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) continue block8;
                            XMLSettingsSupport.err.log("Could not read up to end of instance tag " + this.source);
                            return null;
                        }
                        XMLSettingsSupport.err.log("Strange stuff after method attribute " + this.source);
                        return null;
lbl118:
                        // 1 sources

                        XMLSettingsSupport.err.log("Could not read after to instance " + this.source);
                        return null;
                    }
                    case 115: {
                        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_SERIAL)) {
                            XMLSettingsSupport.err.log("Could not read up to <serialdata class=\" " + this.source);
                            return null;
                        }
                        this.instanceClass = this.readTo(var1_1, '\"');
                        if (this.instanceClass == null) {
                            XMLSettingsSupport.err.log("Could not read serialdata class value " + this.source);
                            return null;
                        }
                        this.instanceClass = Utilities.translate((String)this.instanceClass).intern();
                        var3_3 = var1_1.read();
                        if (var3_3 == 62) break block8;
                        XMLSettingsSupport.err.log("Could not read up to end of serialdata tag " + this.source);
                        return null;
                    }
                    case 47: {
                        if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_END)) break block8;
                        XMLSettingsSupport.err.log("Could not read up to end of settings tag " + this.source);
                        return null;
                    }
                    default: {
                        XMLSettingsSupport.err.log("Strange stuff after <" + (char)var3_3 + " " + this.source);
                        return null;
                    }
                }
                break;
            }
            if (this.instanceClass != null && !var2_2.isEmpty()) {
                return var2_2;
            }
            return null;
        }

        private boolean expect(InputStream inputStream, byte[] byArray) throws IOException {
            int n = byArray.length;
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                int n3 = inputStream.read();
                if (n3 == 10 || n3 == 13 || n3 == 32 || n3 == 9) {
                    if (bl) continue;
                    bl = true;
                    n3 = 32;
                } else {
                    bl = false;
                }
                if (n3 == byArray[n2++]) continue;
                return false;
            }
            if (byArray[n - 1] == 10) {
                if (!inputStream.markSupported()) {
                    throw new IOException("Mark not supported");
                }
                inputStream.mark(1);
                n2 = inputStream.read();
                if (n2 != -1 && n2 != 10 && n2 != 13) {
                    inputStream.reset();
                }
            }
            return true;
        }

        private String readTo(InputStream inputStream, char c) throws IOException {
            if (c == '\n') {
                throw new IOException("Not implemented");
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter(100);
            boolean bl = false;
            int n;
            while ((n = inputStream.read()) != -1) {
                if (n > 126) {
                    return null;
                }
                if (n == 10 || n == 13) {
                    if (bl) continue;
                    bl = true;
                    n = 10;
                } else {
                    if (n < 32 && n != 9) {
                        return null;
                    }
                    bl = false;
                }
                if (n == c) {
                    return charArrayWriter.toString();
                }
                charArrayWriter.write(n);
            }
            return null;
        }
    }

    private static class SpecialObjectInputStream
    extends ObjectInputStream {
        public SpecialObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            try {
                this.enableResolveObject(true);
            }
            catch (SecurityException securityException) {
                throw new IOException(securityException.toString());
            }
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            ClassLoader classLoader = SpecialObjectInputStream.getNBClassLoader();
            try {
                return Class.forName(objectStreamClass.getName(), false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string = "Offending classloader: " + classLoader;
                ErrorManager.getDefault().annotate((Throwable)classNotFoundException, 1, string, null, null, null);
                throw classNotFoundException;
            }
        }

        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            String string;
            ObjectStreamClass objectStreamClass = super.readClassDescriptor();
            String string2 = objectStreamClass.getName();
            if (string2 == (string = Utilities.translate((String)string2))) {
                return objectStreamClass;
            }
            ClassLoader classLoader = SpecialObjectInputStream.getNBClassLoader();
            try {
                Class<?> clazz = Class.forName(string2, false, classLoader);
                return ObjectStreamClass.lookup(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class<?> clazz = Class.forName(string, false, classLoader);
                ObjectStreamClass objectStreamClass2 = ObjectStreamClass.lookup(clazz);
                if (objectStreamClass2 == null) {
                    throw new NotSerializableException(string);
                }
                return objectStreamClass2;
            }
        }

        private static ClassLoader getNBClassLoader() {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = XMLSettingsSupport.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
        }
    }

    private static class SpecialObjectOutputStream
    extends NbObjectOutputStream {
        private boolean first = true;

        public SpecialObjectOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
        }

        public Object replaceObject(Object object) throws IOException {
            if (this.first) {
                if (object == null) {
                    throw new NotSerializableException();
                }
                this.first = false;
            }
            return super.replaceObject(object);
        }
    }

    static final class StopSAXException
    extends SAXException {
        public StopSAXException() {
            super("Parser stopped");
        }
    }
}

