/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.util.RequestProcessor;

final class RefreshRequest
implements Runnable {
    private static final int REFRESH_COUNT = 30;
    private static RequestProcessor REFRESHER = new RequestProcessor("FS refresher");
    private Reference system;
    private Enumeration en;
    private int refreshTime;
    private RequestProcessor.Task task;

    public RefreshRequest(AbstractFileSystem abstractFileSystem, int n) {
        this.system = new WeakReference<AbstractFileSystem>(abstractFileSystem);
        this.refreshTime = n;
        this.task = REFRESHER.post((Runnable)this, n, 1);
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public synchronized void stop() {
        this.refreshTime = 0;
        if (this.task == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RequestProcessor.Task task;
        int n;
        RefreshRequest refreshRequest = this;
        synchronized (refreshRequest) {
            n = this.refreshTime;
            if (n <= 0) {
                return;
            }
            task = this.task;
            this.task = null;
        }
        try {
            this.doLoop(n);
        }
        finally {
            refreshRequest = this;
            synchronized (refreshRequest) {
                this.task = task;
                this.notifyAll();
            }
            if (this.system != null && this.system.get() != null) {
                task.schedule(n);
            } else {
                this.refreshTime = 0;
            }
        }
    }

    private void doLoop(int n) {
        AbstractFileSystem abstractFileSystem = (AbstractFileSystem)this.system.get();
        if (abstractFileSystem == null) {
            return;
        }
        if (this.en == null || !this.en.hasMoreElements()) {
            this.en = RefreshRequest.existingFolders(abstractFileSystem);
        }
        for (int i = 0; i < 30 && this.en.hasMoreElements(); ++i) {
            AbstractFolder abstractFolder = (AbstractFolder)this.en.nextElement();
            if (abstractFolder != null && (!abstractFolder.isFolder() || abstractFolder.isInitialized())) {
                abstractFolder.refresh();
            }
            if (this.refreshTime > 0) continue;
            return;
        }
        if (!this.en.hasMoreElements()) {
            this.en = null;
        }
    }

    private static Enumeration existingFolders(AbstractFileSystem abstractFileSystem) {
        return abstractFileSystem.existingFileObjects(abstractFileSystem.getAbstractRoot());
    }

    public String toString() {
        AbstractFileSystem abstractFileSystem = (AbstractFileSystem)this.system.get();
        return "RefreshRequest for " + (abstractFileSystem == null ? "gone FS" : abstractFileSystem.getSystemName());
    }
}

