/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

final class MIMESupport {
    private static final WeakReference EMPTY = new WeakReference<Object>(null);
    private static WeakReference lastFo = EMPTY;
    private static WeakReference lastCfo = EMPTY;
    private static Object lock = new Object();
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance(MIMESupport.class.getName());
    static /* synthetic */ Class class$org$openide$filesystems$MIMESupport$CachedFileObject;
    static /* synthetic */ Class class$org$openide$filesystems$MIMEResolver;

    private MIMESupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findMIMEType(FileObject fileObject, String string) {
        Object object;
        if (!fileObject.isValid() || fileObject.isFolder()) {
            return null;
        }
        if (string != null && !CachedFileObject.isAnyResolver()) {
            return string;
        }
        Object object2 = null;
        try {
            Object object3 = lock;
            synchronized (object3) {
                object = (CachedFileObject)lastCfo.get();
                object2 = object == null || fileObject != lastFo.get() || fileObject.lastModified().getTime() != ((CachedFileObject)object).lastModified().getTime() ? new CachedFileObject(fileObject) : object;
                lastCfo = EMPTY;
            }
            object3 = ((CachedFileObject)object2).getMIMEType(string);
            return object3;
        }
        finally {
            object = lock;
            synchronized (object) {
                lastFo = new WeakReference<FileObject>(fileObject);
                lastCfo = new WeakReference<CachedFileObject>((CachedFileObject)object2);
            }
        }
    }

    static MIMEResolver[] getResolvers() {
        return CachedFileObject.getResolvers();
    }

    private static class CachedFileObject
    extends FileObject
    implements FileChangeListener {
        static Lookup.Result result;
        private static Object resolvers;
        private static MIMEResolver[] previousResolvers;
        String mimeType;
        Date lastModified;
        CachedInputStream fixIt;
        FileObject fileObj;

        CachedFileObject(FileObject fileObject) {
            this.fileObj = fileObject;
            this.lastModified = this.fileObj.lastModified();
            this.fileObj.addFileChangeListener(FileUtil.weakFileChangeListener(this, this.fileObj));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MIMEResolver[] getResolvers() {
            Object object;
            if (class$org$openide$filesystems$MIMESupport$CachedFileObject == null) {
                class$org$openide$filesystems$MIMESupport$CachedFileObject = MIMESupport.class$("org.openide.filesystems.MIMESupport$CachedFileObject");
                object = class$org$openide$filesystems$MIMESupport$CachedFileObject;
            } else {
                object = class$org$openide$filesystems$MIMESupport$CachedFileObject;
            }
            MIMEResolver[] mIMEResolverArray = object;
            synchronized (object) {
                HashSet<Thread> hashSet;
                if (resolvers instanceof MIMEResolver[]) {
                    // ** MonitorExit[var1] (shouldn't be in output)
                    return (MIMEResolver[])resolvers;
                }
                if (resolvers instanceof Set) {
                    hashSet = (HashSet<Thread>)resolvers;
                    if (hashSet.contains(Thread.currentThread())) {
                        ERR.log("Stack Overflow prevention. Returning previousResolvers: " + previousResolvers);
                        MIMEResolver[] mIMEResolverArray2 = previousResolvers;
                        if (!(mIMEResolverArray2 instanceof MIMEResolver[])) {
                            mIMEResolverArray2 = new MIMEResolver[]{};
                        }
                        // ** MonitorExit[var1] (shouldn't be in output)
                        return mIMEResolverArray2;
                    }
                } else {
                    resolvers = hashSet = new HashSet<Thread>();
                }
                if (result == null) {
                    result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$filesystems$MIMEResolver == null ? (class$org$openide$filesystems$MIMEResolver = MIMESupport.class$("org.openide.filesystems.MIMEResolver")) : class$org$openide$filesystems$MIMEResolver));
                    result.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent lookupEvent) {
                            Class clazz = class$org$openide$filesystems$MIMESupport$CachedFileObject == null ? (class$org$openide$filesystems$MIMESupport$CachedFileObject = MIMESupport.class$("org.openide.filesystems.MIMESupport$CachedFileObject")) : class$org$openide$filesystems$MIMESupport$CachedFileObject;
                            synchronized (clazz) {
                                ERR.log("Clearing cache");
                                Object object = resolvers;
                                if (object instanceof MIMEResolver[]) {
                                    CachedFileObject.access$302((MIMEResolver[])object);
                                }
                                resolvers = null;
                                lastFo = EMPTY;
                                lastCfo = EMPTY;
                            }
                        }
                    });
                }
                hashSet.add(Thread.currentThread());
                // ** MonitorExit[var1] (shouldn't be in output)
                ERR.log("Computing resolvers");
                mIMEResolverArray = result.allInstances().toArray(new MIMEResolver[0]);
                ERR.log("Resolvers computed");
                Class clazz = class$org$openide$filesystems$MIMESupport$CachedFileObject == null ? (class$org$openide$filesystems$MIMESupport$CachedFileObject = MIMESupport.class$("org.openide.filesystems.MIMESupport$CachedFileObject")) : class$org$openide$filesystems$MIMESupport$CachedFileObject;
                synchronized (clazz) {
                    if (resolvers == hashSet) {
                        resolvers = mIMEResolverArray;
                        previousResolvers = null;
                        ERR.log("Resolvers assigned");
                    } else {
                        ERR.log("Somebody else computes resolvers: " + resolvers);
                    }
                    return mIMEResolverArray;
                }
            }
        }

        public static boolean isAnyResolver() {
            return CachedFileObject.getResolvers().length > 0;
        }

        public void freeCaches() {
            this.fixIt = null;
            this.mimeType = null;
            this.lastModified = null;
        }

        public String getMIMEType() {
            return this.getMIMEType(null);
        }

        public String getMIMEType(String string) {
            if (this.mimeType == null) {
                this.mimeType = this.resolveMIME(string);
            }
            return this.mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveMIME(String string) {
            String string2 = null;
            MIMEResolver[] mIMEResolverArray = CachedFileObject.getResolvers();
            try {
                for (int i = 0; i < mIMEResolverArray.length; ++i) {
                    string2 = mIMEResolverArray[i].findMIMEType(this);
                    if (string2 == null) continue;
                    String string3 = string2;
                    return string3;
                }
                if (string != null) {
                    String string4 = string;
                    return string4;
                }
                String string5 = "content/unknown";
                return string5;
            }
            finally {
                if (this.fixIt != null) {
                    this.fixIt.internalClose();
                }
                this.fixIt = null;
            }
        }

        public Date lastModified() {
            if (this.lastModified != null) {
                return this.lastModified;
            }
            this.lastModified = this.fileObj.lastModified();
            return this.lastModified;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            if (this.fixIt == null) {
                InputStream inputStream = this.fileObj.getInputStream();
                if (!(inputStream instanceof BufferedInputStream)) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                this.fixIt = new CachedInputStream(inputStream);
            }
            this.fixIt.cacheToStart();
            return this.fixIt;
        }

        public void fileChanged(FileEvent fileEvent) {
            this.freeCaches();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.freeCaches();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.freeCaches();
        }

        public FileObject getParent() {
            return this.fileObj.getParent();
        }

        public String getPackageNameExt(char c, char c2) {
            return this.fileObj.getPackageNameExt(c, c2);
        }

        public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
            return this.fileObj.copy(fileObject, string, string2);
        }

        protected void fireFileDeletedEvent(Enumeration enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileDeletedEvent(enumeration, fileEvent);
        }

        protected void fireFileFolderCreatedEvent(Enumeration enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileFolderCreatedEvent(enumeration, fileEvent);
        }

        public void setImportant(boolean bl) {
            this.fileObj.setImportant(bl);
        }

        public boolean isData() {
            return this.fileObj.isData();
        }

        public Object getAttribute(String string) {
            return this.fileObj.getAttribute(string);
        }

        public Enumeration getFolders(boolean bl) {
            return this.fileObj.getFolders(bl);
        }

        public void delete(FileLock fileLock) throws IOException {
            this.fileObj.delete(fileLock);
        }

        public boolean isRoot() {
            return this.fileObj.isRoot();
        }

        public Enumeration getData(boolean bl) {
            return this.fileObj.getData(bl);
        }

        public FileObject[] getChildren() {
            return this.fileObj.getChildren();
        }

        public String getNameExt() {
            return this.fileObj.getNameExt();
        }

        public boolean isValid() {
            return this.fileObj.isValid();
        }

        public boolean isReadOnly() {
            return this.fileObj.isReadOnly();
        }

        public String getExt() {
            return this.fileObj.getExt();
        }

        public String getName() {
            return this.fileObj.getName();
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            this.fileObj.removeFileChangeListener(fileChangeListener);
        }

        protected void fireFileRenamedEvent(Enumeration enumeration, FileRenameEvent fileRenameEvent) {
            this.fileObj.fireFileRenamedEvent(enumeration, fileRenameEvent);
        }

        public void refresh(boolean bl) {
            this.fileObj.refresh(bl);
        }

        protected void fireFileAttributeChangedEvent(Enumeration enumeration, FileAttributeEvent fileAttributeEvent) {
            this.fileObj.fireFileAttributeChangedEvent(enumeration, fileAttributeEvent);
        }

        public long getSize() {
            return this.fileObj.getSize();
        }

        public Enumeration getAttributes() {
            return this.fileObj.getAttributes();
        }

        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            this.fileObj.rename(fileLock, string, string2);
        }

        protected void fireFileChangedEvent(Enumeration enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileChangedEvent(enumeration, fileEvent);
        }

        public FileObject getFileObject(String string, String string2) {
            return this.fileObj.getFileObject(string, string2);
        }

        public void refresh() {
            this.fileObj.refresh();
        }

        public FileObject createData(String string, String string2) throws IOException {
            return this.fileObj.createData(string, string2);
        }

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            this.fileObj.addFileChangeListener(fileChangeListener);
        }

        protected void fireFileDataCreatedEvent(Enumeration enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileDataCreatedEvent(enumeration, fileEvent);
        }

        public boolean isFolder() {
            return this.fileObj.isFolder();
        }

        public FileObject createFolder(String string) throws IOException {
            return this.fileObj.createFolder(string);
        }

        public Enumeration getChildren(boolean bl) {
            return this.fileObj.getChildren(bl);
        }

        public void setAttribute(String string, Object object) throws IOException {
            this.fileObj.setAttribute(string, object);
        }

        public String getPackageName(char c) {
            return this.fileObj.getPackageName(c);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fileObj.getFileSystem();
        }

        public OutputStream getOutputStream(FileLock fileLock) throws IOException {
            return this.fileObj.getOutputStream(fileLock);
        }

        public boolean existsExt(String string) {
            return this.fileObj.existsExt(string);
        }

        public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
            return this.fileObj.move(fileLock, fileObject, string, string2);
        }

        public FileLock lock() throws IOException {
            return this.fileObj.lock();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public int hashCode() {
            return this.fileObj.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CachedFileObject) {
                return ((CachedFileObject)object).fileObj.equals(this.fileObj);
            }
            return super.equals(object);
        }

        static /* synthetic */ MIMEResolver[] access$302(MIMEResolver[] mIMEResolverArray) {
            previousResolvers = mIMEResolverArray;
            return mIMEResolverArray;
        }
    }

    private static class CachedInputStream
    extends InputStream {
        private InputStream inputStream;
        private byte[] buffer = null;
        private int len = 0;
        private int pos = 0;
        private boolean eof = false;

        CachedInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void close() throws IOException {
        }

        void internalClose() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void finalize() {
            this.internalClose();
        }

        public int read() throws IOException {
            int n;
            int n2;
            if (this.eof) {
                return -1;
            }
            if (this.pos < this.len) {
                int n3;
                n3 = (n3 = this.buffer[this.pos++]) < 0 ? n3 + 256 : n3;
                return n3;
            }
            int n4 = this.len > 0 ? this.len * 2 : 256;
            byte[] byArray = new byte[n4];
            if (this.len > 0) {
                System.arraycopy(this.buffer, 0, byArray, 0, this.len);
            }
            if ((n2 = this.inputStream.read(byArray, this.len, n4 - this.len)) <= 0) {
                this.eof = true;
                return -1;
            }
            this.buffer = byArray;
            this.len += n2;
            n = (n = this.buffer[this.pos++]) < 0 ? n + 256 : n;
            return n;
        }

        void cacheToStart() {
            this.pos = 0;
            this.eof = false;
        }

        public String toString() {
            String string = super.toString() + '[' + this.inputStream.toString() + ']' + '\n';
            string = string + new String(this.buffer);
            return string;
        }
    }
}

