/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class JarFileSystem
extends AbstractFileSystem {
    static final long serialVersionUID = -98124752801761145L;
    private static RequestProcessor req;
    private static final int REFRESH_TIME;
    private static final long MEM_STREAM_SIZE = 100000L;
    private transient JarFile jar;
    private transient Manifest manifest;
    private File root = new File(".");
    private transient RequestProcessor.Task watcherTask = null;
    private transient RequestProcessor.Task closeTask = null;
    private transient long lastModification = 0L;
    private transient Object closeSync = new Object();
    private int checkTime = REFRESH_TIME;
    private transient long aliveCount = 0L;
    private transient Cache strongCache;
    private transient Reference softCache = new SoftReference<Object>(null);
    private transient FileObject foRoot;
    private transient FileChangeListener fcl;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JarFileSystem() {
        Impl impl = new Impl(this);
        this.list = impl;
        this.info = impl;
        this.change = impl;
        this.attr = impl;
    }

    public JarFileSystem(FileSystemCapability fileSystemCapability) {
        this();
        this.setCapability(fileSystemCapability);
    }

    protected Reference createReference(FileObject fileObject) {
        ++this.aliveCount;
        if (this.checkTime > 0 && this.watcherTask == null) {
            this.watcherTask = req.post(this.watcherTask(), this.checkTime);
        }
        return new Ref(fileObject);
    }

    private void freeReference() {
        --this.aliveCount;
        if (this.aliveCount == 0L) {
            if (this.watcherTask != null) {
                this.watcherTask.cancel();
                this.watcherTask = null;
            }
            this.strongCache = null;
            this.closeCurrentRoot(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                Object object = this.closeSync;
                synchronized (object) {
                    JarFile jarFile = this.reOpenJarFile();
                    this.manifest = jarFile == null ? null : jarFile.getManifest();
                    this.manifest = this.manifest == null ? null : new Manifest(this.manifest);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.closeCurrentRoot(false);
            }
            if (this.manifest == null) {
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    public void setJarFile(File file) throws IOException, PropertyVetoException {
        this.setJarFile(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJarFile(final File file, boolean bl) throws IOException, PropertyVetoException {
        if (!file.equals(FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Parameter aRoot was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile(file));
        }
        FileObject fileObject = null;
        String string = this.getDisplayName();
        if (this.getRefreshTime() > 0) {
            this.setRefreshTime(0);
        }
        if (file == null) {
            FSException.io("EXC_NotValidFile", file);
        }
        if (!file.exists()) {
            FSException.io("EXC_FileNotExists", file.getAbsolutePath());
        }
        if (!file.canRead()) {
            FSException.io("EXC_CanntRead", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            FSException.io("EXC_NotValidFile", file.getAbsolutePath());
        }
        String string2 = file.getAbsolutePath();
        string2 = string2.intern();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string2);
        }
        catch (ZipException zipException) {
            FSException.io("EXC_NotValidJarFile2", zipException.getLocalizedMessage(), string2);
        }
        Object object = this.closeSync;
        synchronized (object) {
            this.setSystemName(string2);
            this.closeCurrentRoot(false);
            this.jar = jarFile;
            this.root = new File(string2);
            if (bl) {
                this.strongCache = null;
                this.softCache.clear();
                this.aliveCount = 0L;
                fileObject = this.refreshRoot();
                this.manifest = null;
                this.lastModification = 0L;
                if (fileObject != null) {
                    this.firePropertyChange("root", null, fileObject);
                }
            }
        }
        this.firePropertyChange("displayName", string, this.getDisplayName());
        this.foRoot = FileUtil.toFileObject(this.root);
        if (this.foRoot != null && this.fcl == null) {
            this.fcl = new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    if (JarFileSystem.this.watcherTask == null) {
                        JarFileSystem.this.parse(true);
                    }
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    File file2 = FileUtil.toFile(fileRenameEvent.getFile());
                    if (file2 != null && !file2.equals(file)) {
                        try {
                            JarFileSystem.this.setJarFile(file2, false);
                        }
                        catch (IOException iOException) {
                            ExternalUtil.exception(iOException);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            ExternalUtil.exception(propertyVetoException);
                        }
                    }
                }

                public void fileDeleted(FileEvent fileEvent) {
                    Enumeration enumeration = JarFileSystem.this.existingFileObjects(JarFileSystem.this.getRoot());
                    while (enumeration.hasMoreElements()) {
                        AbstractFolder abstractFolder = (AbstractFolder)enumeration.nextElement();
                        abstractFolder.validFlag = false;
                        abstractFolder.fileDeleted0(new FileEvent(abstractFolder));
                    }
                    JarFileSystem.this.refreshRoot();
                }
            };
            if (bl) {
                this.foRoot.addFileChangeListener(FileUtil.weakFileChangeListener(this.fcl, this.foRoot));
            }
        }
    }

    public File getJarFile() {
        return this.root;
    }

    public String getDisplayName() {
        return this.root != null ? this.root.getAbsolutePath() : JarFileSystem.getString("JAR_UnknownJar");
    }

    public boolean isReadOnly() {
        return true;
    }

    public void removeNotify() {
        this.closeCurrentRoot(true);
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        if (this.root != null) {
            environment.addClassPath(this.root.getAbsolutePath());
        }
    }

    protected String[] children(String string) {
        Cache cache = this.getCache();
        return cache.getChildrenOf(string);
    }

    protected void createFolder(String string) throws IOException {
        throw new IOException();
    }

    protected void createData(String string) throws IOException {
        throw new IOException();
    }

    protected void rename(String string, String string2) throws IOException {
        throw new IOException();
    }

    protected void delete(String string) throws IOException {
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date lastModified(String string) {
        try {
            Date date = new Date(this.getEntry(string).getTime());
            return date;
        }
        finally {
            this.closeCurrentRoot(false);
        }
    }

    protected boolean folder(String string) {
        if ("".equals(string)) {
            return true;
        }
        Cache cache = this.getCache();
        return cache.isFolder(string);
    }

    protected boolean readOnly(String string) {
        return true;
    }

    protected String mimeType(String string) {
        return null;
    }

    protected long size(String string) {
        long l = this.getEntry(string).getSize();
        this.closeCurrentRoot(false);
        return l == -1L ? 0L : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getMemInputStream(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = this.getInputStream4336753(jarFile, jarEntry);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        try {
            FileUtil.copy(inputStream, byteArrayOutputStream);
        }
        finally {
            byteArrayOutputStream.close();
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getTemporaryInputStream(JarFile jarFile, JarEntry jarEntry, boolean bl) throws IOException {
        File file;
        boolean bl2;
        String string = jarFile.getName();
        String string2 = jarEntry.getName();
        StringBuffer stringBuffer = new StringBuffer("jarfscache");
        stringBuffer.append(System.getProperty("user.name")).append("/");
        File file2 = new File(System.getProperty("java.io.tmpdir"), stringBuffer.toString());
        if (!file2.exists()) {
            file2.mkdirs();
        }
        boolean bl3 = bl2 = !(file = new File(file2, JarFileSystem.temporaryName(string, string2))).exists();
        if (bl2) {
            file.createNewFile();
        } else {
            bl |= Math.abs(System.currentTimeMillis() - file.lastModified()) > 10000L;
        }
        if (bl2 || bl) {
            InputStream inputStream = this.getInputStream4336753(jarFile, jarEntry);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    FileUtil.copy(inputStream, fileOutputStream);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            finally {
                inputStream.close();
            }
        }
        file.deleteOnExit();
        return new FileInputStream(file);
    }

    private static String temporaryName(String string, String string2) {
        String string3 = String.valueOf(string.hashCode());
        String string4 = String.valueOf(string2.hashCode());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("f").append(string3).append("e").append(string4);
        return stringBuffer.toString().replace('-', 'x');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream inputStream(String string) throws FileNotFoundException {
        InputStream inputStream = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                JarEntry jarEntry;
                JarFile jarFile = this.reOpenJarFile();
                if (jarFile != null && (jarEntry = jarFile.getJarEntry(string)) != null) {
                    inputStream = jarEntry.getSize() < 100000L ? this.getMemInputStream(jarFile, jarEntry) : this.getTemporaryInputStream(jarFile, jarEntry, this.strongCache != null);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            throw new FileNotFoundException(runtimeException.getMessage());
        }
        finally {
            this.closeCurrentRoot(false);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        return inputStream;
    }

    private InputStream getInputStream4336753(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = null;
        while (inputStream == null) {
            try {
                inputStream = jarFile.getInputStream(jarEntry);
                break;
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return inputStream;
    }

    protected OutputStream outputStream(String string) throws IOException {
        throw new IOException();
    }

    protected void lock(String string) throws IOException {
        FSException.io("EXC_CannotLock", string, this.getDisplayName(), string);
    }

    protected void unlock(String string) {
    }

    protected void markUnimportant(String string) {
    }

    protected Object readAttribute(String string, String string2) {
        Attributes attributes = this.getManifest().getAttributes(string);
        try {
            return attributes == null ? null : attributes.getValue(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected void writeAttribute(String string, String string2, Object object) throws IOException {
        throw new IOException();
    }

    protected Enumeration attributes(String string) {
        Attributes attributes = this.getManifest().getAttributes(string);
        if (attributes != null) {
            class ToString
            implements Enumerations.Processor {
                ToString() {
                }

                public Object process(Object object, Collection collection) {
                    return object.toString();
                }
            }
            return Enumerations.convert(Collections.enumeration(attributes.keySet()), (Enumerations.Processor)new ToString());
        }
        return Enumerations.empty();
    }

    protected void renameAttributes(String string, String string2) {
    }

    protected void deleteAttributes(String string) {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeCurrentRoot(false);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.closeSync = new Object();
        this.strongCache = null;
        this.softCache = new SoftReference<Object>(null);
        this.aliveCount = 0L;
        try {
            this.setJarFile(this.root);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IOException(propertyVetoException.getMessage());
        }
        catch (IOException iOException) {
            ExternalUtil.log(iOException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarFile reOpenJarFile() throws IOException {
        Object object = this.closeSync;
        synchronized (object) {
            JarFile jarFile;
            if (this.closeTask != null) {
                this.closeTask.cancel();
            }
            if ((jarFile = this.jar) != null) {
                return jarFile;
            }
            if (this.jar == null && this.root != null) {
                this.jar = new JarFile(this.root);
            }
            return this.jar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrentRoot(boolean bl) {
        Object object = this.closeSync;
        synchronized (object) {
            if (this.closeTask != null) {
                this.closeTask.cancel();
            }
            if (bl) {
                this.realClose().run();
            } else {
                this.closeTask = req.post(this.realClose(), 300);
            }
        }
    }

    private Runnable realClose() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = JarFileSystem.this.closeSync;
                synchronized (object) {
                    if (JarFileSystem.this.jar != null) {
                        try {
                            JarFileSystem.this.jar.close();
                        }
                        catch (Exception exception) {
                            ExternalUtil.exception(exception);
                        }
                        finally {
                            JarFileSystem.this.jar = null;
                            JarFileSystem.this.closeTask = null;
                        }
                    }
                }
            }
        };
    }

    private Cache getCache() {
        Cache cache = this.strongCache;
        if (cache == null) {
            cache = (Cache)this.softCache.get();
        }
        if (cache == null) {
            cache = this.parse(false);
        }
        if (!$assertionsDisabled && cache == null) {
            throw new AssertionError();
        }
        return cache;
    }

    private void refreshExistingFileObjects() {
        Cache cache = this.getCache();
        String[] stringArray = new String[]{};
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        while (enumeration.hasMoreElements()) {
            AbstractFolder abstractFolder = (AbstractFolder)enumeration.nextElement();
            if (!$assertionsDisabled && abstractFolder == null) {
                throw new AssertionError();
            }
            if (abstractFolder.isFolder() && !abstractFolder.isInitialized()) continue;
            String[] stringArray2 = cache.getChildrenOf(abstractFolder.getPath());
            if (stringArray2 == null) {
                stringArray2 = stringArray;
            }
            abstractFolder.refresh(null, null, true, true, stringArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Cache parse(boolean bl) {
        Cache cache;
        block20: {
            JarFile jarFile = null;
            this.beginAtomicAction();
            try {
                Object object = this.closeSync;
                synchronized (object) {
                    long l = System.currentTimeMillis();
                    this.lastModification = 0L;
                    this.closeCurrentRoot(false);
                    for (int i = 0; i <= 2; ++i) {
                        try {
                            jarFile = this.reOpenJarFile();
                            break;
                        }
                        catch (IOException iOException) {
                            if (i < 2) continue;
                            Cache cache2 = Cache.INVALID;
                            // MONITOREXIT @DISABLED, blocks:[0, 7, 8, 11] lbl16 : MonitorExitStatement: MONITOREXIT : var5_3
                            this.closeCurrentRoot(false);
                            if (bl) {
                                this.refreshExistingFileObjects();
                            }
                            if (this.checkTime > 0 && this.watcherTask == null) {
                                this.watcherTask = req.post(this.watcherTask(), this.checkTime);
                            }
                            this.finishAtomicAction();
                            return cache2;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                this.closeCurrentRoot(false);
                if (bl) {
                    this.refreshExistingFileObjects();
                }
                if (this.checkTime > 0 && this.watcherTask == null) {
                    this.watcherTask = req.post(this.watcherTask(), this.checkTime);
                }
                this.finishAtomicAction();
                throw throwable;
            }
            {
                try {
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    Cache cache3 = new Cache(enumeration);
                    this.lastModification = this.root.lastModified();
                    this.strongCache = cache3;
                    this.softCache = new SoftReference<Cache>(cache3);
                    cache = cache3;
                    // MONITOREXIT @DISABLED, blocks:[4, 7] lbl40 : MonitorExitStatement: MONITOREXIT : var5_3
                    this.closeCurrentRoot(false);
                    if (bl) {
                        this.refreshExistingFileObjects();
                    }
                    if (this.checkTime <= 0 || this.watcherTask != null) break block20;
                }
                catch (Throwable throwable) {
                    Cache cache4 = Cache.INVALID;
                    // MONITOREXIT @DISABLED, blocks:[7, 9] lbl48 : MonitorExitStatement: MONITOREXIT : var5_3
                    this.closeCurrentRoot(false);
                    if (bl) {
                        this.refreshExistingFileObjects();
                    }
                    if (this.checkTime > 0 && this.watcherTask == null) {
                        this.watcherTask = req.post(this.watcherTask(), this.checkTime);
                    }
                    this.finishAtomicAction();
                    return cache4;
                }
            }
            this.watcherTask = req.post(this.watcherTask(), this.checkTime);
        }
        this.finishAtomicAction();
        return cache;
    }

    private Runnable watcherTask() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (JarFileSystem.this.root == null) {
                        return;
                    }
                    if (JarFileSystem.this.root.lastModified() != JarFileSystem.this.lastModification) {
                        JarFileSystem.this.parse(true);
                    }
                }
                finally {
                    if (JarFileSystem.this.watcherTask != null) {
                        JarFileSystem.this.watcherTask.schedule(JarFileSystem.this.checkTime);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JarEntry getEntry(String string) {
        JarFile jarFile = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                jarFile = this.reOpenJarFile();
                JarEntry jarEntry = jarFile.getJarEntry(string);
                if (jarEntry != null) {
                    return jarEntry;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new JarEntry(string);
    }

    static {
        $assertionsDisabled = !JarFileSystem.class.desiredAssertionStatus();
        req = new RequestProcessor("JarFs - modification watcher");
        REFRESH_TIME = Integer.getInteger("org.openide.filesystems.JarFileSystem.REFRESH_TIME", 0);
    }

    private static class Cache {
        static Cache INVALID = new Cache(Enumerations.empty());
        byte[] names = new byte[1000];
        private int nameOffset = 0;
        int[] EMPTY = new int[0];
        private HashMap folders = new HashMap();

        public Cache(Enumeration enumeration) {
            this.parse(enumeration);
            this.trunc();
        }

        public boolean isFolder(String string) {
            return this.folders.get(string) != null;
        }

        public String[] getChildrenOf(String string) {
            Folder folder = (Folder)this.folders.get(string);
            if (folder != null) {
                return folder.getNames();
            }
            return new String[0];
        }

        private void parse(Enumeration enumeration) {
            this.folders.put("", new Folder());
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)enumeration.nextElement();
                String string = jarEntry.getName();
                boolean bl = false;
                if ((string = string.replace('\\', '/')).startsWith("/")) {
                    string = string.substring(1);
                }
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                    bl = true;
                }
                int n = string.lastIndexOf(47);
                String string2 = "";
                String string3 = string;
                if (n > 0) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
                if (bl) {
                    this.getFolder(string);
                    continue;
                }
                Folder folder = this.getFolder(string2);
                folder.addChild(string3);
            }
        }

        private Folder getFolder(String string) {
            Folder folder = (Folder)this.folders.get(string);
            if (folder == null) {
                int n = string.lastIndexOf(47);
                String string2 = "";
                String string3 = string;
                if (n > 0) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
                this.getFolder(string2).addChild(string3);
                folder = new Folder();
                this.folders.put(string, folder);
            }
            return folder;
        }

        private void trunc() {
            byte[] byArray = new byte[this.nameOffset];
            System.arraycopy(this.names, 0, byArray, 0, this.nameOffset);
            this.names = byArray;
            Iterator iterator = this.folders.values().iterator();
            while (iterator.hasNext()) {
                ((Folder)iterator.next()).trunc();
            }
        }

        private int putName(byte[] byArray) {
            int n = this.nameOffset;
            if (n + byArray.length > this.names.length) {
                byte[] byArray2 = new byte[this.names.length * 2 + byArray.length];
                System.arraycopy(this.names, 0, byArray2, 0, n);
                this.names = byArray2;
            }
            System.arraycopy(byArray, 0, this.names, n, byArray.length);
            this.nameOffset += byArray.length;
            return n;
        }

        private class Folder {
            private int[] indices;
            private int idx;

            public Folder() {
                this.indices = Cache.this.EMPTY;
                this.idx = 0;
            }

            public String[] getNames() {
                String[] stringArray = new String[this.idx / 2];
                for (int i = 0; i < stringArray.length; ++i) {
                    byte[] byArray = new byte[this.indices[2 * i + 1]];
                    System.arraycopy(Cache.this.names, this.indices[2 * i], byArray, 0, byArray.length);
                    try {
                        stringArray[i] = new String(byArray, "UTF-8");
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new InternalError("No UTF-8");
                    }
                }
                return stringArray;
            }

            void addChild(String string) {
                Object[] objectArray;
                if (this.idx + 2 > this.indices.length) {
                    objectArray = new int[2 * this.indices.length + 2];
                    System.arraycopy(this.indices, 0, objectArray, 0, this.idx);
                    this.indices = objectArray;
                }
                try {
                    objectArray = string.getBytes("UTF-8");
                    this.indices[this.idx++] = Cache.this.putName(objectArray);
                    this.indices[this.idx++] = objectArray.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InternalError("No UTF-8");
                }
            }

            void trunc() {
                if (this.indices.length > this.idx) {
                    int[] nArray = new int[this.idx];
                    System.arraycopy(this.indices, 0, nArray, 0, this.idx);
                    this.indices = nArray;
                }
            }
        }
    }

    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change,
    AbstractFileSystem.Attr {
        static final long serialVersionUID = -67233308132567232L;
        private JarFileSystem fs;

        public Impl(JarFileSystem jarFileSystem) {
            this.fs = jarFileSystem;
        }

        public String[] children(String string) {
            return this.fs.children(string);
        }

        public void createFolder(String string) throws IOException {
            this.fs.createFolder(string);
        }

        public void createData(String string) throws IOException {
            this.fs.createData(string);
        }

        public void rename(String string, String string2) throws IOException {
            this.fs.rename(string, string2);
        }

        public void delete(String string) throws IOException {
            this.fs.delete(string);
        }

        public Date lastModified(String string) {
            return this.fs.lastModified(string);
        }

        public boolean folder(String string) {
            return this.fs.folder(string);
        }

        public boolean readOnly(String string) {
            return this.fs.readOnly(string);
        }

        public String mimeType(String string) {
            return this.fs.mimeType(string);
        }

        public long size(String string) {
            return this.fs.size(string);
        }

        public InputStream inputStream(String string) throws FileNotFoundException {
            return this.fs.inputStream(string);
        }

        public OutputStream outputStream(String string) throws IOException {
            return this.fs.outputStream(string);
        }

        public void lock(String string) throws IOException {
            this.fs.lock(string);
        }

        public void unlock(String string) {
            this.fs.unlock(string);
        }

        public void markUnimportant(String string) {
            this.fs.markUnimportant(string);
        }

        public Object readAttribute(String string, String string2) {
            return this.fs.readAttribute(string, string2);
        }

        public void writeAttribute(String string, String string2, Object object) throws IOException {
            this.fs.writeAttribute(string, string2, object);
        }

        public Enumeration attributes(String string) {
            return this.fs.attributes(string);
        }

        public void renameAttributes(String string, String string2) {
            this.fs.renameAttributes(string, string2);
        }

        public void deleteAttributes(String string) {
            this.fs.deleteAttributes(string);
        }
    }

    private class Ref
    extends WeakReference
    implements Runnable {
        public Ref(FileObject fileObject) {
            super(fileObject, Utilities.activeReferenceQueue());
        }

        public void run() {
            JarFileSystem.this.freeReference();
        }
    }
}

