/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.EventObject;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class FileEvent
extends EventObject {
    private static final long serialVersionUID = 1028087432345400108L;
    private FileObject file;
    private long time;
    private boolean expected;
    private EventControl.AtomicActionLink atomActionID;

    public FileEvent(FileObject fileObject) {
        this(fileObject, fileObject);
    }

    public FileEvent(FileObject fileObject, FileObject fileObject2) {
        super(fileObject);
        this.file = fileObject2;
        this.time = System.currentTimeMillis();
    }

    FileEvent(FileObject fileObject, FileObject fileObject2, long l) {
        this(fileObject, fileObject2);
        this.time = l;
    }

    public FileEvent(FileObject fileObject, FileObject fileObject2, boolean bl) {
        this(fileObject, fileObject2);
        this.expected = bl;
    }

    public final FileObject getFile() {
        return this.file;
    }

    public final long getTime() {
        return this.time;
    }

    public final boolean isExpected() {
        return this.expected;
    }

    public String toString() {
        return super.toString() + "[file=" + this.file + ",time=" + this.time + ",expected=" + this.expected + "]";
    }

    void setAtomicActionLink(EventControl.AtomicActionLink atomicActionLink) {
        this.atomActionID = atomicActionLink;
    }

    public boolean firedFrom(FileSystem.AtomicAction atomicAction) {
        if (atomicAction == null) {
            return false;
        }
        for (EventControl.AtomicActionLink atomicActionLink = this.atomActionID; atomicActionLink != null; atomicActionLink = atomicActionLink.getPreviousLink()) {
            if (!atomicAction.equals(atomicActionLink.getAtomicAction())) continue;
            return true;
        }
        return false;
    }
}

