/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.StreamPool;
import org.openide.util.Enumerations;

final class AbstractFileObject
extends AbstractFolder {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    private Reference lock;
    private Boolean folder;
    private Date lastModified = this.lastModified();

    public AbstractFileObject(AbstractFileSystem abstractFileSystem, AbstractFileObject abstractFileObject, String string) {
        super(abstractFileSystem, abstractFileObject, string);
    }

    private AbstractFileSystem getAbstractFileSystem() {
        return (AbstractFileSystem)this.getFileSystem();
    }

    private AbstractFileObject getAbstractChild(String string) {
        return (AbstractFileObject)this.getChild(string);
    }

    protected final String[] list() {
        return this.getAbstractFileSystem().list.children(this.getPath());
    }

    protected final AbstractFolder createFile(String string) {
        return this.getAbstractFileSystem().createFileObject(this, string);
    }

    public boolean isFolder() {
        if (this.folder == null) {
            if (this.parent == null || this.getAbstractFileSystem().info.folder(this.getPath())) {
                this.folder = Boolean.TRUE;
                return true;
            }
            this.folder = Boolean.FALSE;
            return false;
        }
        return this.folder;
    }

    public final boolean isData() {
        return !this.isFolder();
    }

    public Date lastModified() {
        if (this.lastModified == null || !this.getAbstractFileSystem().isLastModifiedCacheEnabled()) {
            this.lastModified = this.getAbstractFileSystem().info.lastModified(this.getPath());
        }
        return this.lastModified;
    }

    public boolean isReadOnly() {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        return abstractFileSystem.isReadOnly() || abstractFileSystem.info.readOnly(this.getPath());
    }

    public String getMIMEType() {
        String string = this.getAbstractFileSystem().info.mimeType(this.getPath());
        if (string == null) {
            string = FileUtil.getMIMETypeOrDefault(this);
        }
        return string;
    }

    public long getSize() {
        return this.getAbstractFileSystem().info.size(this.getPath());
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return StreamPool.createInputStream(this);
    }

    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        return this.getOutputStream(fileLock, true);
    }

    synchronized OutputStream getOutputStream(FileLock fileLock, boolean bl) throws IOException {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        if (abstractFileSystem.isReadOnly()) {
            FSException.io("EXC_FSisRO", ((FileSystem)abstractFileSystem).getDisplayName());
        }
        if (this.isReadOnly()) {
            FSException.io("EXC_FisRO", this.name, ((FileSystem)abstractFileSystem).getDisplayName());
        }
        this.testLock(fileLock);
        return StreamPool.createOutputStream(this, bl);
    }

    public synchronized FileLock lock() throws IOException {
        FileLock fileLock;
        if (this.lock != null && (fileLock = (FileLock)this.lock.get()) != null) {
            throw new FileAlreadyLockedException();
        }
        this.getAbstractFileSystem().info.lock(this.getPath());
        fileLock = new AfLock();
        this.lock = new WeakReference<FileLock>(fileLock);
        return fileLock;
    }

    synchronized void unlock(FileLock fileLock) {
        FileLock fileLock2 = null;
        if (this.lock != null) {
            fileLock2 = (FileLock)this.lock.get();
        }
        if (fileLock2 == fileLock) {
            this.getAbstractFileSystem().info.unlock(this.getPath());
            this.lastModified = null;
            if (this.isValid()) {
                this.lastModified();
            }
            this.lock = null;
        }
    }

    private void testLock(FileLock fileLock) throws IOException {
        if (this.lock == null) {
            FSException.io("EXC_InvalidLock", fileLock, this.getPath(), this.getAbstractFileSystem().getDisplayName(), this.lock);
        }
        if (this.lock.get() != fileLock) {
            FSException.io("EXC_InvalidLock", fileLock, this.getPath(), this.getAbstractFileSystem().getDisplayName(), this.lock.get());
        }
    }

    public void setImportant(boolean bl) {
        this.getAbstractFileSystem().markImportant(this.getPath(), bl);
    }

    public Object getAttribute(String string) {
        return this.getAttribute(string, this.getPath());
    }

    final Object getAttribute(String string, String string2) {
        return this.getAbstractFileSystem().attr.readAttribute(string2, string);
    }

    public void setAttribute(String string, Object object) throws IOException {
        this.setAttribute(string, object, true);
    }

    void setAttribute(String string, Object object, boolean bl) throws IOException {
        Object object2 = null;
        if (bl) {
            object2 = this.getAttribute(string);
        }
        this.getAbstractFileSystem().attr.writeAttribute(this.getPath(), string, object);
        if (bl && object2 != object && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent(this, string, object2, object));
        }
    }

    public Enumeration getAttributes() {
        return this.getAttributes(this.getPath());
    }

    final Enumeration getAttributes(String string) {
        return this.getAbstractFileSystem().attr.attributes(string);
    }

    protected final Reference createReference(FileObject fileObject) {
        return this.getAbstractFileSystem().createReference(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createFolder(String string) throws IOException {
        AbstractFileObject abstractFileObject;
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject2 = this;
            synchronized (abstractFileObject2) {
                AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
                if (abstractFileSystem.isReadOnly()) {
                    FSException.io("EXC_FSisRO", abstractFileSystem.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", string, abstractFileSystem.getDisplayName());
                }
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", string, this.getPath(), abstractFileSystem.getDisplayName());
                }
                this.getAbstractFileSystem().change.createFolder(this.getPath() + '/' + string);
                this.registerChild(string);
                abstractFileObject = this.getAbstractChild(string);
                if (abstractFileObject == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.getPath(), string));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, abstractFileObject), false);
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
        return abstractFileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createData(String string, String string2) throws IOException {
        if (string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Use FileUtil.createData() instead!");
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject = this;
            synchronized (abstractFileObject) {
                String string3;
                AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
                if (abstractFileSystem.isReadOnly()) {
                    FSException.io("EXC_FSisRO", abstractFileSystem.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", string, abstractFileSystem.getDisplayName());
                }
                String string4 = string3 = string2 == null || "".equals(string2) ? string : string + '.' + string2;
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", string3, this.getPath(), abstractFileSystem.getDisplayName());
                }
                this.getAbstractFileSystem().change.createData(this.getPath() + '/' + string3);
                this.registerChild(string3);
                AbstractFileObject abstractFileObject2 = this.getAbstractChild(string3);
                if (abstractFileObject2 == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.getPath(), string3));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, abstractFileObject2), true);
                }
                AbstractFileObject abstractFileObject3 = abstractFileObject2;
                return abstractFileObject3;
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(FileLock fileLock, String string, String string2) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotRenameRoot", this.getAbstractFileSystem().getDisplayName());
        }
        if (string.indexOf(47) != -1 || string2 != null && string2.indexOf(47) != -1 || string.indexOf(92) != -1 || string2 != null && string2.indexOf(92) != -1) {
            FSException.io("EXC_CannotRename", this.getPath(), this.getAbstractFileSystem().getDisplayName(), string + "." + string2);
        }
        try {
            this.getFileSystem().beginAtomicAction();
            String string3 = null;
            String string4 = null;
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(fileLock);
                if (this.isData() && string2 != null) {
                    string = string + '.' + string2;
                }
                string3 = this.parent.isRoot() ? string : this.parent.getPath() + '/' + string;
                string4 = this.getPath();
                if (this.isReadOnly()) {
                    FSException.io("EXC_CannotRename", this.getPath(), this.getAbstractFileSystem().getDisplayName(), string3);
                }
                if (this.getFileSystem().isReadOnly()) {
                    FSException.io("EXC_FSisRO", this.getAbstractFileSystem().getDisplayName());
                }
                String string5 = this.getName();
                String string6 = this.getExt();
                this.getAbstractFileSystem().change.rename(string4, string3);
                String string7 = this.name;
                this.name = string;
                this.parent.refresh(string, string7);
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, string5, string6));
                }
            }
            this.getAbstractFileSystem().attr.renameAttributes(string4, string3);
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDelete(FileLock fileLock) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", this.getAbstractFileSystem().getDisplayName());
        }
        try {
            String string;
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(fileLock);
                string = this.getPath();
                try {
                    this.getAbstractFileSystem().change.delete(string);
                }
                catch (IOException iOException) {
                    StreamPool streamPool = StreamPool.find(this);
                    if (streamPool != null) {
                        streamPool.annotate(iOException);
                    }
                    throw iOException;
                }
                String string2 = this.name;
                this.validFlag = false;
                this.parent.refresh(null, string2, true);
            }
            this.getAbstractFileSystem().attr.deleteAttributes(string);
            if (this.hasAtLeastOneListeners()) {
                this.fileDeleted0(new FileEvent(this));
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        AbstractFileSystem.Transfer transfer = this.getAbstractFileSystem().transfer;
        if (transfer == null || !(fileObject instanceof AbstractFileObject)) {
            return super.copy(fileObject, string, string2);
        }
        AbstractFileObject abstractFileObject = (AbstractFileObject)fileObject;
        AbstractFileSystem abstractFileSystem = abstractFileObject.getAbstractFileSystem();
        AbstractFileSystem.Transfer transfer2 = abstractFileSystem.transfer;
        if (transfer2 != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFileObject abstractFileObject2 = abstractFileObject;
                synchronized (abstractFileObject2) {
                    block14: {
                        String string3;
                        if (abstractFileSystem.isReadOnly()) {
                            FSException.io("EXC_FSisRO", abstractFileSystem.getDisplayName());
                        }
                        if (!fileObject.canWrite()) {
                            FSException.io("EXC_FisRO", fileObject.getPath(), abstractFileSystem.getDisplayName());
                        }
                        String string4 = string3 = "".equals(string2) ? string : string + '.' + string2;
                        if (!transfer.copy(this.getPath(), transfer2, fileObject.getPath() + '/' + string3)) break block14;
                        abstractFileObject.registerChild(string3);
                        AbstractFileObject abstractFileObject3 = abstractFileObject.getAbstractChild(string3);
                        if (abstractFileObject3 == null) {
                            throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", abstractFileObject.getPath(), string3));
                        }
                        if (abstractFileObject.hasListeners()) {
                            abstractFileObject.fileCreated0(new FileEvent(abstractFileObject, abstractFileObject3), true);
                        }
                        AbstractFileObject abstractFileObject4 = abstractFileObject3;
                        return abstractFileObject4;
                    }
                }
            }
            finally {
                this.getFileSystem().finishAtomicAction();
            }
        }
        return super.copy(fileObject, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        AbstractFileSystem.Transfer transfer;
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", abstractFileSystem.getDisplayName());
        }
        if ((transfer = this.getAbstractFileSystem().transfer) == null || !(fileObject instanceof AbstractFileObject)) {
            return super.move(fileLock, fileObject, string, string2);
        }
        AbstractFileObject abstractFileObject = (AbstractFileObject)fileObject;
        AbstractFileSystem abstractFileSystem2 = abstractFileObject.getAbstractFileSystem();
        AbstractFileSystem.Transfer transfer2 = abstractFileSystem2.transfer;
        if (transfer2 != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFolder abstractFolder = this.parent;
                synchronized (abstractFolder) {
                    block16: {
                        this.testLock(fileLock);
                        if (abstractFileSystem2.isReadOnly()) {
                            FSException.io("EXC_FSisRO", abstractFileSystem2.getDisplayName());
                        }
                        if (!fileObject.canWrite()) {
                            FSException.io("EXC_FisRO", fileObject.getPath(), abstractFileSystem2.getDisplayName());
                        }
                        String string3 = "".equals(string2) ? string : string + '.' + string2;
                        String string4 = this.getPath();
                        if (!transfer.move(string4, transfer2, fileObject.getPath() + '/' + string3)) break block16;
                        String string5 = string;
                        this.validFlag = false;
                        this.parent.refresh(null, string5);
                        abstractFileObject.registerChild(string3);
                        AbstractFileObject abstractFileObject2 = abstractFileObject.getAbstractChild(string3);
                        if (abstractFileObject2 == null) {
                            throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", abstractFileObject.getPath(), string3));
                        }
                        if (this.hasAtLeastOneListeners()) {
                            this.fileDeleted0(new FileEvent(this));
                        }
                        if (abstractFileObject.hasListeners()) {
                            abstractFileObject.fileCreated0(new FileEvent(abstractFileObject, abstractFileObject2), true);
                        }
                        AbstractFileObject abstractFileObject3 = abstractFileObject2;
                        return abstractFileObject3;
                    }
                }
            }
            finally {
                this.getFileSystem().finishAtomicAction();
            }
        }
        return super.move(fileLock, fileObject, string, string2);
    }

    public boolean isVirtual() {
        return this.getAbstractFileSystem().checkVirtual(this.getPath());
    }

    protected void refresh(String string, String string2, boolean bl, boolean bl2) {
        this.refresh(string, string2, bl, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(String string, String string2, boolean bl, boolean bl2, String[] stringArray) {
        FileEvent fileEvent = null;
        boolean bl3 = false;
        try {
            this.getFileSystem().beginAtomicAction();
            if (this.isFolder()) {
                super.refresh(string, string2, bl, bl2, stringArray);
            } else {
                StreamPool streamPool = StreamPool.find(this);
                if (streamPool != null && streamPool.isOutputStreamOpen()) {
                    return;
                }
                AbstractFileObject abstractFileObject = this;
                synchronized (abstractFileObject) {
                    Date date;
                    block20: {
                        date = null;
                        if (this.lastModified != null) break block20;
                        this.lastModified = date = this.getAbstractFileSystem().info.lastModified(this.getPath());
                        return;
                    }
                    date = this.getAbstractFileSystem().info.lastModified(this.getPath());
                    if (Math.abs(this.lastModified.getTime() - date.getTime()) != 0L) {
                        this.lastModified = date;
                        if (bl && this.hasAtLeastOneListeners()) {
                            fileEvent = new FileEvent((FileObject)this, (FileObject)this, bl2);
                        }
                        if (date.getTime() == 0L) {
                            if (this.validFlag) {
                                this.validFlag = false;
                                if (fileEvent != null) {
                                    this.fileDeleted0(fileEvent);
                                }
                                bl3 = true;
                            }
                        } else if (fileEvent != null) {
                            this.fileChanged0(fileEvent);
                        }
                    }
                }
            }
            if (bl3 && this.parent.getFileObject(this.getName(), this.getExt()) != null) {
                this.parent.refreshFolder(null, this.getNameExt(), bl, bl2, null);
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputStreamClosed(boolean bl) {
        AbstractFileObject abstractFileObject = this;
        synchronized (abstractFileObject) {
            this.lastModified = null;
            this.lastModified();
        }
        super.outputStreamClosed(bl);
    }

    public boolean canWrite() {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        return abstractFileSystem.canWrite(this.getPath());
    }

    public boolean canRead() {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        return abstractFileSystem.canRead(this.getPath());
    }

    final boolean superCanWrite() {
        return super.canWrite();
    }

    final boolean superCanRead() {
        return super.canRead();
    }

    private class AfLock
    extends FileLock {
        AfLock() {
        }

        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                AbstractFileObject.this.unlock(this);
            }
        }
    }

    static final class Invalid
    extends FileObject {
        static final long serialVersionUID = -4558997829579415276L;
        private static final Invalid ROOT = new Invalid("");
        private String name;
        private String fileSystemName;

        public Invalid(String string) {
            int n = string.lastIndexOf(47) + 1;
            this.name = n == 0 || n == string.length() ? string : string.substring(n);
        }

        public Invalid(String string, String string2) {
            this(string2);
            this.fileSystemName = string;
        }

        public String getName() {
            int n = this.name.lastIndexOf(46);
            return n <= 0 ? this.name : this.name.substring(0, n);
        }

        public String getExt() {
            int n = this.name.lastIndexOf(46) + 1;
            return n <= 1 || n == this.name.length() ? "" : this.name.substring(n);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            throw new FileStateInvalidException(null, this.name + "[" + this.fileSystemName + "]");
        }

        public boolean isRoot() {
            return this == ROOT;
        }

        public boolean isFolder() {
            return this == ROOT;
        }

        public Date lastModified() {
            return new Date();
        }

        public boolean isData() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public boolean isValid() {
            return false;
        }

        public String getMIMEType() {
            return "content/unknown";
        }

        public long getSize() {
            return 0L;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        public synchronized OutputStream getOutputStream(FileLock fileLock) throws IOException {
            throw new IOException();
        }

        public synchronized FileLock lock() throws IOException {
            throw new IOException();
        }

        public void setImportant(boolean bl) {
        }

        public Object getAttribute(String string) {
            return null;
        }

        public void setAttribute(String string, Object object) throws IOException {
            throw new IOException();
        }

        public Enumeration getAttributes() {
            return Enumerations.empty();
        }

        public synchronized FileObject createFolder(String string) throws IOException {
            throw new IOException();
        }

        public synchronized FileObject createData(String string, String string2) throws IOException {
            throw new IOException();
        }

        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            throw new IOException();
        }

        public void delete(FileLock fileLock) throws IOException {
            throw new IOException();
        }

        public FileObject getParent() {
            return this == ROOT ? null : ROOT;
        }

        public synchronized FileObject[] getChildren() {
            return new FileObject[0];
        }

        public synchronized FileObject getFileObject(String string, String string2) {
            return null;
        }

        public void refresh() {
        }

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        }
    }

    static final class Replace
    implements Serializable {
        static final long serialVersionUID = -8543432135435542113L;
        private String fsName;
        private String fileName;

        public Replace(String string, String string2) {
            this.fsName = string;
            this.fileName = string2;
        }

        public Object readResolve() {
            Repository repository = ExternalUtil.getRepository();
            FileSystem fileSystem = repository.findFileSystem(this.fsName);
            FileObject fileObject = null;
            if (fileSystem != null) {
                fileObject = fileSystem.findResource(this.fileName);
            }
            if (fileObject == null) {
                return new Invalid(this.fsName, this.fileName);
            }
            return fileObject;
        }
    }
}

