/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.module.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.netbeans.progress.module.InternalHandle;
import org.netbeans.progress.module.ui.ListComponent;

public class PopupPane
extends JScrollPane {
    private JPanel view;
    private HashSet listComponents = new HashSet();
    private ListComponent selected;

    public PopupPane() {
        this.view = new JPanel();
        GridLayout gridLayout = new GridLayout(0, 1);
        gridLayout.setHgap(0);
        gridLayout.setVgap(0);
        this.view.setLayout(gridLayout);
        this.view.setBorder(BorderFactory.createEmptyBorder());
        this.setName("progresspopup");
        this.setVerticalScrollBarPolicy(20);
        this.setViewportView(this.view);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        MoveDownAction moveDownAction = new MoveDownAction();
        this.getActionMap().put("Move-Down", moveDownAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "Move-Down");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0), "Move-Down");
        MoveUpAction moveUpAction = new MoveUpAction();
        this.getActionMap().put("Move-Up", moveUpAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "Move-Up");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0), "Move-Up");
        CancelAction cancelAction = new CancelAction();
        this.getActionMap().put("Cancel-Task", cancelAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "Cancel-Task");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "Cancel-Task");
        SelectAction selectAction = new SelectAction();
        this.getActionMap().put("select-task", selectAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "select-task");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(32, 0), "select-task");
        this.setHorizontalScrollBarPolicy(31);
    }

    public void addListComponent(ListComponent listComponent) {
        this.listComponents.add(listComponent);
        if (this.view.getComponentCount() > 0) {
            JComponent jComponent = (JComponent)this.view.getComponent(this.view.getComponentCount() - 1);
            jComponent.setBorder(new BottomLineBorder());
        }
        listComponent.setBorder(BorderFactory.createEmptyBorder());
        this.view.add(listComponent);
        if (this.listComponents.size() > 3) {
            this.setVerticalScrollBarPolicy(22);
        } else {
            this.setVerticalScrollBarPolicy(21);
        }
    }

    public void removeListComponent(InternalHandle internalHandle) {
        Iterator iterator = this.listComponents.iterator();
        while (iterator.hasNext()) {
            ListComponent listComponent = (ListComponent)iterator.next();
            if (listComponent.getHandle() != internalHandle) continue;
            this.view.remove(listComponent);
            iterator.remove();
            break;
        }
        if (this.listComponents.size() > 3) {
            this.setVerticalScrollBarPolicy(22);
        } else {
            this.setVerticalScrollBarPolicy(21);
        }
    }

    public Dimension getPreferredSize() {
        int n = this.view.getComponentCount();
        int n2 = n > 0 ? this.view.getComponent((int)0).getPreferredSize().height : 0;
        int n3 = n > 3 ? n2 * 3 + 5 : n * n2 + 5;
        return new Dimension(n > 3 ? 422 : 402, n3);
    }

    public void updateBoldFont(InternalHandle internalHandle) {
        Iterator iterator = this.listComponents.iterator();
        while (iterator.hasNext()) {
            ListComponent listComponent;
            listComponent.markAsActive(internalHandle == (listComponent = (ListComponent)iterator.next()).getHandle());
        }
    }

    private int findIndex(Component component) {
        Component[] componentArray = this.view.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] != component) continue;
            return i;
        }
        return -1;
    }

    public void requestFocus() {
        super.requestFocus();
    }

    private static class BottomLineBorder
    implements Border {
        private Insets ins = new Insets(0, 0, 1, 0);
        private Color col = new Color(221, 229, 248);

        public Insets getBorderInsets(Component component) {
            return this.ins;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.col);
            graphics.drawRect(n, n2 + n4 - 2, n3, 1);
            graphics.setColor(color);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (PopupPane.this.selected != null) {
                Action action = PopupPane.this.selected.getCancelAction();
                if (action != null) {
                    action.actionPerformed(actionEvent);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        MoveDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            if (PopupPane.this.selected != null) {
                n = PopupPane.this.findIndex(PopupPane.this.selected);
            }
            if (++n >= PopupPane.this.view.getComponentCount()) {
                n = 0;
            }
            PopupPane.this.selected = (ListComponent)PopupPane.this.view.getComponent(n);
            PopupPane.this.selected.requestFocus();
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        MoveUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PopupPane.this.view.getComponentCount();
            if (PopupPane.this.selected != null) {
                n = PopupPane.this.findIndex(PopupPane.this.selected);
            }
            if (--n < 0) {
                n = PopupPane.this.view.getComponentCount() - 1;
            }
            PopupPane.this.selected = (ListComponent)PopupPane.this.view.getComponent(n);
            PopupPane.this.selected.requestFocus();
        }
    }

    private class SelectAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (PopupPane.this.selected != null) {
                PopupPane.this.selected.getHandle().requestExplicitSelection();
            }
        }
    }

    private class ViewAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (PopupPane.this.selected != null) {
                PopupPane.this.selected.getHandle().requestView();
            }
        }
    }
}

