/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.module.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.netbeans.progress.module.InternalHandle;
import org.netbeans.progress.module.ProgressEvent;
import org.netbeans.progress.module.ProgressUIWorker;
import org.netbeans.progress.module.ui.StatusLineComponent;

public class NbProgressBar
extends JProgressBar
implements ProgressUIWorker {
    boolean isSetup = false;
    boolean usedInStatusBar = false;

    public NbProgressBar() {
        Color color;
        this.setOrientation(0);
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        Color color2 = UIManager.getColor("nbProgressBar.Foreground");
        if (color2 != null) {
            this.setForeground(color2);
        }
        if ((color = UIManager.getColor("nbProgressBar.Background")) != null) {
            this.setBackground(color);
        }
    }

    public void setUseInStatusBar(boolean bl) {
        this.usedInStatusBar = bl;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.usedInStatusBar) {
            dimension.width = 133;
        }
        return dimension;
    }

    public void processProgressEvent(ProgressEvent progressEvent) {
        if (progressEvent.getType() == 0 || !this.isSetup || progressEvent.isSwitched()) {
            NbProgressBar.setupBar(progressEvent.getSource(), this);
            this.isSetup = true;
        }
        if (progressEvent.getType() == 1) {
            if (progressEvent.getWorkunitsDone() > 0) {
                this.setValue(progressEvent.getWorkunitsDone());
            }
            this.setString(StatusLineComponent.getBarString(progressEvent.getPercentageDone(), progressEvent.getEstimatedCompletion()));
        } else if (progressEvent.getType() == 4) {
            boolean bl = this.isIndeterminate();
            this.setIndeterminate(false);
            this.setMaximum(progressEvent.getSource().getTotalUnits());
            this.setValue(progressEvent.getSource().getTotalUnits());
            if (bl) {
                this.setStringPainted(false);
            } else {
                this.setString(StatusLineComponent.getBarString(100, -1L));
            }
        }
    }

    public void processSelectedProgressEvent(ProgressEvent progressEvent) {
    }

    static void setupBar(InternalHandle internalHandle, NbProgressBar nbProgressBar) {
        int n = internalHandle.getTotalUnits();
        if (n < 1) {
            nbProgressBar.setValue(nbProgressBar.getMaximum());
            nbProgressBar.setIndeterminate(true);
            nbProgressBar.setStringPainted(false);
        } else {
            nbProgressBar.setStringPainted(true);
            nbProgressBar.setIndeterminate(false);
            nbProgressBar.setMaximum(n);
            nbProgressBar.setMinimum(0);
            nbProgressBar.setValue(0);
        }
        nbProgressBar.setString(" ");
    }
}

