/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.module;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.progress.module.InternalHandle;
import org.netbeans.progress.module.ProgressEvent;
import org.netbeans.progress.module.ProgressUIWorker;
import org.netbeans.progress.module.TaskModel;
import org.netbeans.progress.module.ui.StatusLineComponent;

public class Controller
implements Runnable,
ActionListener {
    public static Controller defaultInstance;
    private ProgressUIWorker component;
    private TaskModel model;
    private List eventQueue;
    private boolean dispatchRunning;
    protected Timer timer;
    private long timerStart = 0L;
    private static final int TIMER_QUANTUM = 400;
    public static final int INITIAL_DELAY = 500;

    public Controller(ProgressUIWorker progressUIWorker) {
        this.component = progressUIWorker;
        this.model = new TaskModel();
        this.eventQueue = new ArrayList();
        this.dispatchRunning = false;
        this.timer = new Timer(400, this);
        this.timer.setRepeats(false);
    }

    public static synchronized Controller getDefault() {
        if (defaultInstance == null) {
            StatusLineComponent statusLineComponent = new StatusLineComponent();
            defaultInstance = new Controller(statusLineComponent);
            statusLineComponent.setModel(defaultInstance.getModel());
        }
        return defaultInstance;
    }

    Component getVisualComponent() {
        if (this.component instanceof Component) {
            return (Component)((Object)this.component);
        }
        return null;
    }

    public TaskModel getModel() {
        return this.model;
    }

    void start(InternalHandle internalHandle) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, 0, this.isWatched(internalHandle));
        if (this == Controller.getDefault() && internalHandle.getInitialDelay() > 100) {
            this.postEvent(progressEvent, true);
        } else {
            this.runImmediately(Collections.singleton(progressEvent));
        }
    }

    void finish(InternalHandle internalHandle) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, 4, this.isWatched(internalHandle));
        this.postEvent(progressEvent);
    }

    void toIndeterminate(InternalHandle internalHandle) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, 5, this.isWatched(internalHandle));
        this.postEvent(progressEvent);
    }

    void toDeterminate(InternalHandle internalHandle) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, 5, this.isWatched(internalHandle));
        this.postEvent(progressEvent);
    }

    void progress(InternalHandle internalHandle, String string, int n, int n2, long l) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, string, n, n2, l, this.isWatched(internalHandle));
        this.postEvent(progressEvent);
    }

    ProgressEvent snapshot(InternalHandle internalHandle, String string, int n, int n2, long l) {
        return new ProgressEvent(internalHandle, string, n, n2, l, this.isWatched(internalHandle));
    }

    void explicitSelection(InternalHandle internalHandle, int n, int n2, long l) {
        InternalHandle internalHandle2 = this.model.getExplicitSelection();
        this.model.explicitlySelect(internalHandle);
        ArrayList<ProgressEvent> arrayList = new ArrayList<ProgressEvent>();
        arrayList.add(new ProgressEvent(internalHandle, null, n, n2, l, this.isWatched(internalHandle)));
        if (internalHandle2 != null && internalHandle2 != internalHandle) {
            arrayList.add(internalHandle2.requestStateSnapshot());
        }
        this.runImmediately(arrayList);
    }

    void displayNameChange(InternalHandle internalHandle, int n, int n2, long l, String string) {
        ArrayList<ProgressEvent> arrayList = new ArrayList<ProgressEvent>();
        arrayList.add(new ProgressEvent(internalHandle, null, n, n2, l, this.isWatched(internalHandle), string));
        this.runImmediately(arrayList);
    }

    private boolean isWatched(InternalHandle internalHandle) {
        return this.model.getExplicitSelection() == internalHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runImmediately(Collection collection) {
        Controller controller = this;
        synchronized (controller) {
            this.eventQueue.addAll(collection);
            this.dispatchRunning = true;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    void postEvent(ProgressEvent progressEvent) {
        this.postEvent(progressEvent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postEvent(ProgressEvent progressEvent, boolean bl) {
        Controller controller = this;
        synchronized (controller) {
            this.eventQueue.add(progressEvent);
            if (!this.dispatchRunning) {
                this.timerStart = System.currentTimeMillis();
                int n = this.timer.getInitialDelay();
                if (bl && this.timer.getInitialDelay() > progressEvent.getSource().getInitialDelay()) {
                    n = progressEvent.getSource().getInitialDelay();
                }
                this.dispatchRunning = true;
                this.resetTimer(n, true);
            } else if (bl && System.currentTimeMillis() - this.timerStart > (long)progressEvent.getSource().getInitialDelay()) {
                this.resetTimer(progressEvent.getSource().getInitialDelay(), true);
            }
        }
    }

    protected void resetTimer(int n, boolean bl) {
        this.timer.setInitialDelay(n);
        if (bl) {
            this.timer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Iterator<Object> iterator;
        HashMap<InternalHandle, Object> hashMap = new HashMap<InternalHandle, Object>();
        boolean bl = false;
        long l = 400L;
        InternalHandle internalHandle = this.model.getSelectedHandle();
        long l2 = System.currentTimeMillis();
        Object object2 = this;
        synchronized (object2) {
            Object object3;
            iterator = this.eventQueue.iterator();
            object = new ArrayList<InternalHandle>();
            while (iterator.hasNext()) {
                boolean bl2;
                object3 = (ProgressEvent)iterator.next();
                boolean bl3 = bl2 = l2 - ((ProgressEvent)object3).getSource().getTimeStampStarted() < (long)((ProgressEvent)object3).getSource().getInitialDelay();
                if (((ProgressEvent)object3).getType() == 0) {
                    if (((ProgressEvent)object3).getSource().isCustomPlaced() || !bl2) {
                        this.model.addHandle(((ProgressEvent)object3).getSource());
                    } else {
                        object.add(((ProgressEvent)object3).getSource());
                    }
                } else if (((ProgressEvent)object3).getType() == 4 && !object.contains(((ProgressEvent)object3).getSource())) {
                    this.model.removeHandle(((ProgressEvent)object3).getSource());
                }
                ProgressEvent progressEvent = (ProgressEvent)hashMap.get(((ProgressEvent)object3).getSource());
                if (progressEvent != null && ((ProgressEvent)object3).getType() == 4 && object.contains(((ProgressEvent)object3).getSource()) && bl2) {
                    hashMap.remove(((ProgressEvent)object3).getSource());
                    object.remove(((ProgressEvent)object3).getSource());
                } else {
                    if (progressEvent != null) {
                        ((ProgressEvent)object3).copyMessageFromEarlier(progressEvent);
                        if (progressEvent.isSwitched()) {
                            ((ProgressEvent)object3).markAsSwitched();
                        }
                    }
                    hashMap.put(((ProgressEvent)object3).getSource(), object3);
                }
                iterator.remove();
            }
            object3 = object.iterator();
            while (object3.hasNext()) {
                InternalHandle internalHandle2 = (InternalHandle)object3.next();
                long l3 = l2 - internalHandle2.getTimeStampStarted();
                if (l3 >= (long)internalHandle2.getInitialDelay()) {
                    this.model.addHandle(internalHandle2);
                    continue;
                }
                this.eventQueue.add(new ProgressEvent(internalHandle2, 0, this.isWatched(internalHandle2)));
                ProgressEvent progressEvent = (ProgressEvent)hashMap.remove(internalHandle2);
                if (progressEvent.getType() != 0) {
                    this.eventQueue.add(progressEvent);
                }
                bl = true;
                l = Math.min(l, (long)internalHandle2.getInitialDelay() - l3);
            }
        }
        object2 = this.model.getSelectedHandle();
        object2 = object2 == null ? internalHandle : object2;
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            object = (ProgressEvent)iterator.next();
            if (object2 == ((ProgressEvent)object).getSource()) {
                this.component.processSelectedProgressEvent((ProgressEvent)object);
            }
            this.component.processProgressEvent((ProgressEvent)object);
        }
        object = this;
        synchronized (object) {
            this.timer.stop();
            if (bl) {
                this.timerStart = System.currentTimeMillis();
                this.resetTimer((int)Math.max(100L, l), true);
            } else {
                this.dispatchRunning = false;
                this.resetTimer(400, false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.run();
    }
}

