/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.NbProblemDisplayer;
import org.netbeans.modules.autoupdate.catalog.ModuleEnableDisablePanel;
import org.netbeans.modules.autoupdate.catalog.ModuleSelectionPanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.WeakListeners;

public final class ModuleBean
implements Runnable,
PropertyChangeListener {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.autoupdate.catalog.ModuleBean");
    private final Module module;
    private String codeName;
    private String codeNameBase;
    private String specVers;
    private String implVers;
    private String buildVers;
    private String[] provides;
    private File jar;
    private boolean enabled;
    private boolean reloadable;
    private boolean autoload;
    private boolean eager;
    private boolean problematic;
    private String[] problemDescriptions;
    private String displayName;
    private String shortDescription;
    private String longDescription;
    private String category;
    private String classpath;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleBean;

    private ModuleBean(Module module) {
        this.module = module;
        this.loadProps();
        this.module.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.module));
    }

    public Module getModule() {
        return this.module;
    }

    private void loadProps() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("loadProps: module=" + this.module);
        if (!this.module.isValid()) {
            err.log("invalid, forget it...");
            return;
        }
        this.codeName = this.module.getCodeName();
        this.codeNameBase = this.module.getCodeNameBase();
        SpecificationVersion specificationVersion = this.module.getSpecificationVersion();
        this.specVers = specificationVersion == null ? null : specificationVersion.toString();
        this.implVers = this.module.getImplementationVersion();
        this.buildVers = this.module.getBuildVersion();
        this.provides = this.module.getProvides();
        this.jar = this.module.getJarFile();
        this.enabled = this.module.isEnabled();
        this.reloadable = this.module.isReloadable();
        this.autoload = this.module.isAutoload();
        this.eager = this.module.isEager();
        Set set = this.module.getProblems();
        boolean bl = this.problematic = !set.isEmpty();
        if (this.problematic) {
            this.problemDescriptions = new String[set.size()];
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.problemDescriptions[n++] = NbProblemDisplayer.messageForProblem((Module)this.module, iterator.next());
            }
        } else {
            this.problemDescriptions = null;
        }
        this.displayName = this.module.getDisplayName();
        this.shortDescription = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Short-Description");
        this.longDescription = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Long-Description");
        this.category = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Display-Category");
        this.classpath = NbTopManager.getUninitialized().getModuleSystem().getEffectiveClasspath(this.module);
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public String getSpecificationVersion() {
        return this.specVers;
    }

    public String getImplementationVersion() {
        return this.implVers;
    }

    public String getBuildVersion() {
        return this.buildVers;
    }

    public String[] getProvides() {
        return this.provides;
    }

    public File getJar() {
        return this.jar;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        if (this.jar == null || this.autoload || this.eager || this.problematic) {
            throw new IllegalStateException();
        }
        err.log("setEnabled: module=" + this.module + " enabled=" + bl);
        this.enabled = bl;
        this.supp.firePropertyChange("enabled", null, null);
        Update update = new Update(bl ? "enable" : "disable", this.module);
        AllModulesBean.getDefault().update(update);
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isEager() {
        return this.eager;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean bl) {
        if (this.reloadable == bl) {
            return;
        }
        err.log("setReloadable: module=" + this.module + " reloadable=" + bl);
        this.reloadable = bl;
        this.supp.firePropertyChange("reloadable", null, null);
        Update update = new Update(bl ? "makeReloadable" : "makeUnreloadable", this.module);
        AllModulesBean.getDefault().update(update);
    }

    public void delete() {
        if (this.jar == null) {
            throw new IllegalStateException();
        }
        err.log("delete: module=" + this.module);
        Update update = new Update("delete", this.module);
        AllModulesBean.getDefault().update(update);
    }

    public boolean isProblematic() {
        return this.problematic;
    }

    public String[] getProblemDescriptions() {
        return this.problemDescriptions;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getCategory() {
        return this.category;
    }

    public String getEffectiveClasspath() {
        return this.classpath;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.removePropertyChangeListener(propertyChangeListener);
        this.supp.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("got changes: module=" + this.module + " evt=" + propertyChangeEvent);
        if (propertyChangeEvent != null && "classLoader".equals(propertyChangeEvent.getPropertyName())) {
            err.log("ignoring PROP_CLASS_LOADER");
            return;
        }
        this.loadProps();
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("firing changes: module=" + this.module);
        this.supp.firePropertyChange(null, null, null);
        ModuleSelectionPanel.getGUI(false).setWaitingState(false, false);
    }

    public boolean equals(Object object) {
        return object instanceof ModuleBean && this.codeNameBase.equals(((ModuleBean)object).codeNameBase);
    }

    public int hashCode() {
        return 0x21FB6CE ^ this.codeNameBase.hashCode();
    }

    public String toString() {
        return "ModuleBean[" + this.codeNameBase + "]";
    }

    public static final class AllModulesBean
    implements Runnable,
    PropertyChangeListener,
    Comparator {
        private static AllModulesBean deflt = null;
        private final ModuleManager mgr = NbTopManager.getUninitialized().getModuleSystem().getManager();
        private final Events ev = NbTopManager.getUninitialized().getModuleSystem().getEvents();
        private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
        private ModuleBean[] modules = null;
        private Task recalcTask = null;
        private final List updates = new LinkedList();
        private boolean paused = false;
        private Runnable updater = new Updater();
        private RequestProcessor.Task updaterTask = new RequestProcessor("module-bean-updater").create(this.updater);
        public static final int RELATION_DIRECTLY_NEEDS = 0;
        public static final int RELATION_TRANSITIVELY_NEEDS = 1;
        public static final int RELATION_DIRECTLY_NEEDED_BY = 2;
        public static final int RELATION_TRANSITIVELY_NEEDED_BY = 3;
        private static final RequestProcessor RELATION_COMPUTER_RP = new RequestProcessor("RelationComputer");

        public static synchronized AllModulesBean getDefault() {
            if (deflt == null) {
                deflt = new AllModulesBean();
            }
            return deflt;
        }

        private AllModulesBean() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.removePropertyChangeListener(propertyChangeListener);
            this.supp.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.removePropertyChangeListener(propertyChangeListener);
        }

        public synchronized ModuleBean[] getModules() {
            err.log("getModules: modules count=" + (this.modules == null ? "null" : String.valueOf(this.modules.length)));
            if (this.modules == null) {
                this.recalcTask = RequestProcessor.getDefault().post((Runnable)new Reader());
                this.modules = new ModuleBean[0];
                return this.modules;
            }
            return this.modules;
        }

        public synchronized Task waitForModules() {
            this.getModules();
            if (this.recalcTask != null) {
                return this.recalcTask;
            }
            return Task.EMPTY;
        }

        public void create(File file, boolean bl) {
            err.log("create: jar=" + file);
            Update update = new Update(bl ? "createReloadable" : "create", file);
            this.update(update);
        }

        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException();
            }
            err.log("in event thread, will fire changes");
            this.supp.firePropertyChange(null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException();
            }
            err.log("got changes: evt=" + propertyChangeEvent);
            ModuleSelectionPanel.getGUI(false).setWaitingState(true, true);
            if ("modules".equals(propertyChangeEvent.getPropertyName())) {
                AllModulesBean allModulesBean;
                HashMap<Module, ModuleBean> hashMap = new HashMap<Module, ModuleBean>(this.modules.length * 4 / 3 + 1);
                for (int i = 0; i < this.modules.length; ++i) {
                    hashMap.put(this.modules[i].getModule(), this.modules[i]);
                }
                Set set = this.mgr.getModules();
                ModuleBean[] moduleBeanArray = new ModuleBean[set.size()];
                Iterator iterator = set.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    allModulesBean = (Module)iterator.next();
                    ModuleBean moduleBean = (ModuleBean)hashMap.get(allModulesBean);
                    if (moduleBean == null) {
                        moduleBean = new ModuleBean((Module)allModulesBean);
                    }
                    moduleBeanArray[n++] = moduleBean;
                }
                allModulesBean = this;
                synchronized (allModulesBean) {
                    this.modules = moduleBeanArray;
                }
                SwingUtilities.invokeLater(this);
            }
        }

        public void pause() {
            err.log("pause");
            this.paused = true;
        }

        public void resume() {
            err.log("resume");
            this.paused = false;
            this.updaterTask.schedule(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            err.log("cancel");
            List list = this.updates;
            synchronized (list) {
                this.updates.clear();
            }
            this.paused = false;
            this.supp.firePropertyChange("pending", null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPending() {
            List list = this.updates;
            synchronized (list) {
                return !this.updates.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(Update update) {
            List list = this.updates;
            synchronized (list) {
                boolean bl = this.updates.isEmpty();
                this.updates.add(update);
                err.log("pending updates: " + this.updates);
                if (bl) {
                    this.updaterTask.schedule(0);
                }
            }
            this.supp.firePropertyChange("pending", null, null);
        }

        private void doDelete(Set set) {
            if (set.isEmpty()) {
                return;
            }
            err.log("doDelete: " + set);
            this.doDisable(set, false);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Module module = (Module)iterator.next();
                if (module.isFixed()) continue;
                this.mgr.delete(module);
            }
        }

        public int compare(Object object, Object object2) {
            Module module = (Module)object;
            Module module2 = (Module)object2;
            int n = module.getDisplayName().compareTo(module2.getDisplayName());
            if (n != 0) {
                return n;
            }
            return module.getCodeNameBase().compareTo(module2.getCodeNameBase());
        }

        private void doDisable(Set set, boolean bl) {
            Object object;
            Object object2;
            if (set.isEmpty()) {
                return;
            }
            err.log("doDisable: " + set);
            TreeSet treeSet = new TreeSet(this);
            treeSet.addAll(set);
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                object2 = (Module)iterator.next();
                if (object2.isEnabled() && !object2.isAutoload() && !object2.isEager() && !object2.isFixed()) continue;
                iterator.remove();
            }
            object2 = this.mgr.simulateDisable(treeSet);
            iterator = object2.iterator();
            TreeSet<Object> treeSet2 = new TreeSet<Object>(this);
            while (iterator.hasNext()) {
                object = (Module)iterator.next();
                if (object.isAutoload() || object.isEager() || treeSet.contains(object)) continue;
                treeSet2.add(object);
            }
            if (!treeSet2.isEmpty()) {
                object = new ModuleEnableDisablePanel(false, treeSet, treeSet2);
                ((Component)object).getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleBean == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleBean = ModuleBean.class$("org.netbeans.modules.autoupdate.catalog.ModuleBean")) : class$org$netbeans$modules$autoupdate$catalog$ModuleBean), (String)"ACSN_TITLE_disabling"));
                ((Component)object).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleBean == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleBean = ModuleBean.class$("org.netbeans.modules.autoupdate.catalog.ModuleBean")) : class$org$netbeans$modules$autoupdate$catalog$ModuleBean), (String)"ACSD_TITLE_disabling"));
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(object, NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleBean == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleBean = ModuleBean.class$("org.netbeans.modules.autoupdate.catalog.ModuleBean")) : class$org$netbeans$modules$autoupdate$catalog$ModuleBean), (String)"MB_TITLE_disabling"), bl ? 0 : -1);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                    ModuleBean[] moduleBeanArray = this.modules;
                    if (moduleBeanArray != null) {
                        for (int i = 0; i < moduleBeanArray.length; ++i) {
                            if (!treeSet.contains(moduleBeanArray[i].module)) continue;
                            moduleBeanArray[i].propertyChange(null);
                        }
                    }
                    return;
                }
                treeSet.addAll(treeSet2);
            }
            this.mgr.disable(treeSet);
        }

        private void doEnable(Set set) {
            Module module;
            Object object;
            Object object2;
            if (set.isEmpty()) {
                return;
            }
            err.log("doEnable: " + set);
            TreeSet treeSet = new TreeSet(this);
            treeSet.addAll(set);
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                object2 = (Module)iterator.next();
                if (!object2.isEnabled() && !object2.isAutoload() && !object2.isEager() && !object2.isFixed() && object2.getProblems().isEmpty()) continue;
                iterator.remove();
            }
            object2 = this.mgr.simulateEnable(treeSet);
            iterator = object2.iterator();
            TreeSet<Object> treeSet2 = new TreeSet<Object>(this);
            while (iterator.hasNext()) {
                object = (Module)iterator.next();
                if (object.isAutoload() || object.isEager() || treeSet.contains(object)) continue;
                treeSet2.add(object);
            }
            if (!treeSet2.isEmpty()) {
                object = new ModuleEnableDisablePanel(true, treeSet, treeSet2);
                ((Component)object).getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleBean == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleBean = ModuleBean.class$("org.netbeans.modules.autoupdate.catalog.ModuleBean")) : class$org$netbeans$modules$autoupdate$catalog$ModuleBean), (String)"ACSN_TITLE_disabling"));
                ((Component)object).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleBean == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleBean = ModuleBean.class$("org.netbeans.modules.autoupdate.catalog.ModuleBean")) : class$org$netbeans$modules$autoupdate$catalog$ModuleBean), (String)"ACSD_TITLE_disabling"));
                module = new NotifyDescriptor.Confirmation(object, NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleBean == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleBean = ModuleBean.class$("org.netbeans.modules.autoupdate.catalog.ModuleBean")) : class$org$netbeans$modules$autoupdate$catalog$ModuleBean), (String)"MB_TITLE_enabling"), 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)module) != NotifyDescriptor.YES_OPTION) {
                    ModuleBean[] moduleBeanArray = this.modules;
                    if (moduleBeanArray != null) {
                        for (int i = 0; i < moduleBeanArray.length; ++i) {
                            if (!treeSet.contains(moduleBeanArray[i].module)) continue;
                            moduleBeanArray[i].propertyChange(null);
                        }
                    }
                    return;
                }
                treeSet.addAll(treeSet2);
            }
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Module)iterator.next();
                if (!object.isReloadable()) continue;
                try {
                    this.mgr.reload((Module)object);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    ModuleBean[] moduleBeanArray = this.modules;
                    if (moduleBeanArray != null) {
                        for (int i = 0; i < moduleBeanArray.length; ++i) {
                            if (!treeSet.contains(moduleBeanArray[i].module)) continue;
                            moduleBeanArray[i].propertyChange(null);
                        }
                    }
                    return;
                }
            }
            try {
                this.mgr.enable(treeSet);
            }
            catch (InvalidException invalidException) {
                err.notify(1, (Throwable)invalidException);
                module = invalidException.getModule();
                if (module == null) {
                    throw new IllegalStateException();
                }
                this.ev.log("failedInstallNewUnexpected", (Object)module, (Object)invalidException);
                ModuleBean[] moduleBeanArray = this.modules;
                if (moduleBeanArray != null) {
                    for (int i = 0; i < moduleBeanArray.length; ++i) {
                        if (moduleBeanArray[i].module != module) continue;
                        moduleBeanArray[i].propertyChange(null);
                    }
                }
                treeSet.remove(invalidException.getModule());
                this.doEnable(treeSet);
            }
        }

        private void doCreate(Set set, boolean bl) {
            if (set.isEmpty()) {
                return;
            }
            err.log("doCreate: " + set + " reloadable=" + bl);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Module module;
                File file = (File)iterator.next();
                try {
                    module = this.mgr.create(file, (Object)new ModuleHistory(file.getAbsolutePath()), bl, false, false);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(256, (Throwable)iOException);
                    continue;
                }
                catch (DuplicateException duplicateException) {
                    Module module2 = duplicateException.getOldModule();
                    if (module2.isFixed()) continue;
                    if (module2.isEnabled()) {
                        if (module2.isAutoload() || module2.isEager()) continue;
                        this.doDisable(Collections.singleton(module2), true);
                        if (module2.isEnabled()) continue;
                    }
                    this.mgr.delete(module2);
                    try {
                        module = this.mgr.create(file, (Object)new ModuleHistory(file.getAbsolutePath()), bl, false, false);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(256, (Throwable)iOException);
                        continue;
                    }
                    catch (DuplicateException duplicateException2) {
                        ErrorManager.getDefault().notify((Throwable)duplicateException2);
                        continue;
                    }
                }
                if (module.getProblems().isEmpty()) {
                    this.doEnable(Collections.singleton(module));
                    continue;
                }
                this.ev.log("failedInstallNew", Collections.singleton(module));
            }
        }

        public void getRelations(ModuleBean moduleBean, int n, RelationCallback relationCallback) {
            if (n != 0 && n != 1 && n != 2 && n != 3) {
                throw new IllegalArgumentException("bad type: " + n);
            }
            RELATION_COMPUTER_RP.post((Runnable)new RelationComputer(moduleBean.module, n, relationCallback));
        }

        static /* synthetic */ ModuleBean[] access$302(AllModulesBean allModulesBean, ModuleBean[] moduleBeanArray) {
            allModulesBean.modules = moduleBeanArray;
            return moduleBeanArray;
        }

        private class Reader
        implements Runnable {
            private boolean theother = false;

            Reader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                if (SwingUtilities.isEventDispatchThread()) {
                    throw new IllegalStateException();
                }
                if (!this.theother) {
                    err.log("will load modules in read mutex...");
                    Reader reader = new Reader();
                    reader.theother = true;
                    AllModulesBean.this.mgr.mutex().readAccess((Runnable)reader);
                    return;
                }
                err.log("first time, finding module list");
                Set set = AllModulesBean.this.mgr.getModules();
                ModuleBean[] moduleBeanArray = new ModuleBean[set.size()];
                Iterator iterator = set.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    object = (Module)iterator.next();
                    moduleBeanArray[n++] = new ModuleBean((Module)object);
                }
                object = AllModulesBean.this;
                synchronized (object) {
                    AllModulesBean.access$302(AllModulesBean.this, moduleBeanArray);
                    AllModulesBean.this.recalcTask = null;
                }
                AllModulesBean.this.mgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)AllModulesBean.this, (Object)AllModulesBean.this.mgr));
                SwingUtilities.invokeLater(AllModulesBean.this);
            }
        }

        public static interface RelationCallback {
            public void result(Set var1);
        }

        private class RelationComputer
        implements Runnable {
            private int stage = 0;
            private final Module m;
            private final int type;
            private final RelationCallback callback;
            private Set result;
            static final /* synthetic */ boolean $assertionsDisabled;

            public RelationComputer(Module module, int n, RelationCallback relationCallback) {
                this.m = module;
                this.type = n;
                this.callback = relationCallback;
            }

            public void run() {
                switch (this.stage) {
                    case 0: {
                        this.stage = 1;
                        AllModulesBean.this.mgr.mutex().readAccess((Runnable)this);
                        break;
                    }
                    case 1: {
                        this.compute();
                        this.stage = 2;
                        SwingUtilities.invokeLater(this);
                        break;
                    }
                    default: {
                        HashSet<ModuleBean> hashSet = new HashSet<ModuleBean>(this.result.size() * 2 + 1);
                        ModuleBean[] moduleBeanArray = AllModulesBean.this.getModules();
                        for (int i = 0; i < moduleBeanArray.length; ++i) {
                            if (!this.result.contains(moduleBeanArray[i].module)) continue;
                            hashSet.add(moduleBeanArray[i]);
                        }
                        this.callback.result(hashSet);
                    }
                }
            }

            private void compute() {
                switch (this.type) {
                    case 0: {
                        this.result = AllModulesBean.this.mgr.getModuleInterdependencies(this.m, false, false);
                        break;
                    }
                    case 2: {
                        this.result = AllModulesBean.this.mgr.getModuleInterdependencies(this.m, true, false);
                        break;
                    }
                    case 1: {
                        this.result = AllModulesBean.this.mgr.getModuleInterdependencies(this.m, false, true);
                        break;
                    }
                    case 3: {
                        this.result = AllModulesBean.this.mgr.getModuleInterdependencies(this.m, true, true);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError(this.type);
                        }
                        break;
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$autoupdate$catalog$ModuleBean == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleBean = ModuleBean.class$("org.netbeans.modules.autoupdate.catalog.ModuleBean")) : class$org$netbeans$modules$autoupdate$catalog$ModuleBean).desiredAssertionStatus();
            }
        }

        private class Updater
        implements Runnable {
            Updater() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                if (SwingUtilities.isEventDispatchThread()) {
                    throw new IllegalStateException();
                }
                if (!AllModulesBean.this.mgr.mutex().isWriteAccess()) {
                    err.log("saving all documents...");
                    LifecycleManager.getDefault().saveAll();
                    err.log("will run updates in write mutex...");
                    AllModulesBean.this.mgr.mutex().writeAccess((Runnable)this);
                    return;
                }
                try {
                    Iterator iterator;
                    if (AllModulesBean.this.paused) {
                        err.log("run updates, but paused");
                        return;
                    }
                    ModuleSelectionPanel.getGUI(false).setWaitingState(true, true);
                    HashSet<Object> hashSet = new HashSet<Object>();
                    object = new HashSet();
                    HashSet<Object> hashSet2 = new HashSet<Object>();
                    HashSet<Object> hashSet3 = new HashSet<Object>();
                    HashSet<Object> hashSet4 = new HashSet<Object>();
                    HashSet<Object> hashSet5 = new HashSet<Object>();
                    HashSet<Object> hashSet6 = new HashSet<Object>();
                    Object object2 = AllModulesBean.this.updates;
                    synchronized (object2) {
                        block30: {
                            if (!AllModulesBean.this.updates.isEmpty()) break block30;
                            err.log("run updates, but empty");
                            return;
                        }
                        err.log("run updates: " + AllModulesBean.this.updates);
                        iterator = new LinkedList(AllModulesBean.this.updates).iterator();
                        AllModulesBean.this.updates.clear();
                    }
                    while (iterator.hasNext()) {
                        object2 = (Update)iterator.next();
                        if (((Update)object2).command.equals("enable")) {
                            if (hashSet4.contains(((Update)object2).arg)) {
                                throw new IllegalStateException();
                            }
                            object.remove(((Update)object2).arg);
                            hashSet.add(((Update)object2).arg);
                            continue;
                        }
                        if (((Update)object2).command.equals("disable")) {
                            if (hashSet4.contains(((Update)object2).arg)) {
                                throw new IllegalStateException();
                            }
                            hashSet.remove(((Update)object2).arg);
                            object.add(((Update)object2).arg);
                            continue;
                        }
                        if (((Update)object2).command.equals("makeReloadable")) {
                            if (hashSet4.contains(((Update)object2).arg)) {
                                throw new IllegalStateException();
                            }
                            hashSet3.remove(((Update)object2).arg);
                            hashSet2.add(((Update)object2).arg);
                            continue;
                        }
                        if (((Update)object2).command.equals("makeUnreloadable")) {
                            if (hashSet4.contains(((Update)object2).arg)) {
                                throw new IllegalStateException();
                            }
                            hashSet2.remove(((Update)object2).arg);
                            hashSet3.add(((Update)object2).arg);
                            continue;
                        }
                        if (((Update)object2).command.equals("delete")) {
                            hashSet.remove(((Update)object2).arg);
                            object.remove(((Update)object2).arg);
                            hashSet2.remove(((Update)object2).arg);
                            hashSet3.remove(((Update)object2).arg);
                            hashSet4.add(((Update)object2).arg);
                            continue;
                        }
                        if (((Update)object2).command.equals("create")) {
                            hashSet6.remove(((Update)object2).arg);
                            hashSet5.add(((Update)object2).arg);
                            continue;
                        }
                        if (((Update)object2).command.equals("createReloadable")) {
                            hashSet5.remove(((Update)object2).arg);
                            hashSet6.add(((Update)object2).arg);
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    AllModulesBean.this.doDelete(hashSet4);
                    AllModulesBean.this.doDisable((Set)object, true);
                    iterator = hashSet2.iterator();
                    while (iterator.hasNext()) {
                        object2 = (Module)iterator.next();
                        object2.setReloadable(true);
                    }
                    iterator = hashSet3.iterator();
                    while (iterator.hasNext()) {
                        object2 = (Module)iterator.next();
                        object2.setReloadable(false);
                    }
                    AllModulesBean.this.doEnable(hashSet);
                    AllModulesBean.this.doCreate(hashSet5, false);
                    AllModulesBean.this.doCreate(hashSet6, true);
                }
                catch (RuntimeException runtimeException) {
                    err.notify((Throwable)runtimeException);
                    object = AllModulesBean.this.modules;
                    if (object != null) {
                        for (int i = 0; i < ((ModuleBean[])object).length; ++i) {
                            object[i].propertyChange(null);
                        }
                    }
                }
                finally {
                    ModuleSelectionPanel.getGUI(false).setWaitingState(false, true);
                }
                SwingUtilities.invokeLater(AllModulesBean.this);
            }
        }
    }

    private static final class Update {
        public final String command;
        public final Object arg;

        public Update(String string, Object object) {
            this.command = string;
            this.arg = object;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Update)) {
                return false;
            }
            Update update = (Update)object;
            return this.command.equals(update.command) && this.arg.equals(update.arg);
        }

        public int hashCode() {
            return this.command.hashCode() ^ this.arg.hashCode();
        }

        public String toString() {
            return "Update[" + this.command + "," + this.arg + "]";
        }
    }
}

